/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.toolchainproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import java.util.Collection;
import java.util.stream.Stream;

public interface IGeneratedFilesStatusProvider {
    public boolean isNeededUpdateProjectCode(@NonNull GeneratedFileStatus var1);

    public @NonNull Collection<@NonNull String> getGeneratedFiles(boolean var1);

    public @NonNull Stream<@NonNull String> getGeneratedFiles(boolean var1, @NonNull String var2);

    public @Nullable GeneratedFileStatus getGeneratedFileProjectStatus(@NonNull String var1, boolean var2);

    public void requestUpdate();

    public boolean isUpdated();

    public static enum GeneratedFileInfo {
        NOT_EXIST,
        MODIFIED,
        DELETE,
        UP_TO_DATE,
        USER_TEMPLATE;

    }

    public static class GeneratedFileStatus {
        @NonNull
        public final GeneratedFileInfo statusInfo;
        public final boolean isInProject;
        @NonNull
        public final String toolId;

        public GeneratedFileStatus(@NonNull GeneratedFileInfo statusInfo, boolean isInProject, @NonNull String toolId) {
            this.statusInfo = statusInfo;
            this.isInProject = isInProject;
            this.toolId = toolId;
        }

        public boolean isToolUpdateProjectCodeEnabled(@NonNull String fileName) {
            ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
            StorageTool strgTool = sharedConfig.getTools().getTool(this.toolId);
            if (strgTool == null || !strgTool.getUpdateCode()) {
                return false;
            }
            return strgTool.isProjectFileUpdateEnabled(fileName);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.isInProject ? 1231 : 1237);
            result = 31 * result + this.statusInfo.hashCode();
            result = 31 * result + this.toolId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedFileStatus other = (GeneratedFileStatus)obj;
            return this.isInProject == other.isInProject && this.statusInfo == other.statusInfo && this.toolId.equals(other.toolId);
        }

        public String toString() {
            return String.valueOf(this.toolId) + ':' + String.valueOf((Object)this.statusInfo);
        }
    }

    public static interface IGeneratedFilesStatusListener {
        public void generatedFilesStatusUpdated();
    }
}

