/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.sourceprovider;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.services.IServiceLocator;

public class ConfigurationSourceProvider
extends AbstractSourceProvider {
    @NonNull
    public static final String CONFIGURATION_IS_DIRTY = "com.nxp.swtools.configuration.isDirty";
    @NonNull
    public static final String CONFIGURATION_IS_DEVICE_SELECTED = "com.nxp.swtools.configuration.isDeviceSelected";
    @NonNull
    public static final String CONFIGURATION_IS_BOARD_OR_KIT_SELECTED = "com.nxp.swtools.configuration.isBoardOrKitSelected";
    @NonNull
    public static final String CONFIGURATION_ENABLED_TOOLS = "com.nxp.swtools.configuration.enabledTools";
    @Nullable
    SharedConfigurationAdapter sharedConfigListener;
    @Nullable
    ISharedConfiguration sharedConfiguration;
    @Nullable
    Display display;

    public void initialize(IServiceLocator locator) {
        this.display = Display.getCurrent();
        assert (this.display != null);
        this.sharedConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SharedConfigurationAdapter configListener = this.sharedConfigListener = new SharedConfigurationAdapter(){

            @Override
            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfig, @NonNull ConfigChangeReason reason) {
                ConfigurationSourceProvider.this.updateConfigurationState();
            }

            @Override
            public void configurationChanged(@NonNull ISharedConfiguration sharedConfig, @NonNull IConfigChangeContext changeContext) {
                if (changeContext.getChangeType() == IConfigChangeContext.ConfigChangeType.TOOL_TOGGLE) {
                    ConfigurationSourceProvider.this.updateConfigurationState();
                }
            }

            @Override
            public void dirtyChanged(@NonNull ISharedConfiguration sharedConfig) {
                ConfigurationSourceProvider.this.updateConfigurationState();
            }

            @Override
            public int getListenerOrder() {
                return Integer.MAX_VALUE;
            }
        };
        if (this.sharedConfiguration != null) {
            this.sharedConfiguration.addListener(configListener);
        } else assert (false);
        super.initialize(locator);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        ISharedConfiguration cfg = this.sharedConfiguration;
        if (cfg == null) {
            assert (false);
        } else {
            map.put(CONFIGURATION_IS_DIRTY, cfg.isDirty());
            String mcu = cfg.getCommonConfig().getMcu();
            map.put(CONFIGURATION_IS_DEVICE_SELECTED, !UtilsText.isEmpty((String)mcu));
            String boardOrKit = cfg.getCommonConfig().getKitOrBoard();
            map.put(CONFIGURATION_IS_BOARD_OR_KIT_SELECTED, !UtilsText.isEmpty((String)boardOrKit));
            List<@NonNull T> enabledTools = cfg.getTools().getTools().stream().filter(t -> t.isEnabled()).map(t -> t.getName()).collect(Collectors.toList());
            map.put(CONFIGURATION_ENABLED_TOOLS, enabledTools);
        }
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{CONFIGURATION_IS_DIRTY, CONFIGURATION_IS_DEVICE_SELECTED, CONFIGURATION_IS_BOARD_OR_KIT_SELECTED};
    }

    public void dispose() {
        SharedConfigurationAdapter configListener = this.sharedConfigListener;
        if (configListener != null) {
            SharedConfigurationFactory.getSharedConfigurationSingleton().removeListener(configListener);
        }
        this.display = null;
    }

    public void updateConfigurationState() {
        Runnable r = () -> this.fireSourceChanged(0, this.getCurrentState());
        Display d = this.display;
        if (d != null && !Thread.currentThread().equals(d.getThread())) {
            d.asyncExec(r);
        } else {
            r.run();
        }
    }
}

