/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.sdk;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.kex.analytics.IAnalytics;
import com.nxp.swtools.kex.sdk.ISdkVaultClient;
import com.nxp.swtools.kex.sdk.SdkApiFactory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.sdk.IUploadConfigurationProvider;
import com.nxp.swtools.provider.sdk.SdkFileInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Logger;

public class VaultUpload {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(VaultUpload.class);
    @NonNull
    public static final String TYPE_PG = "PG";

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static boolean uploadSdkPackage(@NonNull File sourceDir, @NonNull String targetFileName, @NonNull String name, @NonNull String type, @NonNull Collection<@NonNull SdkFileInfo> sdkFiles, @NonNull IUploadConfigurationProvider config) {
        ISdkVaultClient client = SdkApiFactory.createSdkVaultClient();
        ArrayList<@NonNull @NonNull @NonNull E> sdkFilesAttributes = new ArrayList();
        sdkFiles.forEach(s -> {
            Hashtable<@NonNull String, @NonNull String> set = new Hashtable<String, String>();
            set.put("original_path", s.getOriginalPath());
            set.put("new_path", s.getNewPath());
            sdkFilesAttributes.add(set);
        });
        Hashtable<@NonNull String, @NonNull Object> attributes = new Hashtable<String, Object>();
        attributes.put("sdk_files", sdkFilesAttributes);
        if (!SWToolsProperties.isHeadlessOn() && Rap.isActive()) {
            IAnalytics analytics = SWToolsPlatform.getAnalytics();
            String userId = analytics.getUserName();
            if (!UtilsText.isEmpty((String)userId)) {
                attributes.put("user_email", userId);
            } else {
                LOGGER.warning("userId for uploadSdkPackage is not known");
            }
        }
        attributes.put("kit", config.getKit());
        attributes.put("board", config.getBoard());
        attributes.put("device", config.getProcessor());
        attributes.put("example", config.getSdkExamplePath());
        attributes.put("toolchain", config.getToolchainId());
        if (!SWToolsProperties.isHeadlessOn()) {
            String sdkPackageHash = SWToolsPlatform.getSdkPackageHash();
            if (sdkPackageHash != null) {
                attributes.put("sdk_package_hash", sdkPackageHash);
            } else assert (false) : "Cannot retrieve sdk_package_hash from the Mongo DB";
        }
        Hashtable<@NonNull String, @NonNull ArrayList<E>> descriptionDict = new Hashtable();
        ArrayList coreList = new ArrayList();
        config.getCoreNames().stream().filter(core -> config.getCoreRole((String)core).canBeGenerated()).map(core -> {
            Hashtable<String, String> coreInfo = new Hashtable<String, String>();
            coreInfo.put("core", config.getCoreUiName((String)core));
            coreInfo.put("project", config.getProjectName((String)core));
            return coreInfo;
        }).forEach(info -> {
            boolean bl = coreList.add(info);
        });
        attributes.put("description", descriptionDict);
        descriptionDict.put("cores", coreList);
        return client.uploadFile(sourceDir, targetFileName, name, "", type, attributes);
    }
}

