/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.sdk;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.kex.sdk.ISdkContent;
import com.nxp.swtools.kex.sdk.ISdkResource;
import com.nxp.swtools.provider.sdk.ISdkFileProvider;
import com.nxp.swtools.provider.sdk.SdkInfoProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class SdkFileProvider
implements ISdkFileProvider {
    @NonNull
    private final String sdkPath;
    @Nullable
    private final SdkInfoProvider sdkInfoProvider;

    /*
     * Unable to fully structure code
     */
    public SdkFileProvider(@NonNull String sdkPath) {
        super();
        if (SdkFileProvider.$assertionsDisabled || !Rap.isActive()) ** GOTO lbl9
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (sdkPath.endsWith(UtilsText.ECLIPSE_PATH_SEPARATOR)) {
                sdkPath = sdkPath.substring(0, sdkPath.length() - UtilsText.ECLIPSE_PATH_SEPARATOR.length());
                continue;
            }
            if (!sdkPath.endsWith("\\")) break;
            sdkPath = sdkPath.substring(0, sdkPath.length() - "\\".length());
lbl9:
            // 3 sources

            ** while (!sdkPath.isEmpty())
        }
lbl10:
        // 2 sources

        this.sdkPath = sdkPath;
        this.sdkInfoProvider = null;
        if (!SdkFileProvider.$assertionsDisabled && !new File(sdkPath).isDirectory()) {
            throw new AssertionError();
        }
        if (!SdkFileProvider.$assertionsDisabled && (sdkPath.endsWith(UtilsText.ECLIPSE_PATH_SEPARATOR) || sdkPath.endsWith("\\"))) {
            throw new AssertionError();
        }
    }

    public SdkFileProvider(@NonNull SdkInfoProvider sdkInfoProvider) {
        assert (Rap.isActive());
        this.sdkPath = "sdk_on_web://";
        this.sdkInfoProvider = sdkInfoProvider;
    }

    private final @NonNull String getSdkAbsPath(@NonNull String relPath) {
        if (Rap.isActive()) assert (false);
        if (relPath.isEmpty()) {
            return this.sdkPath;
        }
        return String.valueOf(this.sdkPath) + File.separator + relPath;
    }

    @NonNull SdkInfoProvider getSdkInfoProvider() {
        assert (Rap.isActive());
        SdkInfoProvider result = this.sdkInfoProvider;
        assert (result != null);
        return result;
    }

    public final @Nullable ISdkResource findSdkResourceOnRap(@NonNull String relPath) {
        assert (Rap.isActive());
        String sdkRelPath = String.valueOf(UtilsText.ECLIPSE_PATH_SEPARATOR) + UtilsFile.convertToEclipsePathFormat((String)relPath);
        assert (!sdkRelPath.startsWith("//")) : "Doubled slash at the beginning of the SDK path";
        ISdkContent content = this.getSdkInfoProvider().getSdkContent();
        return content == null ? null : content.findResource(sdkRelPath);
    }

    @Override
    public boolean existsSdkFile(String relPath) {
        if (Rap.isActive()) {
            ISdkResource resrc = this.findSdkResourceOnRap(relPath);
            return resrc != null && resrc.isFile();
        }
        return new File(this.getSdkAbsPath(relPath)).isFile();
    }

    @Override
    public boolean existsSdkDir(String relPath) {
        if (Rap.isActive()) {
            ISdkResource resrc = this.findSdkResourceOnRap(relPath);
            return resrc != null && resrc.isDirectory();
        }
        return new File(this.getSdkAbsPath(relPath)).isDirectory();
    }

    static File @NonNull [] findMatchingFilesByRegEx(@NonNull String absPath, @NonNull String fileNameRegEx) {
        File dirctry = new File(absPath);
        final Pattern nameRegExPtrn = Pattern.compile(fileNameRegEx);
        File[] result = dirctry.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return nameRegExPtrn.matcher(UtilsText.safeString((String)name)).matches();
            }
        });
        return result == null ? new File[]{} : result;
    }

    @Override
    public Collection<@NonNull String> findMatchingFilesByMask(String relPath, String fileNameMask) {
        ArrayList<String> result;
        block5: {
            File[] files;
            block3: {
                List list;
                block4: {
                    result = new ArrayList<String>();
                    if (!Rap.isActive()) break block3;
                    ISdkResource resrc = this.findSdkResourceOnRap(relPath);
                    if (resrc == null || !resrc.isDirectory()) {
                        return result;
                    }
                    list = resrc.listFiles();
                    if (fileNameMask.indexOf(42) >= 0) break block4;
                    ISdkResource file = resrc.find(fileNameMask);
                    if (file == null || !file.isFile()) break block5;
                    result.add(String.valueOf(relPath) + File.separator + file.getName());
                    break block5;
                }
                String fileNameRegEx = fileNameMask.replace(".", "\\.").replace("*", ".*");
                Pattern fileMaskPattern = Pattern.compile(fileNameRegEx);
                for (ISdkResource file : list) {
                    if (!file.isFile() || !fileMaskPattern.matcher(file.getName()).matches()) continue;
                    result.add(String.valueOf(relPath) + File.separator + file.getName());
                }
                break block5;
            }
            String fileNameRegEx = fileNameMask.replace(".", "\\.").replace("*", ".*");
            File[] fileArray = files = SdkFileProvider.findMatchingFilesByRegEx(this.getSdkAbsPath(relPath), fileNameRegEx);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                result.add(file.getAbsolutePath().substring(this.sdkPath.length() + 1));
                ++n2;
            }
        }
        return result;
    }

    @Override
    public Collection<@NonNull String> listSkdFiles(String relPath) {
        ArrayList<@NonNull String> result = new ArrayList<String>();
        if (Rap.isActive()) {
            ISdkResource resrc = this.findSdkResourceOnRap(relPath);
            if (resrc == null || !resrc.isDirectory()) {
                return result;
            }
            for (ISdkResource file : resrc.listFiles()) {
                result.add(String.valueOf(relPath) + File.separator + file.getName());
            }
        } else {
            File[] files;
            File[] fileArray = files = SdkFileProvider.findMatchingFilesByRegEx(this.getSdkAbsPath(relPath), ".*");
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                result.add(file.getAbsolutePath().substring(this.sdkPath.length() + 1));
                ++n2;
            }
        }
        return result;
    }

    @Override
    public InputStream openSdkFile(String relPath) {
        if (Rap.isActive()) {
            return this.getSdkInfoProvider().getFile(String.valueOf(UtilsText.ECLIPSE_PATH_SEPARATOR) + UtilsFile.convertToEclipsePathFormat((String)relPath));
        }
        try {
            return new FileInputStream(this.getSdkAbsPath(relPath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }
}

