/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.processors;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.ComponentInfo;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.kex.api.IBaseInfo;
import com.nxp.swtools.kex.api.IBoardInfo;
import com.nxp.swtools.kex.api.IComponentInfo;
import com.nxp.swtools.kex.api.IComponentReference;
import com.nxp.swtools.kex.api.IHttpConnectionHelper;
import com.nxp.swtools.kex.api.IKitInfo;
import com.nxp.swtools.kex.api.IMfactApiClient;
import com.nxp.swtools.kex.api.IProcessorInfo;
import com.nxp.swtools.kex.api.MfactApiFactory;
import com.nxp.swtools.kex.exceptions.MfactServerError;
import com.nxp.swtools.kex.proxy.IProxyConfiguration;
import com.nxp.swtools.kex.proxy.ProxyConfigureFactory;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.storage.CloudStorageFactory;
import com.nxp.swtools.kex.storage.ICloudEntry;
import com.nxp.swtools.kex.storage.ICloudStorageClient;
import com.nxp.swtools.kex.storage.utils.CopyTask;
import com.nxp.swtools.provider.Messages;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.processors.CheckStatus;
import com.nxp.swtools.provider.processors.DownloadStatus;
import com.nxp.swtools.provider.processors.ISWToolsBoardInfo;
import com.nxp.swtools.provider.processors.ISWToolsKitInfo;
import com.nxp.swtools.provider.processors.ISWToolsProcessorInfo;
import com.nxp.swtools.provider.processors.impl.SWToolsBoardInfo;
import com.nxp.swtools.provider.processors.impl.SWToolsKitInfo;
import com.nxp.swtools.provider.processors.impl.SWToolsProcessorInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Version;

public class KExProcessorsProvider {
    private static final String RESTAPI_KEX_TOOLS_PATH_PREFIX = "kex_tools/";
    private static final String SDK_ATTR_NAME_PREFIX = "sdk.";
    private static final String SEPARATOR = ",";
    public static final String SDK_ID_PREFIX = "sdk.id.";
    private static final String REST_API_DATA_VERSION = "6.0";
    private static final Logger LOGGER;
    static final String FILTER_FAMILIES = "com.nxp.restapi.familyfilter";
    static final String FILTER_PRODUCT = "com.nxp.restapi.productfilter";
    static final String FILTER_PRODUCT_ENABLEMENT = "com.nxp.restapi.productfilter.enable";
    private static boolean offline;
    private static IProxyConfiguration proxySettings;
    @Nullable
    private static Collection<IProcessorInfo> listProcessorsCache_4headless;
    private static Map<String, @Nullable IBoardInfo> boardCache_4headless;
    private static Map<String, @Nullable IKitInfo> kitCache_4headless;
    public static final Predicate<IProcessorMasterToolInfo> MASTER_MCU_FAMILY_FILTER;
    public static final Predicate<IProcessorMasterToolInfo> MASTER_MCU_PRODUCT_FILTER;
    public static final Predicate<IProcessorMasterToolInfo> PROCESSOR_FILTER;

    static {
        String restapi;
        LOGGER = LogManager.getLogger(KExProcessorsProvider.class);
        offline = false;
        proxySettings = Rap.isActive() ? ProxyConfigureFactory.getDirectProxyConfiguration() : ProxyConfigureFactory.getNativeProxyConfiguration();
        if (SWToolsPlatform.isRunningInEclipseIde() && System.getProperty("com.nxp.restapi.server") == null && (restapi = SWToolsProperties.getProperty((String)"com.nxp.restapi.server")) != null) {
            System.setProperty("com.nxp.restapi.server", restapi);
        }
        listProcessorsCache_4headless = null;
        boardCache_4headless = new HashMap<String, IBoardInfo>();
        kitCache_4headless = new HashMap<String, IKitInfo>();
        MASTER_MCU_FAMILY_FILTER = new Predicate<IProcessorMasterToolInfo>(){
            String filterFamilies = UtilsText.safeString((String)SWToolsProperties.getProperty((String)"com.nxp.restapi.familyfilter")).replace("!", "");
            boolean excludeMode = UtilsText.safeString((String)SWToolsProperties.getProperty((String)"com.nxp.restapi.familyfilter")).startsWith("!");
            Set<String> familySet = Arrays.stream(this.filterFamilies.split(",")).map(f -> f.toLowerCase()).filter(f -> f.length() > 0).collect(Collectors.toSet());

            @Override
            public boolean test(IProcessorMasterToolInfo t) {
                if (this.excludeMode) {
                    return this.familySet.isEmpty() || !this.familySet.contains(t.getFamily().toLowerCase());
                }
                return this.familySet.isEmpty() || this.familySet.contains(t.getFamily().toLowerCase());
            }
        };
        MASTER_MCU_PRODUCT_FILTER = new Predicate<IProcessorMasterToolInfo>(){
            final boolean filteringEnabled = Boolean.parseBoolean(SWToolsProperties.getProperty((String)"com.nxp.restapi.productfilter.enable", (String)Boolean.TRUE.toString()));

            @Override
            public boolean test(IProcessorMasterToolInfo t) {
                if (!this.filteringEnabled) {
                    return true;
                }
                return t.getTargetProducts().contains(KExProcessorsProvider.getProductForProcessorFilter());
            }
        };
        PROCESSOR_FILTER = new Predicate<IProcessorMasterToolInfo>(){

            @Override
            public boolean test(IProcessorMasterToolInfo t) {
                return MASTER_MCU_PRODUCT_FILTER.test(t) && MASTER_MCU_FAMILY_FILTER.test(t);
            }
        };
    }

    public static String getProductForProcessorFilter() {
        String product = SWToolsProperties.getProperty((String)FILTER_PRODUCT);
        if (!UtilsText.isEmpty((String)product)) {
            assert (product != null);
            return product;
        }
        return SwToolsProduct.isImxProduct() ? "pins" : "mcux";
    }

    public static boolean isOffline() {
        if (Rap.isActive()) {
            return false;
        }
        return offline;
    }

    public static void setOffline(boolean value) {
        offline = value;
    }

    public static void setProxyConfiguration(IProxyConfiguration conf) {
        proxySettings = conf;
    }

    public static IProxyConfiguration getProxyConfiguration() {
        assert (proxySettings != null);
        return proxySettings;
    }

    public static String getRestApiDataVersion() {
        return REST_API_DATA_VERSION;
    }

    public static IMfactApiClient getRestApiClient() {
        return MfactApiFactory.createCloudStorageClient((int)2, (String)KExProcessorsProvider.getRestApiDataVersion(), null, (IProxyConfiguration)proxySettings);
    }

    public static ICloudStorageClient getStorageApiClient() {
        return CloudStorageFactory.createCloudStorageClient((int)2, (String)KExProcessorsProvider.getRestApiDataVersion(), null, (IProxyConfiguration)proxySettings);
    }

    public static Collection<IProcessorInfo> listProcessors() {
        if (SWToolsProperties.isHeadlessOn() && listProcessorsCache_4headless != null) {
            return listProcessorsCache_4headless;
        }
        if (KExProcessorsProvider.isOffline()) {
            return Collections.emptyList();
        }
        IMfactApiClient client = KExProcessorsProvider.getRestApiClient();
        Collection processors = client.listProcessors(SWToolsProperties.getProperty((String)FILTER_FAMILIES), KExProcessorsProvider.getProductForProcessorFilter());
        if (SWToolsProperties.isHeadlessOn()) {
            listProcessorsCache_4headless = processors;
        }
        return processors;
    }

    public static @Nullable IProcessorInfo listProcessor(String processor) {
        if (KExProcessorsProvider.isOffline()) {
            return null;
        }
        IMfactApiClient client = KExProcessorsProvider.getRestApiClient();
        return client.getProcessor(processor);
    }

    public static @Nullable IProcessorInfo listProcessor(String processor, IMfactApiClient client) {
        if (KExProcessorsProvider.isOffline()) {
            return null;
        }
        return client.getProcessor(processor);
    }

    public static @Nullable IBoardInfo listBoard(String board) {
        if (SWToolsProperties.isHeadlessOn() && boardCache_4headless.containsKey(board)) {
            return boardCache_4headless.get(board);
        }
        if (KExProcessorsProvider.isOffline()) {
            return null;
        }
        IMfactApiClient client = KExProcessorsProvider.getRestApiClient();
        IBoardInfo result = client.getBoard(board);
        if (SWToolsProperties.isHeadlessOn()) {
            boardCache_4headless.put(board, result);
        }
        return result;
    }

    public static @Nullable IKitInfo listKit(String kit) {
        if (SWToolsProperties.isHeadlessOn() && kitCache_4headless.containsKey(kit)) {
            return kitCache_4headless.get(kit);
        }
        if (KExProcessorsProvider.isOffline()) {
            return null;
        }
        IMfactApiClient client = KExProcessorsProvider.getRestApiClient();
        IKitInfo result = client.getKit(kit);
        if (SWToolsProperties.isHeadlessOn()) {
            kitCache_4headless.put(kit, result);
        }
        return result;
    }

    public static Collection<IKitInfo> listKits() {
        if (KExProcessorsProvider.isOffline()) {
            return CollectionsUtils.emptyList();
        }
        IMfactApiClient client = KExProcessorsProvider.getRestApiClient();
        Collection kits = client.listKits(SWToolsProperties.getProperty((String)FILTER_FAMILIES), KExProcessorsProvider.getProductForProcessorFilter());
        return kits;
    }

    public static Collection<IBoardInfo> listBoards() {
        if (KExProcessorsProvider.isOffline()) {
            return CollectionsUtils.emptyList();
        }
        IMfactApiClient client = KExProcessorsProvider.getRestApiClient();
        Collection boards = client.listBoards(SWToolsProperties.getProperty((String)FILTER_FAMILIES), KExProcessorsProvider.getProductForProcessorFilter());
        return boards;
    }

    public static @Nullable IComponentInfo listComponent(String component) {
        if (KExProcessorsProvider.isOffline()) {
            return null;
        }
        IMfactApiClient client = KExProcessorsProvider.getRestApiClient();
        return client.getComponent(component);
    }

    public static Collection<IComponentInfo> listComponents() {
        if (KExProcessorsProvider.isOffline()) {
            return CollectionsUtils.emptyList();
        }
        IMfactApiClient client = KExProcessorsProvider.getRestApiClient();
        Collection components = client.listComponents();
        return components;
    }

    public static <R, T extends IBaseInfo> Collection<R> _transformProcessorInfos(Collection<T> list, FunctionInfos<T, R> transformProvider) {
        ArrayList result = new ArrayList();
        list.forEach(info -> {
            Collection keys = info.getAttributeKeys();
            for (String key : keys) {
                if (!key.startsWith(SDK_ID_PREFIX)) continue;
                String sdkId = key.substring(SDK_ID_PREFIX.length());
                assert (sdkId != null);
                String sdkName = info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".name");
                String version = null;
                version = info instanceof IKitInfo ? info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".kit_version") : (info instanceof IBoardInfo ? info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".board_version") : (info instanceof IComponentInfo ? info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".component_version") : info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".processor_version")));
                String folder = info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".folder");
                if (folder == null) {
                    folder = "kex_tools";
                }
                String products = UtilsText.safeString((String)info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".products"));
                if (sdkName == null && info instanceof IComponentInfo) {
                    sdkName = "SDK v2";
                }
                if (sdkName != null && version != null && !Objects.isNull(folder)) {
                    result.add(transformProvider.apply(info, sdkId, sdkName, version, folder, products));
                    continue;
                }
                LOGGER.log(Level.SEVERE, String.format("Incomplete metadata for %s [sdk='%s', ver='%s', folder='%s']", info.getName(), sdkName, version, folder));
            }
        });
        return result;
    }

    public static Collection<IProcessorMasterToolInfo> listSWTProcessors(Collection<? extends IProcessorInfo> processors) {
        return KExProcessorsProvider._transformProcessorInfos(processors, (info, sdkId, sdkName, version, folder, products) -> new SWToolsProcessorInfo((IProcessorInfo)info, sdkId, sdkName, version, folder, products));
    }

    public static Collection<ISWToolsBoardInfo> listSWTBoards(Collection<? extends IBoardInfo> boards) {
        return KExProcessorsProvider._transformProcessorInfos(boards, (info, sdkId, sdkName, version, folder, products) -> new SWToolsBoardInfo((IBoardInfo)info, sdkId, sdkName, version, folder));
    }

    public static Collection<ISWToolsKitInfo> listSWTKits(Collection<? extends IKitInfo> kits) {
        return KExProcessorsProvider._transformProcessorInfos(kits, (info, sdkId, sdkName, version, folder, products) -> new SWToolsKitInfo((IKitInfo)info, sdkId, sdkName, version, folder));
    }

    public static Collection<IConfigComponentInfo> listSWTComponents(Collection<? extends IComponentInfo> components) {
        return KExProcessorsProvider._transformProcessorInfos(components, (info, sdkId, sdkName, version, folder, products) -> new ComponentInfo(info.getName(), sdkId, new File(folder)));
    }

    public static Collection<String> getSeries(Collection<IProcessorInfo> processors) {
        return processors.stream().map(info -> info.getSubFamily()).collect(Collectors.toSet());
    }

    public static Collection<String> getSeriesMasterTool(Collection<IProcessorMasterToolInfo> processors) {
        return processors.stream().map(info -> info.getSeries()).collect(Collectors.toSet());
    }

    public static void main(String[] args) {
        System.setProperty("com.freescale.restapi.server", "brno");
        Collection<IProcessorInfo> processors = KExProcessorsProvider.listProcessors();
        KExProcessorsProvider.listSWTProcessors(processors);
        KExProcessorsProvider.getSeries(processors).forEach(System.out::println);
        processors.forEach(p -> System.out.println(p.getName()));
        System.out.print("Find processor by package 'MK22FN128VLL10':");
        System.out.println(KExProcessorsProvider.getProcessorByPackage("MK22FN128VLL10", "ksdk2_0"));
    }

    public static DownloadStatus downloadOrUpdateProcessor(String masterTool, String sdkVersion, @Nullable Collection<IProcessorInfo> processors, @Nullable IProgressMonitor monitor) {
        ISWToolsProcessorInfo procOnline = KExProcessorsProvider.getProcessorMasterToolInfo(masterTool, sdkVersion, processors);
        if (procOnline == null) {
            return DownloadStatus.NOT_FOUND;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        String baseDataDir = derivatives.getDataDir();
        IProcessorMasterToolInfo procLocal = derivatives.getProcessorMasterToolInfo(masterTool, sdkVersion);
        DownloadStatus result = KExProcessorsProvider.downloadOrUpdateProcessor(procOnline, procLocal, new File(baseDataDir).toPath(), monitor);
        if (DownloadStatus.UPDATED == result) {
            derivatives.refreshSupportedDerivatives();
        }
        return result;
    }

    public static CheckStatus checkOrDownloadProcessor(@Nullable String mcu, @Nullable String sdkVersion, boolean logIfNotFound, IProgressMonitor monitor) {
        if (UtilsText.isEmpty((String)mcu) && UtilsText.isEmpty((String)sdkVersion)) {
            return CheckStatus.buildEmptyRequirement();
        }
        assert (mcu != null);
        assert (sdkVersion != null);
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo procLocal = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (procLocal == null) {
            if (SWToolsProperties.isDevelopmentWithNoDataUpdateOn()) {
                return CheckStatus.build(CheckStatus.CheckStatusEnum.MISSING, DownloadStatus.OFFLINE);
            }
            DownloadStatus status = KExProcessorsProvider.downloadOrUpdateProcessor(mcu, sdkVersion, null, monitor);
            if (!status.isCurrentOrUpdated()) {
                if (logIfNotFound) {
                    LOGGER.severe("[DATA] " + MessageFormat.format(Messages.get().KExProcessorsProvider_Error_UnableToDownloadProc, mcu, sdkVersion));
                }
                return CheckStatus.build(CheckStatus.CheckStatusEnum.MISSING, status);
            }
            IProcessorMasterToolInfo procLocal2 = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
            KExProcessorsProvider.downloadOrUpdateComponents(sdkVersion, procLocal2 != null ? derivatives.getSdkComponentsTable(procLocal2) : null, monitor);
        }
        return CheckStatus.build(CheckStatus.CheckStatusEnum.PRESENT, DownloadStatus.CURRENT);
    }

    public static CheckStatus checkOrDownloadProcessor(@Nullable String mcu, @Nullable String sdkVersion, boolean logIfNotFound) {
        return KExProcessorsProvider.checkOrDownloadProcessor(mcu, sdkVersion, logIfNotFound, (IProgressMonitor)new NullProgressMonitor());
    }

    public static DownloadStatus downloadOrUpdateComponents(String sdkVersion, @Nullable SdkComponentsTable sdkComponentsTable, IProgressMonitor monitor) {
        Collection<IComponentInfo> components = KExProcessorsProvider.listComponents();
        if (components.isEmpty()) {
            return DownloadStatus.CURRENT;
        }
        Collection<IComponentInfo> componentsToBeUpdated = KExProcessorsProvider.filterComponentsForUpdateByReferences(components, sdkComponentsTable);
        if ((componentsToBeUpdated = KExProcessorsProvider.filterComponentsForUpdate(componentsToBeUpdated, sdkVersion)).isEmpty()) {
            return DownloadStatus.CURRENT;
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)componentsToBeUpdated.size());
        for (IComponentInfo component : componentsToBeUpdated) {
            if (monitor.isCanceled()) {
                return DownloadStatus.CANCELLED;
            }
            KExProcessorsProvider.downloadOrUpdateComponent(component.getName(), sdkVersion, (IProgressMonitor)subMon.newChild(1), components);
        }
        subMon.done();
        return DownloadStatus.UPDATED;
    }

    public static boolean isProcessorUpdateAvailable(String masterTool, String sdkVersion, Collection<IProcessorInfo> processors) {
        ISWToolsProcessorInfo procOnline = KExProcessorsProvider.getProcessorMasterToolInfo(masterTool, sdkVersion, processors);
        if (procOnline == null) {
            return false;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo procLocal = derivatives.getProcessorMasterToolInfo(masterTool, sdkVersion);
        return KExProcessorsProvider.isProcessorUpdateAvailable(procOnline, procLocal);
    }

    public static boolean isProcessorUpdateAvailable(String masterTool, String sdkVersion) {
        IProcessorInfo proc = KExProcessorsProvider.listProcessor(masterTool);
        if (proc == null) {
            return false;
        }
        ArrayList<IProcessorInfo> processors = new ArrayList<IProcessorInfo>();
        processors.add(proc);
        return KExProcessorsProvider.isProcessorUpdateAvailable(masterTool, sdkVersion, processors);
    }

    public static boolean isProcessorUpdateAvailable(ISWToolsProcessorInfo processor, @Nullable IProcessorMasterToolInfo procLocal) {
        return procLocal == null || Version.parseVersion((String)processor.getVersion()).compareTo(Version.parseVersion((String)procLocal.getVersion())) > 0;
    }

    public static synchronized DownloadStatus downloadOrUpdateProcessor(ISWToolsProcessorInfo procOnline, @Nullable IProcessorMasterToolInfo procLocal, Path baseDataDir, @Nullable IProgressMonitor monitor) {
        if (KExProcessorsProvider.isProcessorUpdateAvailable(procOnline, procLocal)) {
            IProcessorInfo processorInfo = procOnline.getProcessorInfo();
            String sdkId = procOnline.getSWToolsDataFolderID();
            return KExProcessorsProvider.downloadDataForSdk((IBaseInfo)processorInfo, sdkId, baseDataDir, monitor);
        }
        return DownloadStatus.CURRENT;
    }

    public static DownloadStatus downloadOrUpdateBoard(String boardId, String sdkVersion, IProgressMonitor monitor, Collection<IBoardInfo> boards) {
        ISWToolsBoardInfo boardOnline = KExProcessorsProvider.getBoardMasterToolInfo(boardId, sdkVersion, boards);
        if (boardOnline == null) {
            return DownloadStatus.NOT_FOUND;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        ITemplateInfo boardLocal = derivatives.getBoardById(boardId, sdkVersion);
        String baseDataDir = derivatives.getDataDir();
        if (KExProcessorsProvider.isBoardUpdateAvailable(boardOnline, boardLocal)) {
            Path path = new File(baseDataDir).toPath();
            assert (path != null);
            DownloadStatus status = KExProcessorsProvider.downloadDataForSdk((IBaseInfo)boardOnline.getBoardInfo(), sdkVersion, path, monitor);
            if (DownloadStatus.UPDATED == status) {
                derivatives.refreshSupportedDerivatives();
            }
            return status;
        }
        return DownloadStatus.CURRENT;
    }

    public static synchronized DownloadStatus downloadOrUpdateBoard(ISWToolsBoardInfo boardOnline, @Nullable ITemplateInfo boardLocal, Path baseDataDir, @Nullable IProgressMonitor monitor) {
        if (KExProcessorsProvider.isBoardUpdateAvailable(boardOnline, boardLocal)) {
            IBoardInfo boardInfo = boardOnline.getBoardInfo();
            String sdkId = boardOnline.getSWToolsDataFolderID();
            return KExProcessorsProvider.downloadDataForSdk((IBaseInfo)boardInfo, sdkId, baseDataDir, monitor);
        }
        return DownloadStatus.CURRENT;
    }

    static @Nullable ITemplateInfo getLocalBoard(String boardId, String sdkVersion) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        return derivatives.getBoardById(boardId, sdkVersion);
    }

    static @Nullable ITemplateInfo getLocalKit(String kitId, String sdkVersion) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        return derivatives.getKitById(kitId, sdkVersion);
    }

    public static DownloadStatus downloadOrUpdateBoard(String boardId, String sdkVersion, IProgressMonitor monitor) {
        if (KExProcessorsProvider.isOffline()) {
            return DownloadStatus.OFFLINE;
        }
        IBoardInfo board = KExProcessorsProvider.listBoard(boardId);
        if (board == null) {
            return DownloadStatus.NOT_FOUND;
        }
        ArrayList<IBoardInfo> boards = new ArrayList<IBoardInfo>();
        boards.add(board);
        return KExProcessorsProvider.downloadOrUpdateBoard(boardId, sdkVersion, monitor, boards);
    }

    public static boolean checkOrDownloadCommonConfig(IMcuIdentification mcuSelection, IProgressMonitor monitor) {
        String sdkVersion = mcuSelection.getSdkVersion();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        String board = mcuSelection.getBoard();
        String kit = mcuSelection.getKit();
        int workTodo = 1;
        if (!UtilsText.isEmpty((String)board)) {
            ++workTodo;
        }
        if (!UtilsText.isEmpty((String)kit)) {
            ++workTodo;
        }
        subMonitor.setWorkRemaining(workTodo);
        SubMonitor subMonChild = subMonitor.newChild(1, 0);
        assert (subMonChild != null);
        CheckStatus result = KExProcessorsProvider.checkOrDownloadProcessor(mcuSelection.getMcu(), sdkVersion, false, (IProgressMonitor)subMonChild);
        if (!result.isProcessorPresent()) {
            return false;
        }
        if (!UtilsText.isEmpty((String)board)) {
            KExProcessorsProvider.checkOrDownloadBoard(board, sdkVersion, Level.SEVERE);
            subMonitor.worked(1);
        }
        if (!UtilsText.isEmpty((String)kit)) {
            KExProcessorsProvider.checkOrDownloadKit(kit, sdkVersion, Level.SEVERE);
            subMonitor.worked(1);
        }
        return true;
    }

    public static Optional<Boolean> checkOrDownloadBoard(@Nullable String boardId, @Nullable String sdkVersion, @Nullable Level logLevel) {
        if (UtilsText.isEmpty((String)boardId) && UtilsText.isEmpty((String)sdkVersion)) {
            return Optional.empty();
        }
        assert (boardId != null);
        assert (sdkVersion != null);
        if (KExProcessorsProvider.getLocalBoard(boardId, sdkVersion) == null && !KExProcessorsProvider.downloadOrUpdateBoard(boardId, sdkVersion, (IProgressMonitor)new NullProgressMonitor()).isCurrentOrUpdated()) {
            if (logLevel != null) {
                LOGGER.log(logLevel, "[DATA] Unable to download board data:" + boardId);
            }
            return Optional.of(Boolean.FALSE);
        }
        return Optional.of(Boolean.TRUE);
    }

    public static boolean isBoardUpdateAvailable(String boardId, String sdkVersion, Collection<IBoardInfo> boards) {
        ISWToolsBoardInfo procOnline = KExProcessorsProvider.getBoardMasterToolInfo(boardId, sdkVersion, boards);
        if (procOnline == null) {
            return false;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        ITemplateInfo procLocal = derivatives.getBoardById(boardId, sdkVersion);
        return KExProcessorsProvider.isBoardUpdateAvailable(procOnline, procLocal);
    }

    public static boolean isBoardUpdateAvailable(String boardId, String sdkVersion) {
        return KExProcessorsProvider.isBoardUpdateAvailable(boardId, sdkVersion, KExProcessorsProvider.listBoards());
    }

    public static boolean isBoardUpdateAvailable(ITemplateInfo boardOnline, @Nullable ITemplateInfo boardLocal) {
        return boardLocal == null || Version.parseVersion((String)boardOnline.getVersion()).compareTo(Version.parseVersion((String)boardLocal.getVersion())) > 0;
    }

    public static DownloadStatus downloadOrUpdateKit(String kitId, String sdkVersion, IProgressMonitor monitor, Collection<IKitInfo> kits) {
        ISWToolsKitInfo boardOnline = KExProcessorsProvider.getKitMasterToolInfo(kitId, sdkVersion, kits);
        if (boardOnline == null) {
            return DownloadStatus.NOT_FOUND;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        String baseDataDir = derivatives.getDataDir();
        ITemplateInfo boardLocal = derivatives.getKitById(kitId, sdkVersion);
        if (KExProcessorsProvider.isKitUpdateAvailable(boardOnline, boardLocal)) {
            Path path = new File(baseDataDir).toPath();
            assert (path != null);
            DownloadStatus status = KExProcessorsProvider.downloadDataForSdk((IBaseInfo)boardOnline.getKitInfo(), sdkVersion, path, monitor);
            if (DownloadStatus.UPDATED == status) {
                derivatives.refreshSupportedDerivatives();
            }
            return status;
        }
        return DownloadStatus.CURRENT;
    }

    public static DownloadStatus downloadOrUpdateComponent(String name, String sdkVersion, IProgressMonitor monitor) {
        IComponentInfo component = KExProcessorsProvider.listComponent(name);
        if (component == null) {
            return DownloadStatus.NOT_FOUND;
        }
        ArrayList<IComponentInfo> components = new ArrayList<IComponentInfo>();
        components.add(component);
        return KExProcessorsProvider.downloadOrUpdateComponent(name, sdkVersion, monitor, components);
    }

    public static DownloadStatus downloadOrUpdateComponent(String name, String sdkVersion, IProgressMonitor monitor, Collection<IComponentInfo> components) {
        IComponentInfo compOnline = KExProcessorsProvider.getComponentInfo(name, components);
        if (compOnline == null) {
            return DownloadStatus.NOT_FOUND;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        String baseDataDir = derivatives.getDataDir();
        IConfigComponentInfo compLocal = derivatives.getComponentById(name, sdkVersion);
        if (KExProcessorsProvider.isComponentUpdateAvailable(compOnline, compLocal)) {
            Path path = new File(baseDataDir).toPath();
            assert (path != null);
            DownloadStatus status = KExProcessorsProvider.downloadDataForSdk((IBaseInfo)compOnline, sdkVersion, path, monitor);
            if (DownloadStatus.UPDATED == status) {
                derivatives.refreshComponents();
            }
            return status;
        }
        return DownloadStatus.CURRENT;
    }

    public static synchronized DownloadStatus downloadOrUpdateComponent(IComponentInfo compOnline, @Nullable IConfigComponentInfo compLocal, Path baseDataDir, String sdkVersion, @Nullable IProgressMonitor monitor) {
        if (KExProcessorsProvider.isComponentUpdateAvailable(compOnline, compLocal)) {
            return KExProcessorsProvider.downloadDataForSdk((IBaseInfo)compOnline, sdkVersion, baseDataDir, monitor);
        }
        return DownloadStatus.CURRENT;
    }

    public static DownloadStatus downloadOrUpdateKit(String kitId, String sdkVersion, IProgressMonitor monitor) {
        if (KExProcessorsProvider.isOffline()) {
            return DownloadStatus.OFFLINE;
        }
        IKitInfo kit = KExProcessorsProvider.listKit(kitId);
        if (kit == null) {
            return DownloadStatus.NOT_FOUND;
        }
        ArrayList<IKitInfo> kits = new ArrayList<IKitInfo>();
        kits.add(kit);
        return KExProcessorsProvider.downloadOrUpdateKit(kitId, sdkVersion, monitor, kits);
    }

    public static synchronized DownloadStatus downloadOrUpdateKit(ISWToolsKitInfo kitOnline, @Nullable ITemplateInfo kitLocal, Path baseDataDir, @Nullable IProgressMonitor monitor) {
        if (KExProcessorsProvider.isKitUpdateAvailable(kitOnline, kitLocal)) {
            IKitInfo kitInfo = kitOnline.getKitInfo();
            String sdkId = kitOnline.getSWToolsDataFolderID();
            return KExProcessorsProvider.downloadDataForSdk((IBaseInfo)kitInfo, sdkId, baseDataDir, monitor);
        }
        return DownloadStatus.CURRENT;
    }

    public static Optional<Boolean> checkOrDownloadKit(@Nullable String kitId, @Nullable String sdkVersion, Level logLevel) {
        if (UtilsText.isEmpty((String)kitId) && UtilsText.isEmpty((String)sdkVersion)) {
            return Optional.empty();
        }
        assert (kitId != null);
        assert (sdkVersion != null);
        if (KExProcessorsProvider.getLocalKit(kitId, sdkVersion) == null && !KExProcessorsProvider.downloadOrUpdateKit(kitId, sdkVersion, (IProgressMonitor)new NullProgressMonitor()).isCurrentOrUpdated()) {
            LOGGER.log(logLevel, "Unable to download kit data:" + kitId);
            return Optional.of(Boolean.FALSE);
        }
        return Optional.of(Boolean.TRUE);
    }

    public static boolean isKitUpdateAvailable(String kitId, String sdkVersion, Collection<IKitInfo> kits) {
        ISWToolsKitInfo procOnline = KExProcessorsProvider.getKitMasterToolInfo(kitId, sdkVersion, kits);
        if (procOnline == null) {
            return false;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        ITemplateInfo procLocal = derivatives.getKitById(kitId, sdkVersion);
        return KExProcessorsProvider.isKitUpdateAvailable(procOnline, procLocal);
    }

    public static boolean isKitUpdateAvailable(String kitId, String sdkVersion) {
        return KExProcessorsProvider.isKitUpdateAvailable(kitId, sdkVersion, KExProcessorsProvider.listKits());
    }

    public static boolean isKitUpdateAvailable(ITemplateInfo kitOnline, @Nullable ITemplateInfo kitLocal) {
        return KExProcessorsProvider.isBoardUpdateAvailable(kitOnline, kitLocal);
    }

    public static boolean isComponentUpdateAvailable(String componentId, String sdkVersion) {
        return KExProcessorsProvider.isComponentUpdateAvailable(componentId, sdkVersion, KExProcessorsProvider.listComponents());
    }

    public static boolean isComponentUpdateAvailable(String componentId, String sdkVersion, Collection<IComponentInfo> components) {
        IComponentInfo compOnline = KExProcessorsProvider.getComponentInfo(componentId, components);
        if (compOnline == null) {
            return false;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IConfigComponentInfo compLocal = derivatives.getComponentById(componentId, sdkVersion);
        return KExProcessorsProvider.isComponentUpdateAvailable(compOnline, compLocal);
    }

    private static boolean isComponentUpdateAvailable(IComponentInfo compOnline, @Nullable IConfigComponentInfo compLocal) {
        return compLocal == null || Version.parseVersion((String)compOnline.getVersion()).compareTo(Version.parseVersion((String)compLocal.getVersion())) > 0;
    }

    public static Collection<IComponentInfo> filterComponentsForUpdate(Collection<IComponentInfo> components, String sdkVersion) {
        return components.stream().filter(c -> c.getAttributeKeys().contains(SDK_ID_PREFIX + sdkVersion)).filter(c -> KExProcessorsProvider.isComponentUpdateAvailable(c.getName(), sdkVersion, components)).collect(Collectors.toList());
    }

    public static Collection<IComponentInfo> filterComponentsForUpdateByReferences(Collection<IComponentInfo> components, @Nullable SdkComponentsTable sdkComponentsTable) {
        if (sdkComponentsTable == null || SWToolsProperties.isPropertyTrue((String)"com.nxp.components.smartupdate.disable")) {
            return new ArrayList<IComponentInfo>(components);
        }
        ArrayList<IComponentInfo> result = new ArrayList<IComponentInfo>();
        for (IComponentInfo c : components) {
            boolean download = c.getReferences().isEmpty();
            for (IComponentReference r : c.getReferences()) {
                if (!sdkComponentsTable.findById(r.getDriverName()).findFirst().isPresent()) continue;
                download = true;
                break;
            }
            if (download) {
                result.add(c);
                LOGGER.fine("Download/update component " + c.getName());
                continue;
            }
            LOGGER.fine("Do not download/update component " + c.getName());
        }
        Collections.sort(result, (c1, c2) -> c1.getName().compareTo(c2.getName()));
        return result;
    }

    private static @Nullable IComponentInfo getComponentInfo(String componentId, @Nullable Collection<IComponentInfo> components) {
        Collection<IComponentInfo> componentsLoc = components;
        if (componentsLoc == null) {
            componentsLoc = KExProcessorsProvider.listComponents();
        }
        return (IComponentInfo)CollectionsUtils.nullableOptionalGet(componentsLoc.stream().filter(c -> c.getName().equals(componentId)).findFirst());
    }

    public static DownloadStatus downloadDataForSdk(IBaseInfo info, String sdkId, Path baseDataDir, @Nullable IProgressMonitor monitor) {
        ICloudStorageClient client = KExProcessorsProvider.getStorageApiClient();
        String copyDirs = info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".copydirs");
        String copyFiles = info.getAttribute(SDK_ATTR_NAME_PREFIX + sdkId + ".copyfiles");
        if (copyDirs == null) {
            assert (false);
            return DownloadStatus.ERROR;
        }
        CopyTask copyTask = new CopyTask();
        Consumer<String> c = x -> {
            ICloudEntry remoteDir = client.findEntry(x);
            if (remoteDir == null) {
                throw new IllegalStateException("Cannot find remote resource file/path: " + x);
            }
            copyTask.addSubTask(remoteDir, baseDataDir, false, path -> {
                if (path.startsWith(RESTAPI_KEX_TOOLS_PATH_PREFIX)) {
                    path = path.substring(RESTAPI_KEX_TOOLS_PATH_PREFIX.length());
                }
                return path;
            });
        };
        try {
            if (copyFiles != null) {
                Arrays.stream(copyFiles.split(SEPARATOR)).forEach(c);
            }
            boolean[] cancelled = new boolean[1];
            Arrays.stream(copyDirs.split(SEPARATOR)).forEach(c);
            if (monitor != null) {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)UtilsText.safeString((String)com.nxp.swtools.common.ui.utils.Messages.get().KExProgressMonitorDialog_DownloadingData), (int)(copyTask.getSubtasksCount() * 2));
                String dataTypeName4UI = info.getName();
                String kindOfData = UtilsText.safeString((String)com.nxp.swtools.common.ui.utils.Messages.get().KExProgressMonitorDialog_DownloadingProcessor);
                if (info instanceof IKitInfo) {
                    dataTypeName4UI = ((IKitInfo)info).getKitName();
                    kindOfData = UtilsText.safeString((String)com.nxp.swtools.common.ui.utils.Messages.get().KExProgressMonitorDialog_DownloadingKit);
                } else if (info instanceof IBoardInfo) {
                    dataTypeName4UI = ((IBoardInfo)info).getBoardName();
                    kindOfData = UtilsText.safeString((String)com.nxp.swtools.common.ui.utils.Messages.get().KExProgressMonitorDialog_DownloadingBoard);
                } else if (info instanceof IComponentInfo) {
                    dataTypeName4UI = ComponentInfo.getUiName((String)((IComponentInfo)info).getName());
                    kindOfData = UtilsText.safeString((String)com.nxp.swtools.common.ui.utils.Messages.get().KExProgressMonitorDialog_DownloadingComponent);
                }
                subMon.setTaskName(MessageFormat.format(com.nxp.swtools.common.ui.utils.Messages.get().KExProgressMonitorDialog_DownloadingData, kindOfData, dataTypeName4UI));
                copyTask.setCallBack((done, total) -> {
                    subMon.worked(1);
                    if (subMon.isCanceled()) {
                        blArray[0] = true;
                        copyTask.cancelTask();
                    }
                });
            }
            if (!copyTask.run()) {
                return cancelled[0] ? DownloadStatus.CANCELLED : DownloadStatus.ERROR;
            }
        }
        catch (FileSystemException e) {
            LOGGER.log(Level.SEVERE, "Copying data from web - disk error", e);
            return DownloadStatus.DISK_ERROR;
        }
        catch (IOException | IllegalStateException e) {
            LOGGER.log(Level.SEVERE, "Copying data from web", e);
            return DownloadStatus.ERROR;
        }
        return DownloadStatus.UPDATED;
    }

    public static @Nullable ISWToolsProcessorInfo getProcessorMasterToolInfo(String masterTool, String sdkVersion, @Nullable Collection<IProcessorInfo> processors) {
        Collection<IProcessorInfo> processorsLoc = processors;
        if (processorsLoc == null) {
            processorsLoc = new ArrayList<IProcessorInfo>();
            IProcessorInfo proc = KExProcessorsProvider.listProcessor(masterTool);
            if (proc != null) {
                processorsLoc.add(proc);
            }
        }
        return (ISWToolsProcessorInfo)CollectionsUtils.nullableOptionalGet(KExProcessorsProvider.listSWTProcessors(processorsLoc).stream().filter(i -> i.getId().equals(masterTool)).filter(i -> i.getSWToolsDataFolderID().equals(sdkVersion)).findFirst());
    }

    public static @Nullable ISWToolsBoardInfo getBoardMasterToolInfo(String boardId, String sdkVersion, @Nullable Collection<IBoardInfo> boards) {
        Collection<IBoardInfo> boardLoc = boards;
        if (boardLoc == null) {
            boardLoc = KExProcessorsProvider.listBoards();
        }
        return (ISWToolsBoardInfo)CollectionsUtils.nullableOptionalGet(KExProcessorsProvider.listSWTBoards(boardLoc).stream().filter(i -> i.getId().equals(boardId)).findFirst());
    }

    public static @Nullable ISWToolsKitInfo getKitMasterToolInfo(String kitId, String sdkVersion, @Nullable Collection<IKitInfo> kits) {
        Collection<IKitInfo> kitsLoc = kits;
        if (kitsLoc == null) {
            kitsLoc = KExProcessorsProvider.listKits();
        }
        return (ISWToolsKitInfo)CollectionsUtils.nullableOptionalGet(KExProcessorsProvider.listSWTKits(kitsLoc).stream().filter(i -> i.getId().equals(kitId)).findFirst());
    }

    public static @Nullable InputStream getFile(String fileName) {
        assert (proxySettings != null);
        ICloudStorageClient client = KExProcessorsProvider.getStorageApiClient();
        try {
            return client.getFileAsStream(fileName);
        }
        catch (MfactServerError | IOException | URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Remote file read from web failed for: " + fileName, e);
            return null;
        }
    }

    public static @Nullable String getProcessorByPackage(String packageName, @Nullable String sdkVersion) {
        Collection<IProcessorInfo> processors = KExProcessorsProvider.listProcessors();
        String procStartWithKey = null;
        for (IProcessorInfo proc : processors) {
            String sdkVer = sdkVersion != null ? sdkVersion : SWToolsPlatform.getSdkVersionForProcessor(proc.getName());
            String findKey = SDK_ATTR_NAME_PREFIX + sdkVer + ".package." + packageName;
            Collection keys = proc.getAttributeKeys();
            if (keys.contains(findKey)) {
                return proc.getName();
            }
            for (String key : keys) {
                if (!key.startsWith(findKey)) continue;
                procStartWithKey = proc.getName();
            }
        }
        return procStartWithKey;
    }

    public static boolean checkConnectionIsAvailable(String url) {
        IHttpConnectionHelper helper = MfactApiFactory.getHttpConnectionHelper();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                InputStream is = helper.getHttpBinaryResponse(url, null, null, KExProcessorsProvider.getProxyConfiguration());
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MfactServerError mfactServerError) {
        }
        catch (SocketException | SocketTimeoutException | UnknownHostException iOException) {
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return true;
    }

    public static boolean isVersionHigher(@Nullable String version1, @Nullable String version2) {
        return Version.parseVersion((String)version1).compareTo(Version.parseVersion((String)version2)) > 0;
    }

    @FunctionalInterface
    static interface FunctionInfos<A extends IBaseInfo, R> {
        public R apply(A var1, String var2, String var3, String var4, String var5, String var6);
    }
}

