/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.processors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.zip.ZipUtils;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFolderInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.kex.api.IBaseInfo;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DataPackage {
    public static final String PROPERTY_COMPONENTS = "components";
    public static final String PROPERTY_KITS = "kits";
    public static final String PROPERTY_BOARDS = "boards";
    public static final String PROPERTY_PROCESSORS = "processors";
    public static final String PROPERTY_DATA_VERSION = "data_version";
    public static final String PACKAGE_MANIFEST = "npidata.mf";

    static Collection<String> getFilesAndDirsToExport(Collection<ISWToolsDataFolderInfo> dataToExport) {
        ArrayList<@NonNull String> itemsToArchive = new ArrayList<String>();
        for (ISWToolsDataFolderInfo obj : dataToExport) {
            if (obj instanceof ITemplateInfo) {
                itemsToArchive.add(UtilsFile.getFilePath((String)((ITemplateInfo)obj).getRelFileName()));
                continue;
            }
            if (obj instanceof IProcessorMasterToolInfo) {
                itemsToArchive.add(((IProcessorMasterToolInfo)obj).getSubDir());
                continue;
            }
            assert (false) : "Unsupported object to export";
        }
        dataToExport.stream().map(ISWToolsDataFolderInfo::getSWToolsDataFolderID).distinct().filter(sdk -> new File(String.valueOf(PEConfiguration.getDataDirectory()) + File.separator + sdk + "_info.xml").exists()).forEach(sdk -> {
            boolean bl = itemsToArchive.add(String.valueOf(sdk) + "_info.xml");
        });
        return itemsToArchive;
    }

    static Stream<String> getDirsForComponents(Collection<IConfigComponentInfo> components, File sourceBaseDir) {
        return components.stream().map(IConfigComponentInfo::getComponentDir).map(it -> sourceBaseDir.toPath().relativize(it.toPath()).toString());
    }

    static void addManifestToZipFile(ZipOutputStream zipOut, Collection<? extends ISWToolsDataFolderInfo> dataToExport, Collection<IConfigComponentInfo> componentsToExport) throws IOException {
        ZipEntry entry = new ZipEntry(PACKAGE_MANIFEST);
        zipOut.putNextEntry(entry);
        ArrayList<String> processors = new ArrayList<String>();
        ArrayList<String> boards = new ArrayList<String>();
        ArrayList<String> kits = new ArrayList<String>();
        Collection components = componentsToExport.stream().map(IBaseInfo::getName).collect(Collectors.toList());
        for (ISWToolsDataFolderInfo iSWToolsDataFolderInfo : dataToExport) {
            if (iSWToolsDataFolderInfo instanceof ITemplateInfo) {
                ITemplateInfo templ = (ITemplateInfo)iSWToolsDataFolderInfo;
                if (templ.getTemplateType() == ITemplateInfo.TemplateType.ttBoard) {
                    boards.add(templ.getId());
                    continue;
                }
                kits.add(templ.getId());
                continue;
            }
            if (iSWToolsDataFolderInfo instanceof IProcessorMasterToolInfo) {
                processors.add(iSWToolsDataFolderInfo.getId());
                continue;
            }
            assert (false) : "Unsupported object to export";
        }
        Properties properties = new Properties();
        properties.setProperty(PROPERTY_DATA_VERSION, KExProcessorsProvider.getRestApiDataVersion());
        properties.setProperty(PROPERTY_PROCESSORS, processors.stream().sorted().distinct().collect(Collectors.joining(",")));
        properties.setProperty(PROPERTY_BOARDS, boards.stream().sorted().distinct().collect(Collectors.joining(",")));
        properties.setProperty(PROPERTY_KITS, kits.stream().sorted().distinct().collect(Collectors.joining(",")));
        properties.setProperty(PROPERTY_COMPONENTS, components.stream().sorted().distinct().collect(Collectors.joining(",")));
        properties.store(zipOut, null);
        zipOut.closeEntry();
    }

    public static @Nullable Properties getManifestAsproperties(File archive) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(new FileInputStream(archive));
        for (int cntr = 0; (entry = zip.getNextEntry()) != null && cntr < 5; ++cntr) {
            if (!PACKAGE_MANIFEST.equals(entry.getName())) continue;
            Properties properties = new Properties();
            properties.load(zip);
            zip.close();
            return properties;
        }
        zip.close();
        ZipFile zipFile = new ZipFile(archive);
        Optional<ZipEntry> first = zipFile.stream().filter(p -> p.getName().matches(".*npidata.mf")).findFirst();
        ZipEntry zipEntry = entry = first.isPresent() ? first.get() : null;
        if (entry != null) {
            Properties properties = new Properties();
            properties.load(zipFile.getInputStream(entry));
            zipFile.close();
            return properties;
        }
        zipFile.close();
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean createDataPackage(ISupportedDerivativesForSwTools derivatives, OutputStream ous, Collection<ISWToolsDataFolderInfo> dataToExport, Collection<IConfigComponentInfo> components, IProgressMonitor monitor) throws IOException {
        var5_5 = null;
        var6_7 = null;
        try {
            zipFile = new ZipOutputStream(ous);
            try {
                DataPackage.addManifestToZipFile(zipFile, dataToExport, components);
                dataDirs = DataPackage.getFilesAndDirsToExport(dataToExport);
                componentDirStream = DataPackage.getDirsForComponents(components, new File(derivatives.getDataDir()));
                mergedDirs = Stream.concat(dataDirs.stream(), componentDirStream).collect(Collectors.toList());
                subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)mergedDirs.size());
                var13_14 = mergedDirs.iterator();
                while (true) {
                    path = (String)var13_14.next();
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    ZipUtils.addFileToZipFile((ZipOutputStream)zipFile, (File)new File(derivatives.getDataDir()), (String)path);
                    subMon.worked(1);
                    break;
                }
            }
            finally {
                if (var13_14.hasNext()) ** continue;
            }
        }
        catch (Throwable var6_8) {
            if (var5_5 == null) {
                var5_5 = var6_8;
            } else if (var5_5 != var6_8) {
                var5_5.addSuppressed(var6_8);
            }
            throw var5_5;
        }
        return true;
    }

    public static void copyData(Collection<ISWToolsDataFolderInfo> dataToImport, Collection<IConfigComponentInfo> componentsToImport, File sourceBaseDir, File targetBaseDir, IProgressMonitor monitor) throws IOException {
        Collection<String> dataDirs = DataPackage.getFilesAndDirsToExport(dataToImport);
        Stream<String> componentDirStream = DataPackage.getDirsForComponents(componentsToImport, sourceBaseDir);
        List mergedDirs = Stream.concat(dataDirs.stream(), componentDirStream).collect(Collectors.toList());
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)mergedDirs.size());
        for (String path : mergedDirs) {
            subMon.subTask(path);
            UtilsFile.copy((File)new File(sourceBaseDir, path), (File)new File(targetBaseDir, path), (boolean)true);
            subMon.worked(1);
        }
    }
}

