/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.features;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.features.SdkFeatures;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SdkFeaturesProvider {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SdkFeaturesProvider.class);
    @NonNull
    private static final @NonNull Map<@NonNull McuDataId, SoftReference<SdkFeatures>> FEATURES = new HashMap<McuDataId, SoftReference<SdkFeatures>>();

    private SdkFeaturesProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable SdkFeatures getSdkFeatures(@NonNull ISupportedDerivativesForSwTools derivatives, @NonNull IMcuIdentification mcuSelection) {
        String mcu = mcuSelection.getMcu();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, mcuSelection.getSdkVersion());
        if (info == null) {
            LOGGER.severe("Mcu info not found: " + mcuSelection);
            return null;
        }
        McuDataId mcuId = new McuDataId(mcu, info.getVersion(), mcuSelection.getSdkVersion());
        Class<SdkFeaturesProvider> clazz = SdkFeaturesProvider.class;
        synchronized (SdkFeaturesProvider.class) {
            SdkFeatures result;
            SoftReference<SdkFeatures> softReference = FEATURES.get(mcuId);
            SdkFeatures sdkFeatures = result = softReference == null ? null : softReference.get();
            if (result == null) {
                String fileType = "sdk_features";
                String file = derivatives.getDbFileName(info, mcuSelection.getPackage(), fileType, 1, 0);
                SdkFeatures sdkFeatures2 = result = file == null ? null : SdkFeatures.read(new File(derivatives.getDataDir()).toPath().resolve(file));
                if (result != null) {
                    FEATURES.put(mcuId, new SoftReference<SdkFeatures>(result));
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache() {
        Class<SdkFeaturesProvider> clazz = SdkFeaturesProvider.class;
        synchronized (SdkFeaturesProvider.class) {
            FEATURES.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class McuDataId {
        @NonNull
        private final String mcuId;
        @NonNull
        private final String mcuVersion;
        @NonNull
        private final String sdkVersion;

        protected McuDataId(@NonNull String mcuId, @NonNull String mcuVersion, @NonNull String sdkVersion) {
            this.mcuId = mcuId;
            this.mcuVersion = mcuVersion;
            this.sdkVersion = sdkVersion;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.mcuId.hashCode();
            result = 31 * result + this.mcuVersion.hashCode();
            result = 31 * result + this.sdkVersion.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            McuDataId other = (McuDataId)obj;
            if (!this.mcuId.equals(other.mcuId)) {
                return false;
            }
            if (!this.mcuVersion.equals(other.mcuVersion)) {
                return false;
            }
            return this.sdkVersion.equals(other.sdkVersion);
        }
    }
}

