/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.features;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.features.CoreSpecific;
import com.nxp.swtools.provider.features.Feature;
import com.nxp.swtools.provider.features.IFeatureSet;
import com.nxp.swtools.provider.features.PartSpecific;
import com.nxp.swtools.provider.features.PeriphSpecific;
import com.nxp.swtools.provider.features.Specific;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Validate;

public class FeatureSuperset
extends Specific
implements IFeatureSet {
    @ElementListUnion(value={@ElementList(entry="core_specific", inline=true, required=false, type=CoreSpecific.class), @ElementList(entry="feature", inline=true, required=false, type=Feature.class), @ElementList(entry="part_specific", inline=true, required=false, type=PartSpecific.class), @ElementList(entry="peripheral_specific", inline=true, required=false, type=PeriphSpecific.class)})
    @NonNull
    private @NonNull List<@NonNull IFeatureSet> featureSets;
    @Attribute(name="id")
    @NonNull
    private String id = "";
    @NonNull
    private @NonNull Set<@NonNull String> cores = new HashSet<String>();
    @NonNull
    private @NonNull Map<Feature, Set<@NonNull String>> coresByFeature = new HashMap<Feature, Set<String>>();
    @NonNull
    private @NonNull Set<@NonNull Feature> features = new HashSet<Feature>();
    @NonNull
    private @NonNull Set<@NonNull String> parts = new HashSet<String>();
    @NonNull
    private @NonNull Map<Feature, Set<@NonNull String>> partsByFeature = new HashMap<Feature, Set<String>>();
    @NonNull
    private @NonNull Set<@NonNull String> periphs = new HashSet<String>();
    @NonNull
    private @NonNull Map<Feature, Set<@NonNull String>> periphsByFeature = new HashMap<Feature, Set<String>>();

    @Deprecated
    protected FeatureSuperset() {
        this.featureSets = new ArrayList<IFeatureSet>();
    }

    @Commit
    public void commit() {
        FeatureSuperset.commitCores(this.featureSets, this.cores, this.coresByFeature);
        FeatureSuperset.commitFeatures(this.featureSets, this.features);
        FeatureSuperset.commitParts(this.featureSets, this.parts, this.partsByFeature);
        FeatureSuperset.commitPeriphs(this.featureSets, this.periphs, this.periphsByFeature);
    }

    @Override
    public @Nullable Set<@NonNull String> getCores() {
        return this.cores;
    }

    @Override
    public @Nullable Set<@NonNull String> getCoresByFeature(@NonNull Feature f) {
        return this.coresByFeature.get(f);
    }

    @Override
    public @NonNull Set<@NonNull Feature> getFeatures() {
        return this.features;
    }

    public @NonNull String getId() {
        return this.id;
    }

    @Override
    public @NonNull Set<@NonNull String> getParts() {
        return this.parts;
    }

    @Override
    public @Nullable Set<@NonNull String> getPartsByFeature(@NonNull Feature f) {
        return this.partsByFeature.get(f);
    }

    @Override
    public @NonNull Set<@NonNull String> getPeriphs() {
        return this.periphs;
    }

    @Override
    public @Nullable Set<@NonNull String> getPeriphsByFeature(@NonNull Feature f) {
        return this.periphsByFeature.get(f);
    }

    @Validate
    public void validate() throws PersistenceException {
        FeatureSuperset.validate(this.featureSets);
    }
}

