/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.projectgenerator;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.ComponentType;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.StorageProjectGeneratorComponentSet;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;

public class StorageProjectConfig
extends StorageToolBaseConfiguration {
    static final long serialVersionUID = 1L;
    @Attribute(name="rtos")
    @NonNull
    private String rtos = "";
    @ElementList(entry="component_set", inline=true)
    @NonNull
    private @NonNull List<@NonNull StorageProjectGeneratorComponentSet> compSets = new ArrayList<StorageProjectGeneratorComponentSet>();

    StorageProjectConfig() {
    }

    public StorageProjectConfig(@NonNull String coreName) {
        this.name = coreName;
        for (ComponentType compType : ComponentType.supportedValues()) {
            this.compSets.add(new StorageProjectGeneratorComponentSet(compType));
        }
    }

    public @NonNull String getCoreName() {
        return this.getName();
    }

    public @NonNull String getRtosId() {
        return this.rtos;
    }

    public void setRtosId(@NonNull String rtos) {
        this.rtos = rtos;
    }

    public @NonNull List<StorageProjectGeneratorComponentSet> getComponentsSets() {
        return this.compSets;
    }

    public void setComponentSets(@NonNull List<@NonNull StorageProjectGeneratorComponentSet> compSet) {
        this.compSets = new ArrayList<StorageProjectGeneratorComponentSet>(compSet);
    }

    public @NonNull StorageProjectGeneratorComponentSet getComponentSet(@NonNull ComponentType type) {
        for (StorageProjectGeneratorComponentSet set : this.compSets) {
            if (!set.getType().equals((Object)type)) continue;
            return set;
        }
        StorageProjectGeneratorComponentSet result = new StorageProjectGeneratorComponentSet(type);
        this.compSets.add(result);
        return result;
    }

    public void enableComponent(@NonNull String compIndepId, @NonNull String compTypeStr) {
        ComponentType compType = ComponentType.fromSdkCompType(compTypeStr);
        if (compType != null) {
            StorageProjectGeneratorComponentSet set = this.getComponentSet(compType);
            switch (set.getSelection()) {
                case ALL: {
                    return;
                }
                case NONE: {
                    set.setSelection(StorageProjectGeneratorComponentSet.ComponentSelection.CUSTOM);
                }
            }
            set.getComponents().add(compIndepId);
        } else if ("OS".equals(compTypeStr)) {
            this.setRtosId(compIndepId);
        } else assert (false);
    }

    public void disableComponent(@NonNull String compIndepId, @NonNull String compTypeStr) {
        ComponentType compType = ComponentType.fromSdkCompType(compTypeStr);
        if (compType != null) {
            StorageProjectGeneratorComponentSet set = this.getComponentSet(compType);
            switch (set.getSelection()) {
                case ALL: {
                    assert (false);
                }
                case NONE: {
                    return;
                }
                case CUSTOM: {
                    set.getComponents().remove(compIndepId);
                }
            }
        } else assert (false);
    }

    @Override
    public String toString() {
        return "StorageProjectConfig [coreName=" + this.name + ", rtos=" + this.rtos + ", compSets=" + this.compSets + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null) : "nonnull should be checked in parent class";
        return this.getClass() == obj.getClass();
    }

    @Override
    public boolean isCalledFromInit() {
        return true;
    }
}

