/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.projectgenerator;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.provider.Messages;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.StorageProjectGeneratorComponentSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public enum ComponentType {
    MIDDLEWARE("middleware", "middleware", StorageProjectGeneratorComponentSet.ComponentSelection.NONE, () -> Messages.get().StorageProjectGeneratorComponentSet_componentTypeMiddlewareName),
    DRIVER("driver", "driver", StorageProjectGeneratorComponentSet.ComponentSelection.ALL, () -> Messages.get().StorageProjectGeneratorComponentSet_componentTypeDriverName),
    UTILITY("utility", "utilities", StorageProjectGeneratorComponentSet.ComponentSelection.ALL, () -> Messages.get().StorageProjectGeneratorComponentSet_componentTypeUtilityName),
    CMSIS_DRIVER("CMSIS_driver", "CMSIS_driver", StorageProjectGeneratorComponentSet.ComponentSelection.NONE, () -> Messages.get().StorageProjectGeneratorComponentSet_componentTypeCmsisDriverName),
    UNSUPPORTED("unsupported", "", StorageProjectGeneratorComponentSet.ComponentSelection.NONE, () -> Messages.get().StorageProjectGeneratorComponentSet_componentTypeUnsupportedName);

    @NonNull
    private final String typeId;
    @NonNull
    private final String sdkCompType;
    @NonNull
    private final Supplier<String> localizedNameSupplier;
    @NonNull
    private final StorageProjectGeneratorComponentSet.ComponentSelection defaultSelection;

    private ComponentType(@NonNull String typeId, @NonNull String sdkCompType, StorageProjectGeneratorComponentSet.ComponentSelection defaultSelection, Supplier<String> localizedNameSupplier) {
        this.typeId = typeId;
        this.sdkCompType = sdkCompType;
        this.defaultSelection = defaultSelection;
        this.localizedNameSupplier = localizedNameSupplier;
    }

    public @NonNull String getId() {
        return this.typeId;
    }

    public @NonNull String getSdkCompType() {
        return this.sdkCompType;
    }

    public @NonNull String getLocalizedName() {
        String localizedName = this.localizedNameSupplier.get();
        return localizedName != null && !localizedName.isEmpty() ? localizedName : this.typeId;
    }

    public @NonNull StorageProjectGeneratorComponentSet.ComponentSelection getDefaultSelection() {
        return this.defaultSelection;
    }

    public static @NonNull ComponentType fromString(@NonNull String typeId) {
        ComponentType[] componentTypeArray = ComponentType.values();
        int n = componentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentType t = componentTypeArray[n2];
            if (t.getId().equals(typeId)) {
                return t;
            }
            ++n2;
        }
        return UNSUPPORTED;
    }

    public static @Nullable ComponentType fromSdkCompType(@NonNull String sdkCompType) {
        for (ComponentType t : ComponentType.supportedValues()) {
            if (!t.getSdkCompType().equals(sdkCompType)) continue;
            return t;
        }
        return null;
    }

    public static @Nullable ComponentType fromLocalizedName(@NonNull String localizedName) {
        ComponentType[] componentTypeArray = ComponentType.values();
        int n = componentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentType t = componentTypeArray[n2];
            if (t.getLocalizedName().equals(localizedName)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static @NonNull Collection<@NonNull ComponentType> supportedValues() {
        return (Collection)Arrays.asList(ComponentType.values()).stream().filter(v -> !UNSUPPORTED.equals(v)).collect(CollectorsUtils.toList());
    }
}

