/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinLabel;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinsFunction;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinsProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="pins", strict=false)
public class StoragePinsTool
extends StorageTool {
    @NonNull
    @Element(name="pins_profile")
    private StoragePinsProfile pinsProfile = new StoragePinsProfile();
    @NonNull
    @ElementList(name="functions_list", entry="function")
    private @NonNull ArrayList<@NonNull StoragePinsFunction> functions = new ArrayList();
    @NonNull
    public static final String PINS_VERSION = StoragePinsTool.findVersion("Pins");

    public StoragePinsTool() {
        super("Pins", PINS_VERSION);
    }

    public @NonNull StoragePinsProfile getPinsProfile() {
        return this.pinsProfile;
    }

    public @NonNull List<@NonNull StoragePinsFunction> getFunctions() {
        return CollectionsUtils.unmodifiableList(this.functions);
    }

    public @Nullable StoragePinsFunction findFunctionByName(@NonNull String funcName) {
        for (StoragePinsFunction func : this.getFunctions()) {
            if (!func.getConfigurationName().equals(funcName)) continue;
            return func;
        }
        return null;
    }

    public void setFunctions(@NonNull List<@NonNull StoragePinsFunction> newFunctions) {
        this.functions = new ArrayList<StoragePinsFunction>(newFunctions);
    }

    @Override
    public List<? extends @NonNull StorageToolBaseConfiguration> getFunctionalGroups() {
        return this.functions;
    }

    @Override
    public @NonNull Collection<@NonNull IDependency> getDependencies() {
        ArrayList<@NonNull IDependency> result = new ArrayList<IDependency>();
        for (StorageToolBaseConfiguration storageToolBaseConfiguration : this.functions) {
            result.addAll(storageToolBaseConfiguration.getDependencies());
        }
        List<@NonNull IDependency> list = this.getGlobalDependencies();
        if (list != null) {
            result.addAll(list);
        }
        return CollectionsUtils.unmodifiableCollection(result);
    }

    @Override
    public String toString() {
        return "StoragePinsTool: " + this.name + ":" + this.version;
    }

    public static void setLabelsAsFromBoard(@NonNull StoragePinsTool pinsConfig) {
        List<StoragePinLabel> pinLabels = pinsConfig.getPinsProfile().getPinLabels();
        if (pinLabels != null) {
            for (StoragePinLabel pinLabel : pinLabels) {
                pinLabel.definedInBoardOrKit = true;
                pinLabel.definedByUser = false;
            }
        }
    }

    @Override
    public void setDefaultVersion() {
        this.setVersion(PINS_VERSION);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean equals(@Nullable StorageTool other, @NonNull StorageTool.CompareMode mode) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!super.equals(other, mode)) {
            return false;
        }
        if (!(other instanceof StoragePinsTool)) {
            return false;
        }
        StoragePinsTool pinsOther = (StoragePinsTool)other;
        if (!this.pinsProfile.equals(pinsOther.pinsProfile)) {
            return false;
        }
        return this.functions.equals(pinsOther.functions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.functions.hashCode();
        result = 31 * result + this.pinsProfile.hashCode();
        return result;
    }
}

