/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.periphs;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false, name="peripherals")
public class StoragePeriphsTool
extends StorageTool {
    @NonNull
    public static final String VERSION = StoragePeriphsTool.findVersion("Peripherals");
    @NonNull
    @Element(name="peripherals_profile")
    private StoragePeriphsProfile periphsProfile = new StoragePeriphsProfile();
    @NonNull
    @ElementList(name="functional_groups", entry="functional_group")
    private @NonNull ArrayList<@NonNull StoragePeriphsFuncGroup> funcGroups = new ArrayList();
    @ElementList(name="components", entry="component", required=false)
    @NonNull
    private @NonNull ArrayList<@NonNull StoragePeriphsComponent> components = new ArrayList();

    public StoragePeriphsTool() {
        super("Peripherals", VERSION);
    }

    public @NonNull StoragePeriphsProfile getPeriphsProfile() {
        return this.periphsProfile;
    }

    public void setPeriphsProfile(@NonNull StoragePeriphsProfile periphsProfile) {
        this.periphsProfile = periphsProfile;
    }

    public @NonNull ArrayList<@NonNull StoragePeriphsFuncGroup> getFuncGroups() {
        return this.funcGroups;
    }

    public void setFuncGroups(@NonNull ArrayList<@NonNull StoragePeriphsFuncGroup> funcGroups) {
        this.funcGroups = funcGroups;
    }

    @Override
    public List<? extends @NonNull StorageToolBaseConfiguration> getFunctionalGroups() {
        return this.funcGroups;
    }

    public @NonNull ArrayList<@NonNull StoragePeriphsComponent> getComponents() {
        return this.components;
    }

    @Override
    public @NonNull Collection<@NonNull IDependency> getDependencies() {
        ArrayList<@NonNull IDependency> result = new ArrayList<IDependency>();
        for (StoragePeriphsFuncGroup group : this.funcGroups) {
            result.addAll(group.getDependencies());
        }
        List<@NonNull IDependency> globalDependencies = this.getGlobalDependencies();
        if (globalDependencies != null) {
            result.addAll(globalDependencies);
        }
        return CollectionsUtils.unmodifiableCollection(result);
    }

    public void setComponents(@NonNull ArrayList<@NonNull StoragePeriphsComponent> components) {
        this.components = components;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.components.hashCode();
        result = 31 * result + this.funcGroups.hashCode();
        result = 31 * result + this.periphsProfile.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean equals(@Nullable StorageTool other, @NonNull StorageTool.CompareMode mode) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!super.equals(other, mode)) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        StoragePeriphsTool prphOther = (StoragePeriphsTool)other;
        if (!this.components.equals(prphOther.components)) {
            return false;
        }
        if (!this.funcGroups.equals(prphOther.funcGroups)) {
            return false;
        }
        return this.periphsProfile.equals(prphOther.periphsProfile);
    }
}

