/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.ivt;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.YamlConfigProperty;
import com.nxp.swtools.common.utils.yaml.YamlConfiguration;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.ivt.StorageIVTProfile;
import com.nxp.swtools.provider.configuration.storage.ivt.StorageIVTRecords;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="ivt", strict=false)
@YamlConfiguration(properties={@YamlConfigProperty(name="dependencies", ignore=true), @YamlConfigProperty(name="update_project_code", ignore=true)})
public class StorageIVTTool
extends StorageTool {
    @NonNull
    public static final String IVT_TOOL_VERSION;
    @Element(name="ivt_profile")
    @NonNull
    private StorageIVTProfile ivtProfile = new StorageIVTProfile();
    @Element(name="ivt_records", required=false)
    @Nullable
    private StorageIVTRecords ivtRecords;

    static {
        SwToolsProduct ivt = SwToolsProductConfiguration.getRegisteredProduct((String)"IVT");
        IVT_TOOL_VERSION = ivt != null ? ivt.getVersion() : "";
    }

    public StorageIVTTool() {
        super("IVT", IVT_TOOL_VERSION);
    }

    public @NonNull StorageIVTProfile getIvtProfile() {
        return this.ivtProfile;
    }

    public void setIvtProfile(@NonNull StorageIVTProfile ivtProfile) {
        this.ivtProfile = ivtProfile;
    }

    public @Nullable StorageIVTRecords getIvtRecords() {
        return this.ivtRecords;
    }

    public void setIvtRecords(@NonNull StorageIVTRecords ivtRecords) {
        this.ivtRecords = ivtRecords;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean equals(@Nullable StorageTool other, StorageTool.CompareMode mode) {
        if (other == this) {
            return true;
        }
        if (!super.equals(other, mode)) {
            return false;
        }
        if (!(other instanceof StorageIVTTool)) {
            return false;
        }
        StorageIVTTool objTool = (StorageIVTTool)other;
        StorageIVTRecords currentIvtRecords = this.ivtRecords;
        if (!this.ivtProfile.equals(objTool.ivtProfile)) {
            return false;
        }
        return currentIvtRecords != null && currentIvtRecords.equals(objTool.ivtRecords);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.ivtProfile.hashCode();
        StorageIVTRecords currentIvtRecords = this.ivtRecords;
        if (currentIvtRecords != null) {
            result = result * 31 + currentIvtRecords.hashCode();
        }
        return result;
    }

    @Override
    public @Nullable List<? extends @NonNull StorageToolBaseConfiguration> getFunctionalGroups() {
        return null;
    }
}

