/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.ivt;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.ivt.StorageIVTStruct;
import com.nxp.swtools.provider.configuration.storage.ivt.StorageIVTStructComponent;
import java.util.ArrayList;
import java.util.Objects;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="boot_configuration", strict=false)
public class StorageIVTBootConfiguration {
    @NonNull
    public static final String BOOT_TARGET_ID = "boot_target";
    @ElementList(name="struct", required=false)
    @NonNull
    private @NonNull ArrayList<@NonNull StorageIVTStruct> stStructList = new ArrayList();

    public @NonNull ArrayList<@NonNull StorageIVTStruct> getIvtStructList() {
        return this.stStructList;
    }

    public @Nullable StorageIVTStruct getStructFromStorageByName(@NonNull String name) {
        for (StorageIVTStruct struct : this.stStructList) {
            if (!struct.getName().equals(name)) continue;
            return struct;
        }
        return null;
    }

    public @NonNull String getTarget() {
        for (StorageIVTStruct stStruct : this.stStructList) {
            for (StorageIVTStructComponent component : stStruct.getIvtStructComponents()) {
                if (!component.getName().equals(BOOT_TARGET_ID)) continue;
                return component.getValue();
            }
        }
        return "";
    }

    public void setTarget(@NonNull String target) {
        for (StorageIVTStruct stStruct : this.stStructList) {
            for (StorageIVTStructComponent component : stStruct.getIvtStructComponents()) {
                if (!component.getName().equals(BOOT_TARGET_ID)) continue;
                component.setValue(target);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageIVTBootConfiguration other = (StorageIVTBootConfiguration)obj;
        return Objects.equals(this.stStructList, other.stStructList);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + Objects.hashCode(this.stStructList);
        return result;
    }
}

