/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.dcdx;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.storage.StorageBaseProfile;
import com.nxp.swtools.provider.configuration.storage.dcdx.OutputFormatType;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(strict=false, name="dcdx_profile")
public class StorageDCDxProfile
extends StorageBaseProfile {
    private static final Logger LOGGER = LogManager.getLogger(StorageDCDxProfile.class);
    @Element(name="output_format", required=false)
    @Nullable
    private String outputFormat;
    @Nullable
    private OutputFormatType outputFormatType;

    public @Nullable String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public @Nullable OutputFormatType getOutputFormatType() {
        return this.outputFormatType;
    }

    @Validate
    public void validate() {
        if (this.outputFormat != null) {
            this.outputFormatType = OutputFormatType.fromString(this.outputFormat);
            if (this.outputFormatType == OutputFormatType.UNSUPPORTED) {
                LOGGER.severe(MessageFormat.format("Invalid source output format ''{0}''.", this.outputFormat));
            }
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof StorageDCDxProfile)) {
            return false;
        }
        StorageDCDxProfile profile = (StorageDCDxProfile)other;
        return Objects.equals(this.outputFormat, profile.outputFormat);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.outputFormat != null ? this.outputFormat.hashCode() : 0);
        return result;
    }
}

