/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.dcd;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.YamlConfigProperty;
import com.nxp.swtools.common.utils.yaml.YamlConfiguration;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.dcd.StorageDCDCommand;
import com.nxp.swtools.provider.configuration.storage.dcd.StorageDCDProfile;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="dcd", strict=false)
@YamlConfiguration(properties={@YamlConfigProperty(name="dependencies", ignore=true)})
public class StorageDCDTool
extends StorageTool {
    @NonNull
    public static final String DCD_TOOL_VERSION;
    @Attribute(name="isSelfTest", required=false)
    boolean isSelfTest = false;
    @Element(name="dcd_profile")
    @NonNull
    private StorageDCDProfile dcdProfile = new StorageDCDProfile();
    @Element(name="dcd_commands")
    @NonNull
    private StorageDCDCommand dcdCommand = new StorageDCDCommand();

    static {
        SwToolsProduct dcd = SwToolsProductConfiguration.getRegisteredProduct((String)"DCD");
        DCD_TOOL_VERSION = dcd != null ? dcd.getVersion() : "";
    }

    public StorageDCDTool() {
        super("DCD", DCD_TOOL_VERSION);
    }

    public @NonNull StorageDCDProfile getDcdProfile() {
        return this.dcdProfile;
    }

    public void setDcdProfile(@NonNull StorageDCDProfile dcdProfile) {
        this.dcdProfile = dcdProfile;
    }

    public @NonNull StorageDCDCommand getDcdCommand() {
        return this.dcdCommand;
    }

    public void setDcdCommand(@NonNull StorageDCDCommand dcdCommand) {
        this.dcdCommand = dcdCommand;
    }

    public boolean isSelfTest() {
        return this.isSelfTest;
    }

    public void setSelfTest(boolean isSelfTest) {
        this.isSelfTest = isSelfTest;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean equals(@Nullable StorageTool other, StorageTool.CompareMode mode) {
        if (other == this) {
            return true;
        }
        if (!super.equals(other, mode)) {
            return false;
        }
        if (!(other instanceof StorageDCDTool)) {
            return false;
        }
        StorageDCDTool objTool = (StorageDCDTool)other;
        if (!this.dcdProfile.equals(objTool.dcdProfile)) {
            return false;
        }
        if (!this.dcdCommand.equals(objTool.dcdCommand)) {
            return false;
        }
        return this.isSelfTest == objTool.isSelfTest;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.dcdProfile.hashCode();
        result = result * 31 + this.dcdCommand.hashCode();
        result = 31 * result + (this.isSelfTest ? 1231 : 1237);
        return result;
    }

    @Override
    public @Nullable List<? extends @NonNull StorageToolBaseConfiguration> getFunctionalGroups() {
        ArrayList<@NonNull StorageDCDCommand> dcdComm = new ArrayList<StorageDCDCommand>();
        dcdComm.add(this.dcdCommand);
        return dcdComm;
    }
}

