/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.provider.configuration.storage.common.StorageCommonTool;
import com.nxp.swtools.provider.configuration.storage.dcd.StorageDCDTool;
import com.nxp.swtools.provider.configuration.storage.dcdx.StorageDCDxTool;
import com.nxp.swtools.provider.configuration.storage.ddr.StorageDDRTool;
import com.nxp.swtools.provider.configuration.storage.ivt.StorageIVTTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinsTool;
import com.nxp.swtools.provider.configuration.storage.power.StoragePowerTool;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.StorageProjectGeneratorTool;
import com.nxp.swtools.provider.configuration.storage.sdkbuilder.StorageSdkBuilderTool;
import com.nxp.swtools.provider.configuration.storage.sdkproject.StorageToolchainProjectTool;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Transient;

@Root(strict=false, name="tools")
public class StorageTools {
    static final long serialVersionUID = 1L;
    @Element(name="pins", required=false)
    @Nullable
    StoragePinsTool pins;
    @Element(name="clocks", required=false)
    @Nullable
    StorageClocksTool clock;
    @Element(name="power", required=false)
    @Nullable
    StoragePowerTool power;
    @Element(name="ddr", required=false)
    @Nullable
    StorageDDRTool ddr;
    @Element(name="dcd", required=false)
    @Nullable
    StorageDCDTool dcd;
    @Element(name="dcdx", required=false)
    @Nullable
    StorageDCDxTool dcdx;
    @Element(name="ivt", required=false)
    @Nullable
    StorageIVTTool ivt;
    @Element(name="sdk_builder", required=false)
    @Nullable
    StorageSdkBuilderTool sdkBuilder;
    @Element(name="prjgen", required=false)
    @Deprecated
    @Nullable
    StorageProjectGeneratorTool projectGenerator;
    @Element(name="periphs", required=false)
    @Nullable
    StoragePeriphsTool peripherals;
    @Element(name="tee", required=false)
    @Nullable
    StorageTeeTool tee;
    @Element(name="common", required=false)
    @Nullable
    StorageCommonTool common;
    @Transient
    @NonNull
    StorageToolchainProjectTool sdkProject = StorageToolchainProjectTool.STORAGE_TOOLCHAIN_PROJECT_TOOL;

    public @Nullable StoragePinsTool getPins() {
        return this.pins;
    }

    public void setPins(@Nullable StoragePinsTool pins) {
        this.pins = pins;
    }

    public @Nullable StorageClocksTool getClock() {
        return this.clock;
    }

    public void setClock(@Nullable StorageClocksTool clock) {
        this.clock = clock;
    }

    public @Nullable StoragePowerTool getPower() {
        return this.power;
    }

    public void setPower(@Nullable StoragePowerTool power) {
        this.power = power;
    }

    public @Nullable StorageSdkBuilderTool getSdkBuilder() {
        return this.sdkBuilder;
    }

    public void setSdkBuilder(@Nullable StorageSdkBuilderTool sdkBuilder) {
        this.sdkBuilder = sdkBuilder;
    }

    @Deprecated
    public @Nullable StorageProjectGeneratorTool getProjectGenerator() {
        return this.projectGenerator;
    }

    public void clearProjectGenerator() {
        this.projectGenerator = null;
    }

    public @Nullable StoragePeriphsTool getPeripherals() {
        return this.peripherals;
    }

    public void setPeripherals(@Nullable StoragePeriphsTool peripherals) {
        this.peripherals = peripherals;
    }

    @Deprecated
    public @Nullable StorageCommonTool getCommon() {
        return this.common;
    }

    public @Nullable StorageDCDTool getDCDTool() {
        return this.dcd;
    }

    public void setDCDTool(@Nullable StorageDCDTool dcd) {
        this.dcd = dcd;
    }

    public @Nullable StorageDCDxTool getDCDxTool() {
        return this.dcdx;
    }

    public void setDCDxTool(@Nullable StorageDCDxTool dcdx) {
        this.dcdx = dcdx;
    }

    public @Nullable StorageIVTTool getIVTTool() {
        return this.ivt;
    }

    public void setIVTTool(@Nullable StorageIVTTool ivt) {
        this.ivt = ivt;
    }

    public void setTeeTool(@Nullable StorageTeeTool teeTool) {
        this.tee = teeTool;
    }

    public @Nullable StorageTeeTool getTeeTool() {
        return this.tee;
    }

    public @NonNull Collection<@NonNull StorageTool> getTools() {
        ArrayList<StorageTool> result = new ArrayList<StorageTool>();
        result.add(this.peripherals);
        result.add(this.pins);
        result.add(this.clock);
        result.add(this.sdkBuilder);
        result.add(this.power);
        result.add(this.common);
        result.add(this.projectGenerator);
        result.add(this.dcd);
        result.add(this.ivt);
        result.add(this.ddr);
        result.add(this.tee);
        result.add(this.dcdx);
        result.removeIf(Objects::isNull);
        return result;
    }

    public @Nullable StorageTool getTool(@NonNull String id) {
        return (StorageTool)CollectionsUtils.findAny(this.getTools(), t -> t.getName().equals(id));
    }

    public void setTool(@NonNull StorageTool strgTool) {
        this.setTool(strgTool.getName(), strgTool);
    }

    public void setTool(@NonNull String name, @Nullable StorageTool storage) {
        if ("Clocks".equals(name)) {
            this.setClock((StorageClocksTool)storage);
        } else if ("Pins".equals(name)) {
            this.setPins((StoragePinsTool)storage);
        } else if ("Peripherals".equals(name)) {
            this.setPeripherals((StoragePeriphsTool)storage);
        } else if ("DCD".equals(name)) {
            this.setDCDTool((StorageDCDTool)storage);
        } else if ("IVT".equals(name)) {
            this.setIVTTool((StorageIVTTool)storage);
        } else if ("DDR".equals(name)) {
            this.setDDRTool((StorageDDRTool)storage);
        } else if ("TEE".equals(name)) {
            this.setTeeTool((StorageTeeTool)storage);
        } else if ("DCDx".equals(name)) {
            this.setDCDxTool((StorageDCDxTool)storage);
        } else assert (false) : "Tool with name '" + name + "' is not supported";
    }

    public @Nullable StorageDDRTool getDDRTool() {
        return this.ddr;
    }

    public void setDDRTool(@Nullable StorageDDRTool ddr) {
        this.ddr = ddr;
    }

    public void clearAll() {
        this.getTools().stream().filter(t -> !"common".equals(t.getName())).forEach(t -> this.setTool(t.getName(), null));
    }
}

