/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.Messages;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContext;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.GeneratedProjectFile;
import com.nxp.swtools.provider.configuration.storage.IDependenciesProvider;
import com.nxp.swtools.provider.configuration.storage.INamedTool;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false)
public abstract class StorageTool
implements IDependenciesProvider,
INamedTool {
    static final long serialVersionUID = 1L;
    @NonNull
    @Attribute
    protected String name;
    @NonNull
    @Attribute(required=false, empty="1.0")
    protected String version;
    @Attribute(required=false)
    protected boolean enabled = true;
    @Attribute(required=false)
    protected boolean update_project_code = true;
    @Nullable
    @ElementList(name="dependencies", entry="dependency", required=false, empty=true, type=StorageDependency.class)
    private ArrayList<@NonNull IDependency> globalDependencies;
    @ElementList(name="generated_project_files", entry="file", required=false, empty=true, type=GeneratedProjectFile.class)
    @Nullable
    private ArrayList<@NonNull GeneratedProjectFile> generatedProjectFiles;

    protected StorageTool() {
        this.name = "";
        this.version = "";
    }

    public StorageTool(@NonNull String id, @NonNull String version) {
        assert (!id.isEmpty());
        this.name = id;
        this.version = version;
    }

    public void setName(@NonNull String name) {
        assert (!name.isEmpty());
        this.name = name;
    }

    public void setVersion(@NonNull String version) {
        assert (!version.isEmpty());
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDefaultVersion() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public static void setToolEnabled(@NonNull StorageTool storageTool, boolean enable) {
        if (storageTool.isEnabled() == enable) {
            return;
        }
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        storageTool.setEnabled(enable);
        sharedConfig.setDirty(new DefaultConfigChangeContext(IConfigChangeContext.ConfigChangeType.TOOL_TOGGLE, storageTool.getName(), storageTool, String.valueOf(enable ? Messages.get().ActionName_EnableTool : Messages.get().ActionName_DisableTool) + storageTool.getName()));
    }

    public boolean getUpdateCode() {
        return this.update_project_code;
    }

    public void setUpdateCode(boolean value) {
        this.update_project_code = value;
    }

    public boolean isProjectFileUpdateEnabled(@NonNull String fileName) {
        if (!this.getUpdateCode()) {
            return false;
        }
        if (this.generatedProjectFiles != null) {
            for (GeneratedProjectFile prjFile : this.generatedProjectFiles) {
                if (!prjFile.getFileName().equals(fileName)) continue;
                return prjFile.isUpdateEnabled();
            }
        }
        return true;
    }

    public @Nullable Collection<@NonNull GeneratedProjectFile> getGeneratedProjectFiles() {
        if (this.generatedProjectFiles != null) {
            return CollectionsUtils.unmodifiableList(this.generatedProjectFiles);
        }
        return null;
    }

    public boolean setGeneratedProjectFiles(@Nullable Collection<@NonNull GeneratedProjectFile> files) {
        ArrayList<@NonNull GeneratedProjectFile> curGenPrjFiles = this.generatedProjectFiles;
        if (curGenPrjFiles != null ? files != null && curGenPrjFiles.size() == files.size() && new HashSet<GeneratedProjectFile>(files).equals(new HashSet<GeneratedProjectFile>(this.generatedProjectFiles)) : files == null) {
            return false;
        }
        if (files == null) {
            this.generatedProjectFiles = null;
        } else {
            this.generatedProjectFiles = new ArrayList<GeneratedProjectFile>(files);
            this.generatedProjectFiles.sort((file0, file1) -> file0.path.compareTo(file1.path));
        }
        return true;
    }

    public static void setToolUpdateCode(@NonNull StorageTool storageTool, boolean enable) {
        if (storageTool.getUpdateCode() == enable) {
            return;
        }
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        storageTool.setUpdateCode(enable);
        sharedConfig.setDirty(new DefaultConfigChangeContext(IConfigChangeContext.ConfigChangeType.PREFERENCES_CHANGE, storageTool.getName(), storageTool, String.valueOf(enable ? Messages.get().ActionName_EnblUpdateProjectFor : Messages.get().ActionName_DisableUpdateProjectFor) + storageTool.getName()));
    }

    public String toString() {
        return "StorageTool: " + this.name + ":" + this.version;
    }

    @Override
    public @NonNull Collection<@NonNull IDependency> getDependencies() {
        return CollectionsUtils.unmodifiableCollection((Collection)CollectionsUtils.safeCollection(this.globalDependencies));
    }

    public @Nullable List<@NonNull IDependency> getGlobalDependencies() {
        return this.globalDependencies;
    }

    public void setGlobalDependencies(@Nullable List<@NonNull IDependency> globalDependencies) {
        this.globalDependencies = globalDependencies == null ? null : new ArrayList<IDependency>(globalDependencies);
    }

    public static @NonNull String findVersion(@NonNull String productId) {
        SwToolsProduct registeredProduct = SwToolsProductConfiguration.getRegisteredProduct((String)productId);
        return registeredProduct == null ? "" : registeredProduct.getVersion();
    }

    public abstract @Nullable List<? extends @NonNull StorageToolBaseConfiguration> getFunctionalGroups();

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.globalDependencies);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Boolean.hashCode(this.enabled);
        result = 31 * result + (this.update_project_code ? 1231 : 1237);
        return result;
    }

    public boolean equals(@Nullable StorageTool other, @NonNull CompareMode mode) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (CompareMode.EQUALS.equals((Object)mode)) {
            if (!Objects.equals(this.globalDependencies, other.globalDependencies)) {
                return false;
            }
            if (this.update_project_code != other.update_project_code) {
                return false;
            }
            if (!this.version.equals(other.version)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((StorageTool)obj, CompareMode.EQUALS);
    }

    public static enum CompareMode {
        EQUALS,
        MEX_AND_YAML;

    }
}

