/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.dependencies.DependencyFactory;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyFeature;
import com.nxp.swtools.provider.configuration.dependencies.IFeatureData;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeatureData;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageDependencyFeature
implements IDependencyFeature {
    @NonNull
    public static final String FEATURE_EXISTS = "exists";
    @NonNull
    public static final String FEATURE_ROUTED = "routed";
    @NonNull
    public static final String FEATURE_ROUTED_TO_PIN_NR = "routedToPinNr";
    @NonNull
    public static final String FEATURE_ROUTED_TO_SIGNAL = "routedToSignal";
    @NonNull
    public static final String FEATURE_ROUTED_TO_PINS = "routedToPins";
    @NonNull
    public static final String FEATURE_CONFIGURED = "configured";
    @NonNull
    public static final String FEATURE_HAS_SIGNAL = "hasSignal";
    @NonNull
    public static final String FEATURE_ENABLED = "enabled";
    @NonNull
    public static final String FEATURE_FUNCTIONAL_GROUPS_NAMES = "funcGroupNames";
    @NonNull
    public static final String FEATURE_INIT_FUNCTIONAL_GROUPS_NAMES = "initGroupNames";
    @NonNull
    public static final String FEATURE_INITIALIZED = "initialized";
    @NonNull
    public static final String FEATURE_FREQUENCY = "frequency";
    @NonNull
    public static final String FEATURE_VALUE = "value";
    @NonNull
    public static final String FEATURE_ELECTRICAL_PROPERTY = "electricalProperty";
    @NonNull
    public static final String FEATURE_ROUTABLE_SIGNALS = "routableSignals";
    @NonNull
    public static final String FEATURE_ROUTED_UNIFIED_SIGNALS = "routedUnifiedSignals";
    @NonNull
    public static final String FEATURE_DIRECTION = "direction";
    @NonNull
    public static final String FEATURE_FEATURES = "features";
    @NonNull
    public static final String FEATURE_VERSION = "version";
    @NonNull
    public static final String FEATURE_NAME = "name";
    @NonNull
    public static final String FEATURE_PACKAGE = "package";
    @NonNull
    public static final String FEATURE_SERIES = "series";
    @NonNull
    public static final String FEATURE_FAMILY = "family";
    @Attribute
    @NonNull
    private String name = "";
    @Attribute(required=false, empty="")
    @NonNull
    private String evaluation = "";
    @Attribute(required=false)
    @Nullable
    private String configuration;
    @ElementList(inline=true, entry="data", type=StorageDependencyFeatureData.class)
    @NonNull
    private @NonNull List<@NonNull IFeatureData> data = new ArrayList<IFeatureData>();
    @NonNull
    public static final String FEATURE_NAME_ROUTED = "routed";

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    @Override
    public @NonNull String getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation(@NonNull String evaluation) {
        this.evaluation = evaluation;
    }

    @Override
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@Nullable String configuration) {
        this.configuration = configuration;
    }

    public void setData(@NonNull List<@NonNull IFeatureData> data) {
        this.data = data;
    }

    @Override
    public @NonNull List<@NonNull IFeatureData> getData() {
        return this.data;
    }

    @Override
    public void addData(@NonNull String value, @Nullable String type, @Nullable String unit, @Nullable String minValue, @Nullable String maxValue) {
        this.data.add(DependencyFactory.createFeatureData(value, type, unit, minValue, maxValue));
    }

    public String toString() {
        return "StorageDependencyFeature [name=" + this.name + ", evaluation=" + this.evaluation + ", configuration=" + this.configuration + ", data(first " + 5 + ")=" + CollectionsUtils.firstN(this.data, (int)5) + "]";
    }
}

