/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class GeneratedProjectFile {
    @Attribute
    @NonNull
    String path = "";
    @Attribute(name="update_enabled")
    boolean updateEnabled = true;
    @Attribute(name="derived", required=false)
    @Nullable
    Boolean derived = null;

    public GeneratedProjectFile() {
    }

    public GeneratedProjectFile(@NonNull String path) {
        this.path = UtilsFile.toEclipsePath((String)path);
    }

    public GeneratedProjectFile(@NonNull String path, boolean updateEnabled, boolean derived) {
        this(path);
        this.updateEnabled = updateEnabled;
        this.derived = derived ? Boolean.TRUE : null;
    }

    public @NonNull String getPath() {
        return this.path;
    }

    public @NonNull String getFileName() {
        return UtilsFile.getFileNameWithExtension((String)this.path);
    }

    public boolean isUpdateEnabled() {
        return this.updateEnabled;
    }

    public boolean isDerived() {
        Boolean derivedLoc = this.derived;
        return derivedLoc == null ? false : derivedLoc;
    }

    public void setUpdateEnabled(boolean isUpdateEnabled) {
        this.updateEnabled = isUpdateEnabled;
    }

    public boolean equals(Object file) {
        if (!(file instanceof GeneratedProjectFile)) {
            return false;
        }
        GeneratedProjectFile another = (GeneratedProjectFile)file;
        return this.path.equals(another.path) && this.updateEnabled == another.updateEnabled;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }
}

