/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.sources.impl;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileContributorProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SourceFileProviderWrapper
implements ISourceFileProviderWrapper {
    private Collection<ISourceFileProvider> sourceProviders;
    private Collection<ISourceFileContributorProvider> derivedSourceProviders;

    public SourceFileProviderWrapper(Collection<ISourceFileProvider> sourceProviders, Collection<ISourceFileContributorProvider> derivedSourceProviders) {
        this.sourceProviders = sourceProviders;
        this.derivedSourceProviders = derivedSourceProviders;
    }

    @Override
    public ISourceFileProviderWrapper.ISourceGenerateResult generate(String coreId, boolean generateDerived) {
        ArrayList<ISourceFile> generatedFiles = new ArrayList<ISourceFile>();
        for (ISourceFileProvider provider : this.sourceProviders) {
            ArrayList<ISourceFile> files;
            String result = provider.getGeneratedFiles(coreId, files = new ArrayList<ISourceFile>());
            if (result != null) {
                return new SourceGenerateResult(result);
            }
            generatedFiles.addAll(files);
        }
        Collection<ISourceFile> generatedFilesNonModif = Collections.unmodifiableCollection(generatedFiles);
        assert (generatedFilesNonModif != null);
        ArrayList<ISourceFile> derivedSources = new ArrayList<ISourceFile>();
        if (generateDerived) {
            for (ISourceFileContributorProvider provider : this.derivedSourceProviders) {
                ArrayList<ISourceFile> files;
                String result = provider.getGeneratedFiles(coreId, files = new ArrayList<ISourceFile>(), generatedFilesNonModif);
                if (result != null) {
                    return new SourceGenerateResult(result);
                }
                derivedSources.addAll(files);
            }
        }
        return new SourceGenerateResult(null, generatedFiles, derivedSources);
    }

    public static class SourceGenerateResult
    implements ISourceFileProviderWrapper.ISourceGenerateResult {
        @Nullable
        private final String errorMessage;
        private final Collection<ISourceFile> generatedFiles;
        private final Collection<ISourceFile> derivedFiles;

        public SourceGenerateResult(@Nullable String errorMessage, Collection<ISourceFile> generatedFiles, Collection<ISourceFile> derivedFiles) {
            this.errorMessage = errorMessage;
            this.generatedFiles = CollectionsUtils.unmodifiableCollection(generatedFiles);
            this.derivedFiles = CollectionsUtils.unmodifiableCollection(derivedFiles);
        }

        public SourceGenerateResult(String result) {
            this(result, CollectionsUtils.emptyList(), CollectionsUtils.emptyList());
        }

        @Override
        public @Nullable String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public Collection<ISourceFile> getToolsGeneratedFiles() {
            return this.generatedFiles;
        }

        @Override
        public Collection<ISourceFile> getGeneratedDerivedFiles() {
            return this.derivedFiles;
        }

        @Override
        public Collection<ISourceFile> getAllGeneratedFiles() {
            ArrayList<ISourceFile> result = new ArrayList<ISourceFile>(this.generatedFiles);
            result.addAll(this.derivedFiles);
            return result;
        }

        @Override
        public boolean isDerivedSource(String filePath) {
            String osFilePath = UtilsFile.convertToOSPathFormat((String)filePath);
            if (!osFilePath.startsWith(File.separator)) {
                osFilePath = String.valueOf(File.separator) + osFilePath;
            }
            String osFilePathFinal = osFilePath;
            return this.derivedFiles.stream().map(ISourceFile::getRelFileName).anyMatch(s -> UtilsFile.convertToOSPathFormat((String)s).equals(osFilePathFinal));
        }
    }
}

