/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.sources;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileContributorProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.impl.SourceFileByte;
import com.nxp.swtools.provider.configuration.sources.impl.SourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.impl.SourceFileString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class SourceFileProviderFactory {
    private static final String EXTENSION_NAME = "com.nxp.swtools.sharedconfiguration.generation";
    private static final String PROVIDER_ELEMENT_NAME = "sourceProvider";
    private static final String EXTERNAL_PROVIDER_ELEMENT_NAME = "externalSourceProvider";
    static final Logger LOGGER = LogManager.getLogger(SourceFileProviderFactory.class);

    private SourceFileProviderFactory() {
    }

    public static Collection<ISourceFileProvider> getSourceFileProviders() {
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(EXTENSION_NAME, PROVIDER_ELEMENT_NAME, "class");
        return extensionProvider.getExtensions();
    }

    public static @Nullable ISourceFileProviderWrapper getSourceFileProvidersWrapper(String toolId) {
        Collection<ISourceFileProvider> sourceProviders = SourceFileProviderFactory.getSourceFileProviders(toolId);
        Collection<ISourceFileContributorProvider> externalSourceProviders = SourceFileProviderFactory.getDerivedSourceFileProviders(toolId);
        if (sourceProviders.isEmpty() && externalSourceProviders.isEmpty()) {
            return null;
        }
        return new SourceFileProviderWrapper(sourceProviders, externalSourceProviders);
    }

    public static Collection<ISourceFileProvider> getSourceFileProviders(String toolId) {
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(EXTENSION_NAME, PROVIDER_ELEMENT_NAME, "class", toolId::equals, "tool_id", null);
        return extensionProvider.getExtensions();
    }

    public static Collection<ISourceFileContributorProvider> getDerivedSourceFileProviders(String toolId) {
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(EXTENSION_NAME, EXTERNAL_PROVIDER_ELEMENT_NAME, "class", toolId::equals, "tool_id", null);
        return extensionProvider.getExtensions();
    }

    public static Collection<ISourceFile> buildSourceFileList(Map<String, String> generatedFiles) {
        ArrayList<ISourceFile> result = new ArrayList<ISourceFile>(generatedFiles.size());
        for (Map.Entry<String, String> fileContent : generatedFiles.entrySet()) {
            result.add(SourceFileProviderFactory.createSourceFileFromString(fileContent.getKey(), fileContent.getValue()));
        }
        return result;
    }

    public static ISourceFile createSourceFileFromString(String relFileName, String content) {
        return new SourceFileString(relFileName, false, content);
    }

    public static ISourceFile createSourceFileFromBytes(String relFileName, byte[] content, boolean binary) {
        return new SourceFileByte(relFileName, binary, content);
    }

    public static Stream<String> getGeneratedFileNames(Collection<ISourceFile> generatedFiles) {
        return generatedFiles.stream().map(ISourceFile::getRelFileName);
    }
}

