/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.impl;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.logging.PerformanceLogger;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListenerOrder;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContext;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContextHelper;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.storage.StorageConfigurationPreferences;
import com.nxp.swtools.provider.configuration.storage.StorageTools;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Logger;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.services.IDisposable;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.NamespaceList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Complete;
import org.simpleframework.xml.core.Persist;

@Root(name="configuration", strict=false)
@NamespaceList(value={@Namespace(reference="http://mcuxpresso.nxp.com/XSD/mex_configuration_1.6"), @Namespace(reference="http://www.w3.org/2001/XMLSchema-instance", prefix="xsi")})
public class SharedConfiguration
implements ISharedConfiguration,
IDisposable {
    @NonNull
    private static final String SCHEMA_LOCATION = "http://mcuxpresso.nxp.com/XSD/mex_configuration_1.6 http://mcuxpresso.nxp.com/XSD/mex_configuration_1.6.xsd";
    private static final long serialVersionUID = 1L;
    @NonNull
    private static final Logger PERFORMANCE_LOGGER = PerformanceLogger.getSharedPerformanceLogger();
    @NonNull
    @Attribute
    protected String name = "";
    @Attribute
    private double version = 1.6;
    @Attribute(name="schemaLocation", required=false)
    @Namespace(reference="http://www.w3.org/2001/XMLSchema-instance", prefix="xsi")
    private String mSchemaLocation = "http://mcuxpresso.nxp.com/XSD/mex_configuration_1.6 http://mcuxpresso.nxp.com/XSD/mex_configuration_1.6.xsd";
    @Element(name="common")
    @NonNull
    CommonConfigImpl commonConfig = new CommonConfigImpl();
    @Element(name="preferences", required=false)
    @NonNull
    StorageConfigurationPreferences preferences = new StorageConfigurationPreferences();
    @Element(name="tools")
    @NonNull
    private StorageTools tools = new StorageTools();
    @NonNull
    final transient RuntimeConfiguration runtimeConfig = new RuntimeConfiguration();
    @Attribute(name="uuid", required=false)
    @NonNull
    private String uuid = UUID.randomUUID().toString();

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.commonConfig);
        result = 31 * result + Objects.hashCode(this.tools);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SharedConfiguration other = (SharedConfiguration)obj;
        if (!Objects.equals(this.commonConfig, other.commonConfig)) {
            return false;
        }
        return Objects.equals(this.tools, other.tools);
    }

    public String toString() {
        return "SharedConfiguration [common=" + this.commonConfig + ", tools=" + this.tools + "]";
    }

    public void copyFrom(@NonNull ISharedConfiguration aConfig, @NonNull ConfigChangeReason reason) {
        if (!(aConfig instanceof SharedConfiguration)) {
            throw new IllegalArgumentException();
        }
        this.uuid = aConfig.getUUID();
        this.version = aConfig.getVersion();
        this.setCommonConfig((CommonConfigImpl)aConfig.getCommonConfig());
        this.setTools(((SharedConfiguration)aConfig).getTools());
        this.setPreferences(aConfig.getPreferences());
        if (aConfig != this) {
            this.runtimeConfig.configurationData.clear();
            this.runtimeConfig.configurationData.putAll(((SharedConfiguration)aConfig).runtimeConfig.configurationData);
        }
        this.fireReloadEvent(reason);
    }

    @Override
    public StorageTools getTools() {
        return this.tools;
    }

    void setTools(@NonNull StorageTools tools) {
        this.tools = tools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ISharedConfigurationListener listener) {
        ArrayList<ISharedConfigurationListener> arrayList = this.runtimeConfig.listeners;
        synchronized (arrayList) {
            this.runtimeConfig.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ISharedConfigurationListener listener) {
        ArrayList<ISharedConfigurationListener> arrayList = this.runtimeConfig.listeners;
        synchronized (arrayList) {
            this.runtimeConfig.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISharedConfigurationListener[] getListenersCopy() {
        ISharedConfigurationListener[] listenersCopy = null;
        ArrayList<ISharedConfigurationListener> arrayList = this.runtimeConfig.listeners;
        synchronized (arrayList) {
            listenersCopy = this.runtimeConfig.listeners.toArray(new ISharedConfigurationListener[0]);
        }
        Function<ISharedConfigurationListener, Integer> order = listener -> {
            if (listener instanceof ISharedConfigurationListenerOrder) {
                ISharedConfigurationListenerOrder orderedListener = (ISharedConfigurationListenerOrder)((Object)listener);
                return orderedListener.getListenerOrder();
            }
            return 0x3FFFFFFF;
        };
        Arrays.sort(listenersCopy, (a, b) -> (Integer)order.apply((ISharedConfigurationListener)a) - (Integer)order.apply((ISharedConfigurationListener)b));
        return listenersCopy;
    }

    protected void fireReloadEvent(@NonNull ConfigChangeReason reason) {
        SharedConfiguration.logEntering4Performance("fireReloadEvent");
        ISharedConfigurationListener[] iSharedConfigurationListenerArray = this.getListenersCopy();
        int n = iSharedConfigurationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISharedConfigurationListener listener = iSharedConfigurationListenerArray[n2];
            SharedConfiguration.logEntering4Performance(String.valueOf(listener.getClass().getName()) + ".configurationReloaded()");
            this.safeRun(() -> listener.configurationReloaded(this, reason));
            SharedConfiguration.logExiting4Performance(String.valueOf(listener.getClass().getName()) + ".configurationReloaded()");
            ++n2;
        }
        SharedConfiguration.logExiting4Performance("fireReloadEvent");
    }

    @Override
    public void fireCommonConfigChanged() {
        SharedConfiguration.logEntering4Performance("fireCommonConfigChanged");
        ISharedConfigurationListener[] iSharedConfigurationListenerArray = this.getListenersCopy();
        int n = iSharedConfigurationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISharedConfigurationListener listener = iSharedConfigurationListenerArray[n2];
            SharedConfiguration.logEntering4Performance(String.valueOf(listener.getClass().getName()) + ".commonConfigurationChanged()");
            this.safeRun(() -> listener.commonConfigurationChanged(this));
            SharedConfiguration.logExiting4Performance(String.valueOf(listener.getClass().getName()) + ".commonConfigurationChanged()");
            ++n2;
        }
        SharedConfiguration.logExiting4Performance("fireCommonConfigChanged");
    }

    protected void fireDirtyChanged() {
        ISharedConfigurationListener[] iSharedConfigurationListenerArray = this.getListenersCopy();
        int n = iSharedConfigurationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISharedConfigurationListener listener = iSharedConfigurationListenerArray[n2];
            this.safeRun(() -> listener.dirtyChanged(this));
            ++n2;
        }
    }

    protected void fireConfigurationChangedEvent(@NonNull IConfigChangeContext changeContext) {
        ISharedConfigurationListener[] iSharedConfigurationListenerArray = this.getListenersCopy();
        int n = iSharedConfigurationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISharedConfigurationListener listener = iSharedConfigurationListenerArray[n2];
            this.safeRun(() -> listener.configurationChanged(this, changeContext));
            ++n2;
        }
    }

    protected void safeRun(final @NonNull Runnable runnable) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                runnable.run();
            }
        });
    }

    @Override
    public boolean isDirty() {
        return this.runtimeConfig.fDirty;
    }

    @Override
    public void setDirty(@NonNull String toolId, @NonNull Object source, @Nullable String actionName) {
        this.setDirty(new DefaultConfigChangeContext(IConfigChangeContext.ConfigChangeType.UNKNOWN, toolId, source, actionName));
    }

    @Override
    public void setDirty(@NonNull IConfigChangeContext changeContext) {
        boolean prevState = this.runtimeConfig.fDirty;
        this.runtimeConfig.fDirty = true;
        if (prevState != this.runtimeConfig.fDirty) {
            this.fireDirtyChanged();
        }
        this.fireConfigurationChangedEvent(changeContext);
    }

    @Override
    public void clearDirty() {
        boolean prevState = this.runtimeConfig.fDirty;
        this.runtimeConfig.fDirty = false;
        if (prevState != this.runtimeConfig.fDirty) {
            this.fireDirtyChanged();
        }
    }

    @Override
    public void setCreatedFromUserTemplate(boolean value) {
        this.runtimeConfig.createdFromUserTemplate = value;
    }

    @Override
    public boolean isCreatedFromUserTemplate() {
        return this.runtimeConfig.createdFromUserTemplate;
    }

    @Override
    public void setLocationOnDisk(@Nullable String fileName) {
        if (fileName != null) {
            this.runtimeConfig.locationOnDisk = Path.fromOSString((String)fileName);
            this.setCreatedFromUserTemplate(false);
        } else {
            this.runtimeConfig.locationOnDisk = null;
        }
    }

    @Override
    public @Nullable String getLocationOnDisk() {
        IPath path = this.runtimeConfig.locationOnDisk;
        return path == null ? null : path.toOSString();
    }

    @Override
    public void setLocationPath(@Nullable IPath file) {
        this.runtimeConfig.locationOnDisk = file;
    }

    @Override
    public @Nullable IPath getLocationPath() {
        return this.runtimeConfig.locationOnDisk;
    }

    void setCommonConfig(@NonNull CommonConfigImpl commonConfig) {
        this.commonConfig = commonConfig;
    }

    @Override
    public @NonNull ICommonConfig getCommonConfig() {
        return this.commonConfig;
    }

    @Override
    public @NonNull StorageConfigurationPreferences getPreferences() {
        return this.preferences;
    }

    void setPreferences(@NonNull StorageConfigurationPreferences preferences) {
        this.preferences = preferences;
    }

    @Commit
    public void commit() {
        this.commonConfig.setName(this.name);
        if (this.uuid == null) {
            this.uuid = UtilsText.safeToString((Object)UUID.randomUUID());
        }
        if (this.version < 1.4) {
            this.preferences.setGenerateExtendedInformation(true);
        }
    }

    @Persist
    public void prepare() {
        this.name = this.commonConfig.getName();
        this.version = 1.6;
    }

    @Complete
    public void release() {
    }

    @Override
    public void setConfigurationName(String configurationName) {
        this.commonConfig.setName(configurationName);
        this.fireCommonConfigChanged();
    }

    @Override
    public @NonNull String getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(@NonNull String uuid) {
        this.uuid = uuid;
    }

    @Override
    public double getVersion() {
        return this.version;
    }

    @Override
    public void setMcuIdentification(@NonNull IMcuIdentification mcuIdentification) {
        if (!this.commonConfig.getMcuIdentification().equals(mcuIdentification)) {
            this.commonConfig.setMcu(mcuIdentification.getMcu());
            this.commonConfig.setPackage(mcuIdentification.getPackage());
            this.commonConfig.setSdkVersion(mcuIdentification.getSdkVersion());
            this.commonConfig.setBoard(mcuIdentification.getBoard());
            this.commonConfig.setKit(mcuIdentification.getKit());
            this.commonConfig.setExample(mcuIdentification.getExample());
            ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
            SWToolsPlatform.applyCores(this, derivatives);
            this.fireCommonConfigChanged();
            this.setDirty(DefaultConfigChangeContextHelper.processorChanged(this, null));
        }
    }

    @Override
    public void switchPackage(String mcuPackage) {
        IMcuIdentification old = this.commonConfig.getMcuIdentification();
        this.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((String)old.getMcu(), (String)mcuPackage, (String)old.getSdkVersion(), (String)old.getBoard(), (String)old.getKit(), (String)old.getExample()));
    }

    @Override
    public void switchProcessorAndPackage(@NonNull String mcu, @NonNull String mcuPackage, @NonNull String sdkVersion) {
        IMcuIdentification old = this.commonConfig.getMcuIdentification();
        this.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((String)mcu, (String)mcuPackage, (String)sdkVersion, (String)old.getBoard(), (String)old.getKit(), (String)old.getExample()));
    }

    @Override
    public void switchExample(@Nullable String example) {
        IMcuIdentification old = this.commonConfig.getMcuIdentification();
        this.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((String)old.getMcu(), (String)old.getPackage(), (String)old.getSdkVersion(), (String)old.getBoard(), (String)old.getKit(), (String)example));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<ISharedConfigurationListener> arrayList = this.runtimeConfig.listeners;
        synchronized (arrayList) {
            this.runtimeConfig.listeners.clear();
        }
        this.runtimeConfig.configurationData.clear();
    }

    @Override
    public boolean isEmpty() {
        @NonNull IMcuIdentification identification = this.getCommonConfig().getMcuIdentification();
        return UtilsText.isEmpty((String)identification.getMcu()) || UtilsText.isEmpty((String)identification.getSdkVersion());
    }

    @Override
    public void setData(String key, Object value) {
        if (value != null) {
            this.runtimeConfig.configurationData.put(key, value);
        } else {
            this.runtimeConfig.configurationData.remove(key);
        }
    }

    @Override
    public @Nullable Object getData(String key) {
        return this.runtimeConfig.configurationData.get(key);
    }

    @Override
    public @Nullable IToolchainProjectWithSdk getToolchainProject() {
        return this.runtimeConfig.toolchainProjectProvider != null ? this.runtimeConfig.toolchainProjectProvider.getToolchainProject() : null;
    }

    @Override
    public @Nullable IToolchainProjectProvider getToolchainProjectProvider() {
        if (Rap.isActive() && this.runtimeConfig.toolchainProjectProvider == null) {
            this.runtimeConfig.toolchainProjectProvider = new IToolchainProjectProvider(){

                @Override
                public @Nullable IToolchainProjectWithSdk getToolchainProject() {
                    return null;
                }

                @Override
                public @Nullable IGeneratedFilesStatusProvider getGeneratedFilesStatusProvider() {
                    return null;
                }

                @Override
                public void disableProblemUpdates() {
                }

                @Override
                public void enableProblemUpdates() {
                }

                @Override
                public boolean waitUntilProblemsUpdated() {
                    return true;
                }

                @Override
                public void addGeneratedFilesStatusListener(@NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener listener) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }

                @Override
                public void removeGeneratedFilesStatusListener(@NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener listener) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            };
        }
        return this.runtimeConfig.toolchainProjectProvider;
    }

    @Override
    public void setToolchainProjectProvider(@NonNull IToolchainProjectProvider toolchainProjectProvider) {
        this.runtimeConfig.toolchainProjectProvider = toolchainProjectProvider;
    }

    private static void logEntering4Performance(@NonNull String sourceMethod) {
        PERFORMANCE_LOGGER.entering(SharedConfiguration.class.getName(), sourceMethod);
    }

    private static void logExiting4Performance(@NonNull String sourceMethod) {
        PERFORMANCE_LOGGER.exiting(SharedConfiguration.class.getName(), sourceMethod);
    }

    @Override
    public @NonNull IUndoContext getUndoContext() {
        return this.runtimeConfig.undoContext;
    }

    static class RuntimeConfiguration {
        ArrayList<ISharedConfigurationListener> listeners = new ArrayList();
        protected boolean fDirty = true;
        protected boolean createdFromUserTemplate = false;
        @NonNull
        protected IUndoContext undoContext = new UndoContext();
        protected Hashtable<@NonNull String, @Nullable Object> configurationData = new Hashtable();
        @Nullable
        protected IPath locationOnDisk = null;
        @Nullable
        protected IToolchainProjectProvider toolchainProjectProvider;

        RuntimeConfiguration() {
        }
    }
}

