/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.dependencies;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DependencyQueryFactory {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DependencyQueryFactory.class);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static @NonNull Collection<@NonNull IDependencyQuery> getQueryResolveInstances() {
        @NonNull ExecutableExtensionProvider provider = new ExecutableExtensionProvider("com.nxp.swtools.sharedconfiguration.validation", "validationQuery", "class");
        return provider.getExtensions();
    }

    static boolean supportedQuery(@NonNull String resourceType, @NonNull String featureName, @NonNull DependencyResourceAnotation annotation) {
        return annotation.resourceType().equalsIgnoreCase(resourceType) && Arrays.stream(annotation.features()).anyMatch(f -> featureName.equalsIgnoreCase((String)f));
    }

    static Logger getLogger() {
        return LOGGER;
    }

    public static @NonNull IDependencyQuery getQueryInstance(@NonNull ISharedConfiguration configuration) {
        return new QueryInstanceImpl();
    }

    static class QueryInstanceImpl
    implements IDependencyQuery {
        @NonNull
        private @NonNull Collection<@NonNull IDependencyQuery> resolveInstances = DependencyQueryFactory.getQueryResolveInstances();

        @Override
        public @NonNull Collection<@NonNull IDependencyQueryResult> query(ISharedConfiguration configuration, @NonNull String resourceType, @NonNull String resourceId, @NonNull String featureName) {
            ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
            this.resolveInstances.stream().forEach(q -> {
                DependencyQueryAnnotation ann = q.getClass().getAnnotation(DependencyQueryAnnotation.class);
                if (ann != null) {
                    try {
                        if (Arrays.stream(ann.resources()).anyMatch(r -> DependencyQueryFactory.supportedQuery(resourceType, featureName, r))) {
                            IDependencyQuery queryInstance = q;
                            result.addAll(queryInstance.query(configuration, resourceType, resourceId, featureName));
                        }
                    }
                    catch (Exception e) {
                        DependencyQueryFactory.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    DependencyQueryFactory.getLogger().log(Level.WARNING, "class " + q.toString() + " does not have @DependencyQueryAnnotation annotation");
                }
            });
            if (SWToolsProperties.isVerificationOn()) {
                for (IDependencyQueryResult res : result) {
                    Object resValue = res.getValue();
                    if (resValue != null) continue;
                    DependencyQueryFactory.getLogger().log(Level.WARNING, MessageFormat.format("Null result for query type=''{0}'', resourceid=''{1}'', feature=''{2}''", resourceType, resourceId, featureName));
                }
                if (result.isEmpty()) {
                    DependencyQueryFactory.getLogger().log(Level.SEVERE, MessageFormat.format("There was no result for query type=''{0}'', resourceid=''{1}'', feature=''{2}''. No tool was able to answer the query.", resourceType, resourceId, featureName));
                }
            }
            return result;
        }
    }
}

