/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.dependencies;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.dependencies.DependencyCreator;
import com.nxp.swtools.provider.configuration.dependencies.IFeatureData;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeatureData;

public class DependencyFactory {
    public static @NonNull StorageDependency createDependency(@NonNull String resourceType, @NonNull String resourceId, @NonNull String description, int problemLevel, @NonNull String source, @NonNull DependencyCreator dependencyCreator, boolean bootInitOnly) {
        StorageDependency dependency = new StorageDependency();
        dependency.setResourceType(resourceType);
        dependency.setResourceId(resourceId);
        dependency.setDescription(description);
        dependency.setProblemLevel(problemLevel);
        dependency.setSource(source);
        assert (!source.contains(": ")) : "Source should not contain space after the colon separator";
        dependency.setDependencyCreator(dependencyCreator);
        dependency.setBootInitOnly(bootInitOnly);
        return dependency;
    }

    public static @NonNull IFeatureData createFeatureData(@NonNull String value, @Nullable String unit) {
        StorageDependencyFeatureData result = new StorageDependencyFeatureData();
        result.setValue(value);
        result.setUnit(unit);
        return result;
    }

    public static @NonNull IFeatureData createFeatureData(@NonNull String value, @Nullable String type, @Nullable String unit, @Nullable String minValue, @Nullable String maxValue) {
        StorageDependencyFeatureData result = new StorageDependencyFeatureData();
        result.setValue(value);
        result.setType(type);
        result.setUnit(unit);
        result.setMinValue(minValue);
        result.setMaxValue(maxValue);
        return result;
    }
}

