/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.impl.SharedConfiguration;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;

public class SharedConfigurationFactory {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SharedConfigurationFactory.class);
    @NonNull
    public static final String MEX_EXT_WITHOUT_DOT = "mex";
    @NonNull
    public static final String MEX_EXT = ".mex";
    @NonNull
    public static final @NonNull String @NonNull [] SUPPORTED_SUFFIX_VERSIONS = new String[]{".1.1", ""};

    public static @NonNull ISharedConfiguration createSharedConfiguration() {
        return new SharedConfiguration();
    }

    public static @NonNull ISharedConfiguration getSharedConfigurationSingleton() {
        ISharedConfiguration sharedConfig;
        try {
            sharedConfig = (ISharedConfiguration)SWTFactoryProxy.INSTANCE.getSingletonInstance(SharedConfiguration.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            sharedConfig = SharedConfigurationFactory.createSharedConfiguration();
            LOGGER.log(Level.SEVERE, "getSharedConfigurationSingleton", e);
        }
        assert (sharedConfig != null);
        return sharedConfig;
    }

    public static @NonNull ISharedConfiguration loadSharedConfigurationFromXml(@NonNull InputStream xmlStream) throws Exception {
        ISharedConfiguration configuration = SharedConfigurationFactory.createSharedConfiguration();
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy);
        serializer.read((Object)configuration, xmlStream);
        return configuration;
    }

    public static void loadSharedConfigurationFromXml(@NonNull ISharedConfiguration configuration, @NonNull InputStream xmlStream) throws Exception {
        if (!(configuration instanceof SharedConfiguration)) {
            throw new IllegalArgumentException();
        }
        SharedConfiguration config = (SharedConfiguration)configuration;
        ISharedConfiguration loadedConfig = SharedConfigurationFactory.loadSharedConfigurationFromXml(xmlStream);
        assert (loadedConfig instanceof SharedConfiguration);
        config.copyFrom(loadedConfig, ConfigChangeReason.LOAD_CONFIG);
    }

    public static void saveSharedConfigurationToXml(@NonNull ISharedConfiguration configuration, @NonNull OutputStream out) throws Exception {
        Format format = new Format("<?xml version=\"1.0\" encoding= \"UTF-8\" ?>");
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, format);
        serializer.write((Object)configuration, out);
    }

    private static @NonNull String toXmlString(@NonNull Object persistentObj) throws Exception {
        StringWriter writer = new StringWriter();
        Format format = new Format("<?xml version=\"1.0\" encoding= \"UTF-8\" ?>");
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, format);
        serializer.write(persistentObj, (Writer)writer);
        StringBuffer buffer = writer.getBuffer();
        assert (buffer != null);
        return UtilsText.safeToString((Object)buffer);
    }

    public static @NonNull String saveSharedConfigurationToString(@NonNull ISharedConfiguration configuration) throws Exception {
        return SharedConfigurationFactory.toXmlString(configuration);
    }

    @Deprecated
    public static void applyNewConfig(@NonNull ISharedConfiguration sourceConfig, @NonNull ISharedConfiguration targetConfig) {
        if (!(targetConfig instanceof SharedConfiguration)) {
            throw new IllegalArgumentException();
        }
        ((SharedConfiguration)targetConfig).copyFrom(sourceConfig, ConfigChangeReason.UNKNOWN);
    }

    public static void applyNewConfig(@NonNull ISharedConfiguration sourceConfig, @NonNull ISharedConfiguration targetConfig, @NonNull ConfigChangeReason reason) {
        if (!(targetConfig instanceof SharedConfiguration)) {
            throw new IllegalArgumentException();
        }
        ((SharedConfiguration)targetConfig).copyFrom(sourceConfig, reason);
    }

    /*
     * Exception decompiling
     */
    public static @Nullable ISharedConfiguration cloneSharedConfig(@NonNull ISharedConfiguration config) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean clearSharedConfig(@NonNull ISharedConfiguration config) {
        ISharedConfiguration newConfig = SharedConfigurationFactory.createSharedConfiguration();
        config.setLocationPath(null);
        SharedConfigurationFactory.applyNewConfig(newConfig, config, ConfigChangeReason.CLEAR_CONFIG);
        return true;
    }
}

