/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider;

import com.nxp.swtools.common.ui.utils.services.PlatformServices;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.HardReference;
import com.nxp.swtools.common.utils.logging.DoubleLoggingFilter;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.PartInfo;
import com.nxp.swtools.kex.analytics.IAnalytics;
import com.nxp.swtools.kex.analytics.NoAnalytics;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.IMcuSelection;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.IWebUserContext;
import com.nxp.swtools.provider.analytics.AnalyticsReference;
import com.nxp.swtools.provider.analytics.CommandListenerAnalytics;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.osgi.framework.Bundle;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

public class SWToolsPlatform {
    private static final Logger LOGGER = LogManager.getLogger(SWToolsPlatform.class);
    public static final String DEFAULT_DATA_VERSION = "ksdk2_0";
    public static final String DEFAULT_DATA_VERSION_DDR = "ddr_data1_0";
    public static final String NXP_MCUXPRESSO_SDK_PROJECT_NATURE = "com.nxp.mcuxpresso.core.datamodels.sdkNature";
    private static boolean toolInitialized = false;
    static Consumer<SwToolsProduct> setSelectedToolProxy;

    static {
        LOGGER.setFilter((Filter)new DoubleLoggingFilter());
        setSelectedToolProxy = tool -> {
            assert (false);
        };
    }

    public static ICommonConfig getMcuSelection() {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SWToolsPlatform.populateDefaultValues(config);
        ICommonConfig selection = config.getCommonConfig();
        return selection;
    }

    public static IAnalytics getAnalytics() {
        IAnalytics analytics = null;
        HardReference<IAnalytics> analyticsReference = SWToolsPlatform.getAnalyticsReference();
        if (analyticsReference != null && (analytics = (IAnalytics)analyticsReference.get()) == null) {
            analytics = new NoAnalytics();
            if (!SWToolsProperties.isHeadlessOn()) {
                LOGGER.warning("Analytics not available");
            }
        }
        if (analytics == null) {
            analytics = new NoAnalytics();
            LOGGER.warning("Analytics not available");
        }
        return analytics;
    }

    public static void setAnalytics(IAnalytics analytics) {
        try {
            AnalyticsReference analyticsReference = (AnalyticsReference)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(AnalyticsReference.class));
            assert (analyticsReference != null);
            analyticsReference.set(analytics);
            ICommandService commandService = PlatformServices.getCommandService();
            if (commandService != null) {
                commandService.addExecutionListener((IExecutionListener)new CommandListenerAnalytics(analytics));
            } else {
                LOGGER.log(Level.INFO, "ICommandService not available for analytics");
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.log(Level.SEVERE, "cannot create singleton to analytics", e);
        }
    }

    static @Nullable HardReference<IAnalytics> getAnalyticsReference() {
        try {
            AnalyticsReference analyticsReference = (AnalyticsReference)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(AnalyticsReference.class));
            return analyticsReference;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.log(Level.SEVERE, "cannot create singleton to analytics", e);
            return null;
        }
    }

    private static void populateDefaultValues(ISharedConfiguration config) {
        IMcuSelection onlineSelection;
        IMcuIdentification selection = config.getCommonConfig().getMcuIdentification();
        if (UtilsText.isEmpty((String)selection.getMcu()) && (onlineSelection = SWToolsPlatform.getOnlineMcuSelection()) != null) {
            config.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((IMcuSelection)onlineSelection));
            ((CommonConfigImpl)config.getCommonConfig()).setSessionIndex(onlineSelection.getSessionIndex());
        }
    }

    public static ISharedConfiguration getSharedConfigurationSingleton() {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SWToolsPlatform.getMcuSelection();
        return config;
    }

    public static @Nullable IMcuSelection getOnlineMcuSelection() {
        if (!Rap.isActive()) {
            return null;
        }
        @Nullable IWebUserContext webContext = (IWebUserContext)PlatformUI.getWorkbench().getService(IWebUserContext.class);
        if (webContext == null) {
            return null;
        }
        return webContext.getKexSelectedMCU();
    }

    public static String[] getAllToolchains() {
        assert (Rap.isActive());
        @Nullable IWebUserContext webContext = (IWebUserContext)PlatformUI.getWorkbench().getService(IWebUserContext.class);
        if (webContext == null) {
            return new String[0];
        }
        return webContext.getAllToolchains();
    }

    public static @Nullable String getSdkPackageHash() {
        assert (Rap.isActive());
        @Nullable IWebUserContext webContext = (IWebUserContext)PlatformUI.getWorkbench().getService(IWebUserContext.class);
        if (webContext == null) {
            return null;
        }
        return webContext.getSdkPackageHash();
    }

    public static String getLanguagePreference() {
        String language;
        assert (Rap.isActive());
        @Nullable IWebUserContext webContext = (IWebUserContext)PlatformUI.getWorkbench().getService(IWebUserContext.class);
        String string = language = webContext != null ? webContext.getPreferredLanguage() : null;
        if (UtilsText.isEmpty((String)language)) {
            language = "en";
        }
        assert (language != null);
        return language;
    }

    public static boolean areCoreListsEquivalent(Collection<ProcessorCore> cores1, Collection<ProcessorCore> cores2) {
        Object[] sortedCores2;
        if (cores1.size() != cores2.size()) {
            return false;
        }
        Object @NonNull [] sortedCores1 = cores1.stream().sorted((c1, c2) -> c1.getID().compareTo(c2.getID())).map(c -> c.getID()).toArray();
        boolean equals = Arrays.equals(sortedCores1, sortedCores2 = cores2.stream().sorted((c1, c2) -> c1.getID().compareTo(c2.getID())).map(c -> c.getID()).toArray());
        if (!equals) {
            LOGGER.warning("Updated core list in MEX because the IDs did not matched (probably project from old tools");
        }
        return equals;
    }

    public static void applyCores(ISharedConfiguration config, ISupportedDerivativesForSwTools derivatives) {
        String sdk;
        ICommonConfig commonConfig = config.getCommonConfig();
        String mcu = UtilsText.safeString((String)commonConfig.getMcu());
        CoresInfoLoader info = SWToolsPlatform.getCoresInfo(mcu, sdk = UtilsText.safeString((String)commonConfig.getSdkVersion()), derivatives);
        if (info != null) {
            if (!info.cores.isEmpty() && !SWToolsPlatform.areCoreListsEquivalent(commonConfig.getCores(), info.cores)) {
                commonConfig.setCores(info.cores);
            }
        } else if (SWToolsProperties.isVerificationOn()) {
            LOGGER.severe("Cannot find/open cores_info.xml for processor/sdk: " + mcu + "/" + sdk);
        }
        if (commonConfig.getCores().isEmpty()) {
            ProcessorCore core = SWToolsPlatform.createDefaultCoreInstance();
            commonConfig.setCores(Arrays.asList(core));
        }
    }

    public static ProcessorCore createDefaultCoreInstance() {
        ProcessorCore core = new ProcessorCore();
        core.setName("Core #1");
        core.setID("core1");
        core.setDescription("");
        core.setMaster(true);
        core.setMasterDefault(true);
        return core;
    }

    public static @Nullable CoresInfoLoader getCoresInfo(String mcu, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        File f;
        String db;
        IProcessorMasterToolInfo master = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (master != null && (db = derivatives.getDbFileName(master, master.getDefaultPartNumber(), "cores_info", 1, 0)) != null && (f = new File(derivatives.getDataDir(), db)).exists()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream is = UtilsDecryption.getFileInputStream((File)f);){
                    return SWToolsPlatform.getCoresInfo(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "getCoresInfo", e);
            }
        }
        return null;
    }

    public static @Nullable CoresInfoLoader getCoresInfo(InputStream is) {
        Persister serializer = new Persister();
        CoresInfoLoader info = new CoresInfoLoader();
        try {
            serializer.read((Object)info, is);
            return info;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Deserialize getCoresInfo from input stream", e);
            return null;
        }
    }

    public static @Nullable PartInfo getPartInfo(String mcu, String sdkVersion, String part, ISupportedDerivativesForSwTools derivatives) {
        File f;
        String db;
        IProcessorMasterToolInfo master = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (master != null && (db = derivatives.getDbFileName(master, part, "part_info", 1, 0)) != null && (f = new File(derivatives.getDataDir(), db)).exists()) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (InputStream is = UtilsDecryption.getFileInputStream((File)f);){
                    return SWToolsPlatform.getPartInfo(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "getPartInfo", e);
            }
        }
        return null;
    }

    public static @Nullable PartInfo getPartInfo(InputStream is) {
        Persister serializer = new Persister();
        PartInfo info = new PartInfo();
        try {
            serializer.read((Object)info, is);
            return info;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Deserialize getPartInfo from input stream", e);
            return null;
        }
    }

    public static boolean isPartDeprecated(String mcu, String sdkVersion, String part, ISupportedDerivativesForSwTools derivatives) {
        PartInfo partInfo = SWToolsPlatform.getPartInfo(mcu, sdkVersion, part, derivatives);
        return partInfo == null ? false : partInfo.isDeprecated();
    }

    public static boolean isPartRequiresNDA(String mcu, String sdkVersion, String part, ISupportedDerivativesForSwTools derivatives) {
        PartInfo partInfo = SWToolsPlatform.getPartInfo(mcu, sdkVersion, part, derivatives);
        return partInfo == null ? false : partInfo.isRequiresNDA();
    }

    public static boolean isMcuDeprecated(String mcu, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (info == null) {
            return false;
        }
        for (String part : info.getPartNumbers()) {
            PartInfo partInfo = SWToolsPlatform.getPartInfo(mcu, sdkVersion, part, derivatives);
            if (partInfo == null) {
                return false;
            }
            if (partInfo.isDeprecated()) continue;
            return false;
        }
        return true;
    }

    public static boolean isMcuDeprecated(IProcessorMasterToolInfo masterTool, ISupportedDerivativesForSwTools derivatives) {
        return SWToolsPlatform.isMcuDeprecated(masterTool.getId(), masterTool.getSWToolsDataFolderID(), derivatives);
    }

    public static boolean isMcuRequiresNDA(String mcu, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        if (info == null) {
            return false;
        }
        for (String part : info.getPartNumbers()) {
            PartInfo partInfo = SWToolsPlatform.getPartInfo(mcu, sdkVersion, part, derivatives);
            if (partInfo == null) {
                return false;
            }
            if (partInfo.isRequiresNDA()) continue;
            return false;
        }
        return true;
    }

    public static boolean isMcuRequiresNDA(IProcessorMasterToolInfo masterTool, ISupportedDerivativesForSwTools derivatives) {
        return SWToolsPlatform.isMcuRequiresNDA(masterTool.getId(), masterTool.getSWToolsDataFolderID(), derivatives);
    }

    static File getCoresInfoCacheDir() {
        String dirName = String.valueOf(SWToolsPlatform.getBaseUserConfigDir()) + File.separator + "cores_info_cache" + File.separator + KExProcessorsProvider.getRestApiDataVersion();
        File cacheDir = new File(dirName);
        if (!cacheDir.exists()) {
            try {
                cacheDir.mkdirs();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "failed creating cores info xml cache directory", e);
            }
        }
        return cacheDir;
    }

    /*
     * Exception decompiling
     */
    public static synchronized @Nullable CoresInfoLoader getCoresInfoFromWeb(String mcu, String sdk) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getBaseUserConfigDir() {
        return String.valueOf(System.getProperty("user.home")) + File.separator + ".nxp" + File.separator + SWToolsProperties.getProductDirName() + File.separator + "6.0";
    }

    public static String getSdkVersionForSdkManifestVersion(String sdkManifestVersion) {
        return DEFAULT_DATA_VERSION;
    }

    public static String getSdkVersionForProcessor(String processor) {
        return SwToolsProduct.isUctProduct() ? SWToolsPlatform.getMcuSelection().getSdkVersion() : DEFAULT_DATA_VERSION;
    }

    public static void setSelectedToolProxy(Consumer<SwToolsProduct> proxy) {
        assert (!Rap.isActive());
        if (Rap.isActive()) {
            return;
        }
        setSelectedToolProxy = proxy;
    }

    public static void setSelectedTool(SwToolsProduct tool) {
        assert (!Rap.isActive());
        if (Rap.isActive()) {
            return;
        }
        setSelectedToolProxy.accept(tool);
    }

    public static synchronized void initializeAllTools() {
        if (toolInitialized) {
            LOGGER.warning("Duplicate tools initialization; ignored");
            return;
        }
        toolInitialized = true;
        ExecutableExtensionProvider provider = new ExecutableExtensionProvider("com.nxp.swtools.sharedconfiguration.startup", "startup", "class", null, null, "priority");
        for (IStartup ext : provider.getExtensions()) {
            ext.earlyStartup();
        }
    }

    public static boolean isRunningAsRcp() {
        Bundle b = Platform.getBundle((String)"com.nxp.swtools.rcp");
        return b != null;
    }

    public static boolean isRunningInEclipseIde() {
        Bundle b = Platform.getBundle((String)"com.nxp.swtools.eclipse");
        return b != null;
    }

    public static boolean isRunningInMCUXpressoIde() {
        if (!SWToolsPlatform.isRunningInEclipseIde()) {
            return false;
        }
        Bundle b = Platform.getBundle((String)"com.nxp.mcuxpresso.core.datamodels.interfaces");
        return b != null;
    }

    public static boolean isRunningJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    @Root(name="cores", strict=false)
    public static class CoresInfoLoader {
        @ElementList(inline=true, entry="core")
        public ArrayList<ProcessorCore> cores = new ArrayList();

        public @Nullable ProcessorCore findCore(String coreId) {
            return (ProcessorCore)CollectionsUtils.nullableOptionalGet(this.cores.stream().filter(c -> coreId.equals(c.getID())).findFirst());
        }

        public String toString() {
            return "CoresInfoLoader [cores=" + this.cores + "]";
        }
    }
}

