/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apukernel.util;

import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.gte.apuflow.ApuDefinition;
import com.nxp.s32ds.gte.apuflow.ApuPort;
import com.nxp.s32ds.gte.apuflow.util.ApuFlowValidator;
import com.nxp.s32ds.gte.apukernel.APUKernelPlugin;
import com.nxp.s32ds.gte.apukernel.ApuChunkSize;
import com.nxp.s32ds.gte.apukernel.ApuDataScale;
import com.nxp.s32ds.gte.apukernel.ApuDataTiling;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPackage;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortAttributesInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortElementsInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortSpatialDepInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apukernel.ApuPortType;
import com.nxp.s32ds.gte.apukernel.util.ApuKernelHelper;
import com.nxp.s32ds.gte.apukernel.util.Messages;
import com.nxp.s32ds.gte.apukernel.validation.Apex2KernelModelValidator;
import com.nxp.s32ds.gte.apukernel.validation.Apex2KernelModelValidatorProvider;
import com.nxp.s32ds.mdt.ide.c.evaluation.MdtCDefineEvaluator;
import com.nxp.s32ds.mdt.ide.validation.UniqueValueValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.osgi.util.NLS;

public class ApuKernelValidator
extends EObjectValidator {
    public static final ApuKernelValidator INSTANCE = new ApuKernelValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.nxp.s32ds.gte.apukernel";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected ApuFlowValidator apuFlowValidator = ApuFlowValidator.INSTANCE;

    protected EPackage getEPackage() {
        return ApuKernelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateApuKernelSource((ApuKernelSource)value, diagnostics, context);
            }
            case 1: {
                return this.validateApuKernelInfo((ApuKernelInfo)value, diagnostics, context);
            }
            case 2: {
                return this.validateApuKernelPortInfo((ApuKernelPortInfo)value, diagnostics, context);
            }
            case 3: {
                return this.validateApuKernelPortElementsInfo((ApuKernelPortElementsInfo)value, diagnostics, context);
            }
            case 4: {
                return this.validateApuKernelPortSpatialDepInfo((ApuKernelPortSpatialDepInfo)value, diagnostics, context);
            }
            case 5: {
                return this.validateApuKernelPortAttributesInfo((ApuKernelPortAttributesInfo)value, diagnostics, context);
            }
            case 6: {
                return this.validateApuPortType((ApuPortType)((Object)value), diagnostics, context);
            }
            case 7: {
                return this.validateApuMemoryPart((ApuMemoryPart)((Object)value), diagnostics, context);
            }
            case 8: {
                return this.validateApuDataTiling((ApuDataTiling)((Object)value), diagnostics, context);
            }
            case 9: {
                return this.validateApuDataScale((ApuDataScale)((Object)value), diagnostics, context);
            }
            case 10: {
                return this.validateApuChunkSize((ApuChunkSize)((Object)value), diagnostics, context);
            }
            case 11: {
                return this.validateApuDataType((ApuDataType)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateApuKernelSource(ApuKernelSource apuKernelSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuKernelSource, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuKernelSource, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuKernelSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuKernelSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuKernelSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuKernelSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuKernelSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuKernelSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuKernelSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelSource_fieldsAreNotEmpty(apuKernelSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelSource_AtLeastOneKernel(apuKernelSource, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelSource_fieldsAreNotEmpty(ApuKernelSource apuKernelSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (apuKernelSource.getCategory().trim().isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Category field is empty", ApuKernelValidator.getObjectLabel((EObject)apuKernelSource, context)}, new Object[]{apuKernelSource}, context));
            }
            result = false;
        }
        if (apuKernelSource.getInclude().trim().isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Include field is empty", ApuKernelValidator.getObjectLabel((EObject)apuKernelSource, context)}, new Object[]{apuKernelSource}, context));
            }
            result = false;
        }
        return result;
    }

    public boolean validateApuKernelSource_AtLeastOneKernel(ApuKernelSource apuKernelSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuKernelSource.getKernelInfos().isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"There should be at least one kernel on diagram", ApuKernelValidator.getObjectLabel((EObject)apuKernelSource, context)}, new Object[]{apuKernelSource}, context));
            }
            return false;
        }
        return true;
    }

    private boolean checkIfe0ekSpatialInRange(ApuKernelPortInfo element, String strValue, String attrName, DiagnosticChain diagnostics, Map<Object, Object> context, int lowBorder) {
        if (strValue == null || strValue.isEmpty()) {
            return true;
        }
        boolean result = true;
        try {
            int value = MdtCDefineEvaluator.INSTANCE.evalInteger((EObject)element, strValue);
            if (value < lowBorder || value > 65535) {
                result = false;
            }
        }
        catch (CoreException coreException) {
            result = false;
        }
        if (!result) {
            this.addToDiagnostics(ApuKernelHelper.getE0EkSpatialDepErrorRangeMessage(attrName, lowBorder), (EObject)element, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelInfo(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuKernelInfo, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuKernelInfo, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_hasOutAndInputPort(apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_NameShouldBeValidCIdentifier(apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_NameShouldBeUnique(apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_InputsNumberIsLessThanMax(apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_OutputsNumberIsLessThanMax(apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_InputsOutputsNumberIsLessThanMax(apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_MustNotBeVsdkKernelInfoName(apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_AliasShouldntBeEmpty(apuKernelInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInfo_NameShouldntBeEmpty(apuKernelInfo, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelInfo_hasOutAndInputPort(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ApuKernelPortInfo> ports = apuKernelInfo.getPortInfos();
        if (ports.isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_APUKernelInfo_NoPorts_diagnostic", new Object[]{"Kernel " + ApuKernelValidator.extractName(apuKernelInfo.getName()), ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
            }
            return false;
        }
        ArrayList<ApuKernelPortInfo> apuKernelInPortInfos = new ArrayList<ApuKernelPortInfo>();
        ArrayList<ApuKernelPortInfo> apuKernelOutPortInfos = new ArrayList<ApuKernelPortInfo>();
        for (ApuKernelPortInfo port : ports) {
            if (port.getPortAttrbutesInfo().getPortType().equals((Object)ApuPortType.ATTR_IN)) {
                apuKernelInPortInfos.add(port);
                continue;
            }
            if (!port.getPortAttrbutesInfo().getPortType().equals((Object)ApuPortType.ATTR_OUT)) continue;
            apuKernelOutPortInfos.add(port);
        }
        if (apuKernelInPortInfos.size() < 1 || apuKernelOutPortInfos.size() < 1) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_APUKernelInfo_HasNotOutAndInptPorts_diagnostic", new Object[]{"Kernel " + ApuKernelValidator.extractName(apuKernelInfo.getName()), ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_NameShouldBeValidCIdentifier(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = ApuKernelValidator.extractName(apuKernelInfo.getName());
        if (name == null || name.isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)name);
        if (!result.equals(Status.OK_STATUS)) {
            this.addToDiagnostics(result.getMessage(), (EObject)apuKernelInfo, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_NameShouldBeUnique(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = ApuKernelValidator.extractName(apuKernelInfo.getName());
        if (name == null || name.isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuKernelInfo.getSource().getKernelInfos()) {
            if (eObject.equals(apuKernelInfo)) continue;
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Kernel name \"{0}\"", (Object)name);
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuKernelInfo, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_InputsNumberIsLessThanMax(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ApuKernelPortInfo> ports = apuKernelInfo.getPortInfos();
        if (ports.isEmpty()) {
            return true;
        }
        try {
            List<ApuKernelPortInfo> apuKernelInputPorts = ApuKernelHelper.getKernelPorts(apuKernelInfo, ApuPortType.ATTR_IN);
            if (apuKernelInputPorts.size() > ApuKernelHelper.getKernelInputsMaxNumber() && diagnostics != null) {
                String errorMsg = NLS.bind((String)"Number of input ports exceeded MAX value ({0}).", (Object)ApuKernelHelper.getKernelInputsMaxNumber());
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{errorMsg, ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
                return false;
            }
        }
        catch (CoreException e) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{e.getMessage(), ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_OutputsNumberIsLessThanMax(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ApuKernelPortInfo> ports = apuKernelInfo.getPortInfos();
        if (ports.isEmpty()) {
            return true;
        }
        try {
            List<ApuKernelPortInfo> apuKernelOutputPorts = ApuKernelHelper.getKernelPorts(apuKernelInfo, ApuPortType.ATTR_OUT);
            if (apuKernelOutputPorts.size() > ApuKernelHelper.getKernelOutputsMaxNumber() && diagnostics != null) {
                String errorMsg = NLS.bind((String)"Number of output ports exceeded MAX value ({0}).", (Object)ApuKernelHelper.getKernelOutputsMaxNumber());
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{errorMsg, ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
                return false;
            }
        }
        catch (CoreException e) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{e.getMessage(), ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_InputsOutputsNumberIsLessThanMax(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ApuKernelPortInfo> ports = apuKernelInfo.getPortInfos();
        if (ports.isEmpty()) {
            return true;
        }
        try {
            List<ApuKernelPortInfo> apuKernelOutputPorts = ApuKernelHelper.getKernelPorts(apuKernelInfo, ApuPortType.ATTR_OUT);
            List<ApuKernelPortInfo> apuKernelInputPorts = ApuKernelHelper.getKernelPorts(apuKernelInfo, ApuPortType.ATTR_IN);
            if (apuKernelOutputPorts.size() + apuKernelInputPorts.size() > ApuKernelHelper.getKernelInputsOutputsMaxNumber() && diagnostics != null) {
                String errorMsg = NLS.bind((String)"Number of inputs and output ports exceeded MAX value ({0}).", (Object)ApuKernelHelper.getKernelInputsOutputsMaxNumber());
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{errorMsg, ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
                return false;
            }
        }
        catch (CoreException e) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{e.getMessage(), ApuKernelValidator.getObjectLabel((EObject)apuKernelInfo, context)}, new Object[]{apuKernelInfo}, context));
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_MustNotBeVsdkKernelInfoName(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuKernelValidator.getModelValidator().validateVsdkContainsSameKernelInfoName(apuKernelInfo);
        if (!status.isOK()) {
            this.addToDiagnostics(status.getMessage(), (EObject)apuKernelInfo, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_AliasShouldntBeEmpty(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String alias = apuKernelInfo.getAlias();
        if (alias == null || alias.isEmpty()) {
            this.addToDiagnostics("Alias shouldn't be empty", (EObject)apuKernelInfo, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_NameShouldntBeEmpty(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = ApuKernelValidator.extractName(apuKernelInfo.getName());
        if (name == null || name.isEmpty()) {
            this.addToDiagnostics("Kernel name shouldn't be empty", (EObject)apuKernelInfo, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInfo_notNullIdentifire(ApuKernelInfo apuKernelInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String identifier = apuKernelInfo.getIdentifier();
        return identifier != null && !identifier.isEmpty();
    }

    public boolean validateApuKernelPortInfo(ApuKernelPortInfo apuKernelPortInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuKernelPortInfo, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuKernelPortInfo, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortInfo_NameShouldBeUnique(apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortInfo_NameShouldBeValidCIdentifier(apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortInfo_e0ekSpatialDepInRange(apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortInfo_NameShouldntBeEmpty(apuKernelPortInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortInfo_AliasShouldntBeEmpty(apuKernelPortInfo, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelPortInfo_NameShouldBeValidCIdentifier(ApuKernelPortInfo apuKernelPortInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = ApuKernelValidator.extractName(apuKernelPortInfo.getName());
        if (name == null || name.isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)name);
        if (!result.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{result.getMessage(), ApuKernelValidator.getObjectLabel((EObject)apuKernelPortInfo, context)}, new Object[]{apuKernelPortInfo}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortInfo_NameShouldBeUnique(ApuKernelPortInfo apuKernelPortInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = ApuKernelValidator.extractName(apuKernelPortInfo.getName());
        if (name == null || name.isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (ApuKernelPortInfo kernelPortInfo : apuKernelPortInfo.getKernelInfo().getPortInfos()) {
            eList.add((Object)kernelPortInfo);
        }
        eList.remove((Object)apuKernelPortInfo);
        String message = NLS.bind((String)"Duplicate Input/Output port name \"{0}\" in Kernel diagram", (Object)name);
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuKernelPortInfo, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuKernelValidator.getObjectLabel((EObject)apuKernelPortInfo, context)}, new Object[]{apuKernelPortInfo}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortInfo_e0ekSpatialDepInRange(ApuKernelPortInfo kpi, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = false;
        result &= this.checkIfe0ekSpatialInRange(kpi, kpi.getPortElementsInfo().getE0SizeX(), Messages.ApuKernelValidator_e0_size_X, diagnostics, context, 1);
        result &= this.checkIfe0ekSpatialInRange(kpi, kpi.getPortElementsInfo().getE0SizeY(), Messages.ApuKernelValidator_e0_size_Y, diagnostics, context, 1);
        result &= this.checkIfe0ekSpatialInRange(kpi, kpi.getPortElementsInfo().getEKSizeX(), Messages.ApuKernelValidator_ek_size_X, diagnostics, context, 1);
        result &= this.checkIfe0ekSpatialInRange(kpi, kpi.getPortElementsInfo().getEKSizeY(), Messages.ApuKernelValidator_ek_size_Y, diagnostics, context, 1);
        result &= this.checkIfe0ekSpatialInRange(kpi, kpi.getPortSpatialDepInfo().getSpatialDepLeft(), Messages.ApuKernelValidator_Spatial_Depth_Left, diagnostics, context, 0);
        result &= this.checkIfe0ekSpatialInRange(kpi, kpi.getPortSpatialDepInfo().getSpatialDepRight(), Messages.ApuKernelValidator_Spatial_Depth_Right, diagnostics, context, 0);
        result &= this.checkIfe0ekSpatialInRange(kpi, kpi.getPortSpatialDepInfo().getSpatialDepBottom(), Messages.ApuKernelValidator_Spatial_Depth_Bottom, diagnostics, context, 0);
        return result &= this.checkIfe0ekSpatialInRange(kpi, kpi.getPortSpatialDepInfo().getSpatialDepTop(), Messages.ApuKernelValidator_Spatial_Depth_Top, diagnostics, context, 0);
    }

    public boolean validateApuKernelPortInfo_NameShouldntBeEmpty(ApuKernelPortInfo apuKernelPortInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = ApuKernelValidator.extractName(apuKernelPortInfo.getName());
        if (name == null || name.isEmpty()) {
            this.addToDiagnostics("Kernel port name shouldn't be empty", (EObject)apuKernelPortInfo, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortInfo_AliasShouldntBeEmpty(ApuKernelPortInfo apuKernelPortInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String alias = apuKernelPortInfo.getAlias();
        if (alias == null || alias.isEmpty()) {
            this.addToDiagnostics("Kernel port alias shouldn't be empty", (EObject)apuKernelPortInfo, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortElementsInfo(ApuKernelPortElementsInfo apuKernelPortElementsInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuKernelPortElementsInfo, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuKernelPortElementsInfo, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortElementsInfo_E0SizeXShouldntBeEmpty(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortElementsInfo_E0SizeYShouldntBeEmpty(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortElementsInfo_EKSizeXShouldntBeEmpty(apuKernelPortElementsInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortElementsInfo_EKSizeYShouldntBeEmpty(apuKernelPortElementsInfo, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelPortElementsInfo_E0SizeXShouldntBeEmpty(ApuKernelPortElementsInfo apuKernelPortElementsInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String e0SizeX = apuKernelPortElementsInfo.getE0SizeX();
        if (e0SizeX == null || e0SizeX.isEmpty()) {
            this.addToDiagnostics("Kernel port's e0SizeX shouldn't be empty", apuKernelPortElementsInfo.eContainer(), diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortElementsInfo_E0SizeYShouldntBeEmpty(ApuKernelPortElementsInfo apuKernelPortElementsInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String e0SizeY = apuKernelPortElementsInfo.getE0SizeY();
        if (e0SizeY == null || e0SizeY.isEmpty()) {
            this.addToDiagnostics("Kernel port's e0SizeY shouldn't be empty", apuKernelPortElementsInfo.eContainer(), diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortElementsInfo_EKSizeXShouldntBeEmpty(ApuKernelPortElementsInfo apuKernelPortElementsInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String eKSizeX = apuKernelPortElementsInfo.getEKSizeX();
        if (eKSizeX == null || eKSizeX.isEmpty()) {
            this.addToDiagnostics("Kernel port's eKSizeX shouldn't be empty", apuKernelPortElementsInfo.eContainer(), diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortElementsInfo_EKSizeYShouldntBeEmpty(ApuKernelPortElementsInfo apuKernelPortElementsInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String eKSizeY = apuKernelPortElementsInfo.getEKSizeY();
        if (eKSizeY == null || eKSizeY.isEmpty()) {
            this.addToDiagnostics("Kernel port's eKSizeY shouldn't be empty", apuKernelPortElementsInfo.eContainer(), diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortSpatialDepInfo(ApuKernelPortSpatialDepInfo apuKernelPortSpatialDepInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuKernelPortSpatialDepInfo, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuKernelPortSpatialDepInfo, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortSpatialDepInfo_spatialDepLeftShouldntBeEmpty(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortSpatialDepInfo_spatialDepRightShouldntBeEmpty(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortSpatialDepInfo_spatialDepTopShouldntBeEmpty(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPortSpatialDepInfo_spatialDepBottomShouldntBeEmpty(apuKernelPortSpatialDepInfo, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelPortSpatialDepInfo_spatialDepLeftShouldntBeEmpty(ApuKernelPortSpatialDepInfo apuKernelPortSpatialDepInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String spatialDepLeft = apuKernelPortSpatialDepInfo.getSpatialDepLeft();
        if (spatialDepLeft == null || spatialDepLeft.isEmpty()) {
            this.addToDiagnostics("Kernel port's spatialDepLeft shouldn't be empty", apuKernelPortSpatialDepInfo.eContainer(), diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortSpatialDepInfo_spatialDepRightShouldntBeEmpty(ApuKernelPortSpatialDepInfo apuKernelPortSpatialDepInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String spatialDepRight = apuKernelPortSpatialDepInfo.getSpatialDepRight();
        if (spatialDepRight == null || spatialDepRight.isEmpty()) {
            this.addToDiagnostics("Kernel port's spatialDepRight shouldn't be empty", apuKernelPortSpatialDepInfo.eContainer(), diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortSpatialDepInfo_spatialDepTopShouldntBeEmpty(ApuKernelPortSpatialDepInfo apuKernelPortSpatialDepInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String spatialDepTop = apuKernelPortSpatialDepInfo.getSpatialDepTop();
        if (spatialDepTop == null || spatialDepTop.isEmpty()) {
            this.addToDiagnostics("Kernel port's spatialDepTop shouldn't be empty", apuKernelPortSpatialDepInfo.eContainer(), diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortSpatialDepInfo_spatialDepBottomShouldntBeEmpty(ApuKernelPortSpatialDepInfo apuKernelPortSpatialDepInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String spatialDepBottom = apuKernelPortSpatialDepInfo.getSpatialDepBottom();
        if (spatialDepBottom == null || spatialDepBottom.isEmpty()) {
            this.addToDiagnostics("Kernel port's spatialDepBottom shouldn't be empty", apuKernelPortSpatialDepInfo.eContainer(), diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPortAttributesInfo(ApuKernelPortAttributesInfo apuKernelPortAttributesInfo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(apuKernelPortAttributesInfo, diagnostics, context);
    }

    public boolean validateApuPortType(ApuPortType apuPortType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApuMemoryPart(ApuMemoryPart apuMemoryPart, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApuDataTiling(ApuDataTiling apuDataTiling, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApuDataScale(ApuDataScale apuDataScale, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApuChunkSize(ApuChunkSize apuChunkSize, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApuDataType(ApuDataType apuDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return APUKernelPlugin.INSTANCE;
    }

    private void addToDiagnostics(String msg, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{msg, ApuKernelValidator.getObjectLabel((EObject)eObject, context)}, new Object[]{eObject}, context));
        }
    }

    private static Apex2KernelModelValidator getModelValidator() {
        return Apex2KernelModelValidatorProvider.INSTANCE.getValidator();
    }

    private static String extractName(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("\"") && name.endsWith("\"")) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }
}

