/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apukernel.util;

import com.nxp.s32ds.ext.rcp.runtime.util.Strings;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.gte.apukernel.ApuPortType;
import com.nxp.s32ds.gte.apukernel.util.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class ApuKernelHelper {
    private static final int KERNEL_INPUTS_MAX_NUMBER = 25;
    private static final int KERNEL_OUTPUTS_MAX_NUMBER = 25;
    private static final int KERNEL_INPUTS_OUTPUTS_MAX_NUMBER = 32;
    public static final int E0_EK_MIN = 1;
    public static final int SPATIAL_DEP_MIN = 0;
    public static final int E0_EK_SPATIALDEP_MAX = 65535;
    private static final String PLUGIN_ID = "com.nxp.s32ds.gte.apukernel";
    private static final String PATH_UNDEFINED = "";

    public static String getE0EkSpatialDepErrorRangeMessage(String attrName, int min) {
        return ApuKernelHelper.getRangeErrorMessage(attrName, min, 65535);
    }

    private static String getRangeErrorMessage(String attrName, int min, int max) {
        String name = NLS.bind((String)Messages.ApuKernelValidator_apostrophe_0_apostrophe, (Object)attrName);
        String error = NLS.bind((String)Messages.ApuKernelValidator_value_should_be_in_the_range_from_0_to_1, (Object)min, (Object)max);
        return NLS.bind((String)Messages.ApuKernelValidator_0_dash_1, (Object)name, (Object)error);
    }

    public static int getKernelInputsMaxNumber() {
        return 25;
    }

    public static int getKernelOutputsMaxNumber() {
        return 25;
    }

    public static int getKernelInputsOutputsMaxNumber() {
        return 32;
    }

    public static List<ApuKernelPortInfo> getKernelPorts(ApuKernelInfo apuKernelInfo, ApuPortType portType) throws CoreException {
        if (apuKernelInfo == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, Messages.ApuKernelHelper_NullApuKernelInfo));
        }
        EList<ApuKernelPortInfo> ports = apuKernelInfo.getPortInfos();
        ArrayList<ApuKernelPortInfo> apuKernelPorts = new ArrayList<ApuKernelPortInfo>();
        for (ApuKernelPortInfo port : ports) {
            if (port.getPortAttrbutesInfo().getPortType().compareTo(portType) != 0) continue;
            apuKernelPorts.add(port);
        }
        return apuKernelPorts;
    }

    public static void update(ApuKernelSource source) {
        String category = source.getCategory();
        source.setCategory(category.concat("_temp"));
        source.setCategory(category);
    }

    public static String resolveKernelSourceBasePath(ApuKernelSource source) {
        String category;
        if (source != null && (category = source.getCategory()) != null && !category.isEmpty()) {
            return String.valueOf(Strings.toLowerCaseUnderscores((String)category)) + '/' + "src";
        }
        String basePath = "user_kernels/src";
        return basePath;
    }

    public static String getKernelBasePath(Object object) {
        ApuKernelSource source = null;
        if (object instanceof ApuKernelSource) {
            source = (ApuKernelSource)object;
        }
        if (object instanceof ApuKernelInfo) {
            ApuKernelInfo info = (ApuKernelInfo)object;
            source = info.getSource();
        }
        if (source != null) {
            ApuKernelHelper.resolveKernelSourceBasePath(source);
        }
        return PATH_UNDEFINED;
    }

    public static String getKernelMetaHeader(Object object) {
        String include;
        String path = PATH_UNDEFINED;
        ApuKernelSource source = null;
        if (object instanceof ApuKernelSource) {
            source = (ApuKernelSource)object;
        }
        if (object instanceof ApuKernelInfo) {
            ApuKernelInfo info = (ApuKernelInfo)object;
            source = info.getSource();
        }
        if (source != null && (include = source.getInclude()) != null && include.trim().length() > 0) {
            return include;
        }
        return path;
    }

    public static String getKernelHeaderName(Object object) {
        String path = ApuKernelHelper.getKernelMetaHeader(object);
        if (path.isEmpty()) {
            return PATH_UNDEFINED;
        }
        if (path.endsWith(".h")) {
            path = path.substring(0, path.lastIndexOf(".h"));
        }
        if (path.endsWith("_acf")) {
            path = path.substring(0, path.lastIndexOf("_acf"));
        }
        return path;
    }

    public static String getKernelHeaderApuName(Object object) {
        return String.valueOf(ApuKernelHelper.getKernelHeaderName(object)) + "_apu";
    }

    public static String getKernelHeaderAcfName(Object object) {
        return String.valueOf(ApuKernelHelper.getKernelHeaderName(object)) + "_acf";
    }
}

