/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apukernel;

import com.nxp.s32ds.ext.rcp.runtime.util.Strings;
import com.nxp.s32ds.gte.apuflow.ApuDefinitions;
import com.nxp.s32ds.gte.apukernel.ApuChunkSize;
import com.nxp.s32ds.gte.apukernel.ApuDataScale;
import com.nxp.s32ds.gte.apukernel.ApuDataTiling;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuKernelFactory;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortAttributesInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortElementsInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortSpatialDepInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apukernel.ApuPortType;

public final class ApuKernelInfos {
    private static final String DEFAULT_CATEGORY_POSTFIX = "_user_kernels";
    private static final String DEFAULT_INCLUDE_POSTFIX = "_user_kernel_acf.h";

    private ApuKernelInfos() {
    }

    public static final ApuKernelPortInfo createOutputPort(ApuKernelInfo apuKernelInfo) {
        ApuKernelPortInfo portInfo = ApuKernelFactory.eINSTANCE.createApuKernelPortInfo();
        String name = ApuDefinitions.proposeName((String)"Out", apuKernelInfo.getPortInfos());
        portInfo.setName(name);
        portInfo.setAlias(String.valueOf(apuKernelInfo.getAlias()) + "N_" + name);
        ApuKernelInfos.initPortParametrs(portInfo);
        portInfo.getPortAttrbutesInfo().setPortType(ApuPortType.ATTR_OUT);
        return portInfo;
    }

    private static void initPortParametrs(ApuKernelPortInfo portInfo) {
        ApuKernelPortAttributesInfo attributes = ApuKernelFactory.eINSTANCE.createApuKernelPortAttributesInfo();
        ApuKernelPortElementsInfo elements = ApuKernelFactory.eINSTANCE.createApuKernelPortElementsInfo();
        ApuKernelPortSpatialDepInfo spatialDep = ApuKernelFactory.eINSTANCE.createApuKernelPortSpatialDepInfo();
        portInfo.setPortElementsInfo(elements);
        portInfo.getPortElementsInfo().setE0DataType(ApuDataType.D08U);
        portInfo.setPortAttrbutesInfo(attributes);
        portInfo.getPortAttrbutesInfo().setPortType(ApuPortType.ATTR_IN);
        portInfo.getPortAttrbutesInfo().setMemoryPart(ApuMemoryPart.ATTR_CMEM);
        portInfo.getPortAttrbutesInfo().setDataTiling(ApuDataTiling.ATTR_NONSTATIC);
        portInfo.getPortAttrbutesInfo().setDataScale(ApuDataScale.ATTR_NONFIXED);
        portInfo.getPortAttrbutesInfo().setChunkSize(ApuChunkSize.ATTR_REG);
        portInfo.setPortSpatialDepInfo(spatialDep);
        portInfo.getPortSpatialDepInfo().setSpatialDepBottom("0");
        portInfo.getPortSpatialDepInfo().setSpatialDepTop("0");
        portInfo.getPortSpatialDepInfo().setSpatialDepRight("0");
        portInfo.getPortSpatialDepInfo().setSpatialDepLeft("0");
    }

    public static final ApuKernelPortInfo createInputPort(ApuKernelInfo apuKernelInfo) {
        ApuKernelPortInfo portInfo = ApuKernelFactory.eINSTANCE.createApuKernelPortInfo();
        String name = ApuDefinitions.proposeName((String)"In", apuKernelInfo.getPortInfos());
        portInfo.setName(name);
        portInfo.setAlias(String.valueOf(apuKernelInfo.getAlias()) + "N_" + name);
        ApuKernelInfos.initPortParametrs(portInfo);
        portInfo.getPortAttrbutesInfo().setPortType(ApuPortType.ATTR_IN);
        return portInfo;
    }

    public static final ApuKernelSource createApuKernelSource(String name) {
        ApuKernelSource apuKernelSource = ApuKernelFactory.eINSTANCE.createApuKernelSource();
        ApuKernelInfo kernelInfo = ApuKernelInfos.createKernelInfo(name);
        apuKernelSource.getKernelInfos().add((Object)kernelInfo);
        String dstName = name.toLowerCase();
        apuKernelSource.setCategory(String.valueOf(dstName) + DEFAULT_CATEGORY_POSTFIX);
        apuKernelSource.setInclude(String.valueOf(dstName) + DEFAULT_INCLUDE_POSTFIX);
        return apuKernelSource;
    }

    public static final ApuKernelInfo createKernelInfo(String name) {
        ApuKernelInfo apuKernel = ApuKernelFactory.eINSTANCE.createApuKernelInfo();
        apuKernel.setName(name);
        ApuKernelPortInfo firstInputPort = ApuKernelInfos.createInputPort(apuKernel);
        apuKernel.getPortInfos().add((Object)firstInputPort);
        ApuKernelPortInfo firstOutputPort = ApuKernelInfos.createOutputPort(apuKernel);
        apuKernel.getPortInfos().add((Object)firstOutputPort);
        return apuKernel;
    }

    public static final String createAliasForApuKernelPortByParentAliasAndName(String parentAlias, String name) {
        return String.valueOf(parentAlias) + "N_" + name;
    }

    public static final String createAliasForApuKernelByName(String kernelName) {
        return String.valueOf(Strings.toUpperCaseUnderscores((String)kernelName)) + "_K";
    }
}

