/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apukernel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ApuDataType implements Enumerator
{
    D08U(1, "d08u", "d08u"),
    D08S(2, "d08s", "d08s"),
    D16U(3, "d16u", "d16u"),
    D16S(4, "d16s", "d16s"),
    D32U(5, "d32u", "d32u"),
    D32S(6, "d32s", "d32s");

    public static final int D08U_VALUE = 1;
    public static final int D08S_VALUE = 2;
    public static final int D16U_VALUE = 3;
    public static final int D16S_VALUE = 4;
    public static final int D32U_VALUE = 5;
    public static final int D32S_VALUE = 6;
    private static final ApuDataType[] VALUES_ARRAY;
    public static final List<ApuDataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ApuDataType[]{D08U, D08S, D16U, D16S, D32U, D32S};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ApuDataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ApuDataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ApuDataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ApuDataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ApuDataType get(int value) {
        switch (value) {
            case 1: {
                return D08U;
            }
            case 2: {
                return D08S;
            }
            case 3: {
                return D16U;
            }
            case 4: {
                return D16S;
            }
            case 5: {
                return D32U;
            }
            case 6: {
                return D32S;
            }
        }
        return null;
    }

    private ApuDataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

