/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.s32v.s32v234.app.core.parsers;

import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangePayload;
import com.nxp.s32ds.cle.ide.core.listener.builder.MapContainer;
import java.util.List;
import java.util.stream.Collectors;

public class S32V2ComponentChangePayloadParser
extends MapContainer {
    public S32V2ComponentChangePayloadParser(ComponentChangePayload payload) {
        super(payload.getParameters());
    }

    public static S32V2ComponentChangePayloadParser parse(ComponentChangePayload payload) {
        return new S32V2ComponentChangePayloadParser(payload);
    }

    public List<String> getApuKernelSources() {
        return this.getKernelSources();
    }

    public List<String> getEmuKernelSources() {
        return this.getKernelSources();
    }

    public List<String> getApuLibraryNames() {
        return this.filterApuWithPrefix(this.getLibraryNames());
    }

    public List<String> getApuLibraryPaths() {
        return this.filterApu(this.getLibraryPaths());
    }

    public List<String> getEmuLibraryNames() {
        return this.filterEmuWithPrefix(this.getLibraryNames());
    }

    public List<String> getEmuLibraryPaths() {
        return this.filterEmu(this.getLibraryPaths());
    }

    private List<String> filterApu(List<String> list) {
        return this.filter(list, "${BUILD_APU_ARTIFACT}");
    }

    private List<String> filterApuWithPrefix(List<String> list) {
        return this.filterWithPrefix(list, "${BUILD_APU_ARTIFACT}");
    }

    private List<String> filterEmu(List<String> list) {
        return this.filter(list, "${BUILD_EMU_ARTIFACT}");
    }

    private List<String> filterEmuWithPrefix(List<String> list) {
        return this.filterWithPrefix(list, "${BUILD_EMU_ARTIFACT}");
    }

    private List<String> filterWithPrefix(List<String> list, String pattern) {
        return list.stream().filter(s -> s.startsWith(":" + pattern)).map(s -> ":" + s.substring(":".length() + pattern.length())).collect(Collectors.toList());
    }

    private List<String> filter(List<String> list, String pattern) {
        return list.stream().filter(s -> s.startsWith(pattern)).map(s -> s.substring(pattern.length())).collect(Collectors.toList());
    }

    private List<String> getKernelSources() {
        return (List)this.parameters.get("com.nxp.s32ds.cle.runtime.component.registry.block.uri");
    }

    private List<String> getLibraryNames() {
        return (List)this.parameters.get("com.nxp.s32ds.cle.runtime.component.registry.artifact.name");
    }

    private List<String> getLibraryPaths() {
        return (List)this.parameters.get("com.nxp.s32ds.cle.runtime.component.registry.artifact.path");
    }
}

