/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.s32v.s32v234.app.core.internal;

import com.nxp.s32ds.cle.s32v.s32v234.app.core.handlers.MarkerHandler;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import java.io.File;
import java.io.FileFilter;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class VariableChecker
implements IResourceChecker {
    private static final String RELASE_NOTES_FILE_NAME = "ReleaseNotes";
    private static final String PROBLEM_LABEL = "Variable %s not defined for configuration '%s'.";

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            this.removeMarker(project);
            ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project, true);
            if (desc != null) {
                ICConfigurationDescription[] configs;
                ICConfigurationDescription[] iCConfigurationDescriptionArray = configs = desc.getConfigurations();
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
                    String configuration = config.getName();
                    try {
                        String value = VariableChecker.getValueVariableForConfiguration(project, "S32DS_VSDK_DIR", config);
                        this.validatePath(value, configuration);
                    }
                    catch (CoreException e) {
                        this.createMarker(project, configuration, e.getStatus());
                    }
                    ++n2;
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus validatePath(String value, String confName) throws CoreException {
        if (value == null) {
            throw this.getErrorStatus(confName);
        }
        File path = new File(value);
        if (!path.exists()) {
            throw this.getErrorStatus(confName);
        }
        if (!this.scanFromPath(path).isOK()) {
            throw this.getErrorStatus(confName);
        }
        return Status.OK_STATUS;
    }

    private CoreException getErrorStatus(String confName) {
        String msg = String.format(PROBLEM_LABEL, "S32DS_VSDK_DIR", confName);
        Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", msg);
        return new CoreException((IStatus)status);
    }

    private IStatus scanFromPath(File path) {
        File[] files;
        File[] fileArray = files = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File currentFile = fileArray[n2];
            if (currentFile.getName().contains(RELASE_NOTES_FILE_NAME)) {
                return this.parceFile(currentFile);
            }
            ++n2;
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus parceFile(File currentFile) {
        Status status = new Status(0, "com.nxp.s32ds.cle.s32v.s32v234.app.core", "File found by path " + currentFile.getAbsolutePath());
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        return status;
    }

    private void createMarker(IProject project, String configuration, IStatus status) {
        MarkerHandler.createMarkerVSDKPathNotDef((IResource)project, configuration, status);
    }

    private void removeMarker(IProject project) {
        MarkerHandler.removeMarkerVSDKPathNotDef(project, null);
    }

    public static String getValueVariableForConfiguration(IProject project, String variable, ICConfigurationDescription config) throws CoreException {
        ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project, true);
        variable = VariableChecker.converToVariable(variable);
        if (desc != null && config != null) {
            try {
                ICdtVariableManager cdtVariableManager = CCorePlugin.getDefault().getCdtVariableManager();
                return cdtVariableManager.resolveValue(variable, "", "", config);
            }
            catch (Exception e) {
                Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        return "";
    }

    private static String converToVariable(String variable) {
        return "${" + variable + "}";
    }
}

