/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.s32v.s32v234.app.core.handlers;

import com.nxp.s32ds.cle.cdt.core.ComponentChangeEventHandler;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.s32v.s32v234.app.core.parsers.S32V2ComponentChangePayloadParser;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class S32VComponentChangeEventHandler
extends ComponentChangeEventHandler {
    private static final String EMU_CONFIGURATION_NAME = "EMU";
    private static final String TEST_EMU_CONFIGURATION_NAME = "TEST_EMU";
    private static final String APU_CONFIGURATION_NAME = "APU";
    private static final String APEX_TOOL_CPP_LINKER = "com.freescale.s32ds.vision.apex.tool.cpp.linker";
    private static final String CROSS_TOOL_CPP_COMPILER = "cdt.managedbuild.tool.gnu.cross.cpp.compiler";
    private static final String CROSS_TOOL_CPP_LINKER = "cdt.managedbuild.tool.gnu.cross.cpp.linker";
    private static final String GNU_CPP_LINKER_OPTION_LIBS = "gnu.cpp.link.option.libs";
    private static final String GNU_CPP_LINKER_OPTION_PATHS = "gnu.cpp.link.option.paths";
    private static final String GNU_CPP_COMPILER_OPTION_INCLUDE_PATHS = "gnu.cpp.compiler.option.include.paths";
    private static final String PREFIX1 = "${S32DS_";
    private static final String PREFIX2 = "}";

    public void onComponentChange(ComponentChangeEvent event) {
        super.onComponentChange(event);
        IProject project = this.getProject(this.targetComponentId);
        if (project != null) {
            IConfiguration[] configurations;
            S32V2ComponentChangePayloadParser parser = new S32V2ComponentChangePayloadParser(this.payload);
            IConfiguration[] iConfigurationArray = configurations = this.getConfigurations(project);
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration configuration = iConfigurationArray[n2];
                if (configuration.getName().equals(APU_CONFIGURATION_NAME)) {
                    this.modifyConfigurationOptions(parser.getApuLibraryNames(), configuration, APEX_TOOL_CPP_LINKER, GNU_CPP_LINKER_OPTION_LIBS, false);
                    this.modifyConfigurationOptions(parser.getApuLibraryPaths(), configuration, APEX_TOOL_CPP_LINKER, GNU_CPP_LINKER_OPTION_PATHS, true);
                }
                if (configuration.getName().equals(EMU_CONFIGURATION_NAME) || configuration.getName().equals(TEST_EMU_CONFIGURATION_NAME)) {
                    this.modifyConfigurationOptions(parser.getEmuKernelSources(), configuration, CROSS_TOOL_CPP_COMPILER, GNU_CPP_COMPILER_OPTION_INCLUDE_PATHS, true);
                    this.modifyConfigurationOptions(parser.getEmuLibraryNames(), configuration, CROSS_TOOL_CPP_LINKER, GNU_CPP_LINKER_OPTION_LIBS, false);
                    this.modifyConfigurationOptions(parser.getEmuLibraryPaths(), configuration, CROSS_TOOL_CPP_LINKER, GNU_CPP_LINKER_OPTION_PATHS, true);
                }
                ++n2;
            }
        }
    }

    private IProject getProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root != null && projectName != null && !projectName.isEmpty()) {
            return root.getProject(projectName);
        }
        return null;
    }

    private IConfiguration[] getConfigurations(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            return new IConfiguration[0];
        }
        IManagedProject managedProject = buildInfo.getManagedProject();
        IConfiguration[] configurations = managedProject.getConfigurations();
        return configurations;
    }

    private void modifyConfigurationOptions(List<String> elements, IConfiguration configuration, String toolId, String optionId, boolean addQuotes) {
        String[] modifiedOptions;
        ITool[] tools = configuration.getToolsBySuperClassId(toolId);
        if (tools.length > 0 && (modifiedOptions = this.getModifiedOptions(elements, tools[0], optionId, addQuotes)) != null) {
            try {
                configuration.setOption((IHoldsOptions)tools[0], tools[0].getOptionBySuperClassId(optionId), modifiedOptions);
                ManagedBuildManager.saveBuildInfo((IProject)((IProject)configuration.getOwner()), (boolean)true);
            }
            catch (BuildException e) {
                Log.logError((String)e.getMessage());
            }
        }
    }

    private String[] getModifiedOptions(List<String> elements, ITool tool, String optionId, boolean addQuotes) {
        List oldOptions = (List)tool.getOptionBySuperClassId(optionId).getValue();
        if (oldOptions == null) {
            return null;
        }
        String prefix = this.getPrefix();
        ListIterator itr = oldOptions.listIterator();
        while (itr.hasNext()) {
            String s = (String)itr.next();
            if (!s.contains(prefix)) continue;
            itr.remove();
        }
        List<String> newOptions = this.convert(prefix, elements, addQuotes);
        newOptions.addAll(oldOptions);
        return newOptions.toArray(new String[newOptions.size()]);
    }

    private List<String> convert(String prefix, List<String> source, boolean addQuotes) {
        List<String> result = source.stream().collect(Collectors.toList());
        ListIterator iterator = result.listIterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            StringBuilder sb = new StringBuilder();
            if (addQuotes) {
                sb.append("\"");
            }
            sb.append(prefix);
            sb.append(s);
            if (addQuotes) {
                sb.append("\"");
            }
            iterator.set(sb.toString());
        }
        return result;
    }

    private String getPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX1);
        sb.append(this.archetype);
        sb.append(PREFIX2);
        sb.append(PREFIX1);
        sb.append(this.groupId);
        sb.append(PREFIX2);
        sb.append(PREFIX1);
        sb.append(this.componentId);
        sb.append(PREFIX2);
        return sb.toString();
    }
}

