/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.s32v.s32v234.app.core.debugger;

import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.s32v.s32v234.app.core.internal.S32V2ConfigurationCreatorMessages;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class IspDebuggerLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    private static final String PATTERN_CONFIGURATION_FILE_NAME = "%s_%s_%s%s";
    private static final String PATTERN_WORKSPACE_LOCATION = "${workspace_loc:/%s%s}";
    private static final String PATTERN_DEVICECORE_ISP = "S32V234_%s%s";
    private static final String PATTERN_KERNELRESOURCE_ISP = "/ISP/ISP_kernels/%s.o%s";
    private static final int STRUCTURE_SEGMENTS_SIZE = 3;
    private static final String BUILD_POSTFIX_ISP = "_ISP";
    private static final String ARCHITYPE_ISP = "ISP";
    private static final HashMap<String, String> s32DebuggerCoreType2BootCoreName = new HashMap();

    static {
        s32DebuggerCoreType2BootCoreName.put("CortexA53", "A53_0_0");
        s32DebuggerCoreType2BootCoreName.put("CortexM0", "M0");
        s32DebuggerCoreType2BootCoreName.put("CortexM4", "M4");
        s32DebuggerCoreType2BootCoreName.put("CortexM7", "M7");
        s32DebuggerCoreType2BootCoreName.put("CortexR52", "R52_0_0");
        s32DebuggerCoreType2BootCoreName.put("CortexM33", "M33_0");
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String configurationName;
        String configurationFileName;
        IResource configurationResource;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(hostProject);
        if (description == null) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_project_nature_not_matched);
            throw new CoreException((IStatus)status);
        }
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        String ispEngineType = "";
        String ispEngineIndex = "";
        String[] splitedValues = this.retrieveEngineMetaInfo(attributes);
        if (splitedValues.length != 3) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_ISPEngine_Info_not_defined);
            throw new CoreException((IStatus)status);
        }
        ispEngineType = splitedValues[0];
        ispEngineIndex = splitedValues[1];
        if (ispEngineType == null || ispEngineType.isEmpty()) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_ISPEngine_kernel_type_not_defined);
            throw new CoreException((IStatus)status);
        }
        if (ispEngineIndex == null || ispEngineIndex.isEmpty()) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_ISPEngine_kernel_index_not_defined);
            throw new CoreException((IStatus)status);
        }
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType");
        if (debugerLaunchType == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        IFolder container = hostProject.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = hostProject;
        }
        if ((configurationResource = container.findMember(configurationFileName = String.valueOf(configurationName = IspDebuggerLaunchConfigurationCreator.createLaunchConfigurationFileName(hostProject, component, ispEngineType, ispEngineIndex)) + ".launch")) != null && configurationResource.isAccessible()) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationExistsStatus((IPath)configurationResource.getLocation()));
        }
        ILaunchConfigurationWorkingCopy workingCopy = debugerLaunchType.newInstance((IContainer)container, configurationName);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public static String createLaunchConfigurationFileName(IProject hostProject, String component, String ispEngineType, String ispEngineIndex) throws CoreException {
        String configurationFileName = "";
        if (hostProject == null || !hostProject.exists()) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_project_undefined);
            throw new CoreException((IStatus)status);
        }
        if (component == null) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_BuildConfiguration_not_defined);
            throw new CoreException((IStatus)status);
        }
        configurationFileName = String.format(PATTERN_CONFIGURATION_FILE_NAME, hostProject.getName(), component, ispEngineType, ispEngineIndex);
        return configurationFileName;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, Map<String, Object> attributes) throws CoreException {
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        String ispEngineType = "";
        String ispEngineIndex = "";
        String ispEngineKernelName = "";
        String[] splitedValues = this.retrieveEngineMetaInfo(attributes);
        if (splitedValues.length == 3) {
            ispEngineType = splitedValues[0];
            ispEngineIndex = splitedValues[1];
            ispEngineKernelName = splitedValues[2];
        }
        if (ispEngineType == null || ispEngineType.isEmpty()) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_ISPEngine_kernel_type_not_defined);
            throw new CoreException((IStatus)status);
        }
        if (ispEngineKernelName == null || ispEngineKernelName.isEmpty()) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_ISPEngine_kernel_name_not_defined);
            throw new CoreException((IStatus)status);
        }
        if (ispEngineIndex == null || ispEngineIndex.isEmpty()) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_ISPEngine_kernel_index_not_defined);
            throw new CoreException((IStatus)status);
        }
        String deviceCoreId = String.format(PATTERN_DEVICECORE_ISP, ispEngineType, ispEngineIndex);
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        if (deviceCoreDescriptor == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        String deviceId = deviceCoreDescriptor.getDeviceId();
        S32DebuggerParams params = new S32DebuggerParams();
        params.setDevice(deviceId);
        String coreName = s32DebuggerCoreType2BootCoreName.get(deviceCoreDescriptor.getCoreId());
        if (coreName == null) {
            coreName = deviceCoreDescriptor.getName();
        }
        params.setCore(coreName);
        String initializationScriptPath = DeviceCoreDebuggerDescriptors.getInitScript((String)deviceCoreDescriptor.getId(), (String)"s32debugger");
        params.setInitializationScript(initializationScriptPath);
        params.setClientExecutable(CoreDebuggerDescriptors.getClientPath((String)deviceCoreDescriptor.getCoreId(), (String)"s32debugger"));
        params.setClientCommands((String)S32DebuggerCoreActivator.getDeviceClientCommands().get(deviceCoreDescriptor.getId()));
        params.applyParams(workingCopy);
        String buildConfiguration = "";
        String programName = "";
        String projectName = hostProject.getName();
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(hostProject);
        programName = "ISP/" + projectName + BUILD_POSTFIX_ISP + ".elf";
        buildConfiguration = this.findBuildConfigurationByName(description, ARCHITYPE_ISP);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", false);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", false);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", false);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false);
        String kernelPathRelationByProject = String.format(PATTERN_KERNELRESOURCE_ISP, ispEngineKernelName.toLowerCase(), ispEngineType.toLowerCase());
        if (kernelPathRelationByProject != null && !kernelPathRelationByProject.isEmpty()) {
            workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", String.format(PATTERN_WORKSPACE_LOCATION, projectName, kernelPathRelationByProject));
            workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true);
            workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", true);
        }
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programName);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", false);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false);
        if (!buildConfiguration.isEmpty()) {
            workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfiguration);
        }
        workingCopy.setMappedResources(new IResource[]{hostProject});
    }

    private String findBuildConfigurationByName(ICProjectDescription description, String configName) {
        if (description == null) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_projectDescriptor_not_defined);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            return "";
        }
        if (configName == null || configName.isEmpty()) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_build_configuration_not_defined);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            return "";
        }
        ICConfigurationDescription[] iCConfigurationDescriptionArray = description.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configuration = iCConfigurationDescriptionArray[n2];
            if (configuration.getName().equals(configName)) {
                return configuration.getId();
            }
            ++n2;
        }
        return "";
    }

    private String[] retrieveEngineMetaInfo(Map<String, Object> attributes) throws CoreException {
        Object object = attributes.get("com.nxp.s32ds.cle.ide.debugger.registry.core.ipu.engines");
        if (object instanceof String) {
            String ispEnginesInfo = (String)object;
            return ispEnginesInfo.split(",");
        }
        Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_ISPEngine_Info_not_defined);
        throw new CoreException((IStatus)status);
    }
}

