/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.s32v.s32v234.app.core.debugger;

import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.s32v.s32v234.app.core.internal.S32V2ConfigurationCreatorMessages;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;

public class ApexDebuggerLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    private static final String S32DS_VSDK_DIR_VARIABLE = "${S32DS_VSDK_DIR}";
    private static final String S32V234_SDK = "s32v234_sdk";
    private static final String APU_ARTIFACT = "APU";
    private static final String DEVICE_CORE_BY_ARCHY_APUPROGRAM = "S32V234_APEX0_0";
    private static final HashMap<String, String> s32DebuggerCoreType2BootCoreName = new HashMap();
    private static final HashMap<String, String> mapPathMapping = new HashMap();

    static {
        s32DebuggerCoreType2BootCoreName.put("CortexA53", "A53_0_0");
        s32DebuggerCoreType2BootCoreName.put("CortexM0", "M0");
        s32DebuggerCoreType2BootCoreName.put("CortexM4", "M4");
        s32DebuggerCoreType2BootCoreName.put("CortexM7", "M7");
        s32DebuggerCoreType2BootCoreName.put("CortexR52", "R52_0_0");
        s32DebuggerCoreType2BootCoreName.put("CortexM33", "M33_0");
        mapPathMapping.put("s32v234_sdk\\libs\\apex\\acf_target\\build-apu-nxp-sa-d", "${S32DS_VSDK_DIR}//libs//apex//acf_target//build-apu-nxp-sa-d");
        mapPathMapping.put("s32v234_sdk\\libs\\apex\\common\\build-apu-nxp-sa-d", "${S32DS_VSDK_DIR}//libs//apex/common//build-apu-nxp-sa-d");
        mapPathMapping.put(S32V234_SDK, S32DS_VSDK_DIR_VARIABLE);
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String configurationName;
        String configurationFileName;
        IResource configurationResource;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(hostProject);
        if (description == null) {
            Status status = new Status(4, "com.nxp.s32ds.cle.s32v.s32v234.app.core", S32V2ConfigurationCreatorMessages.ConfigurationCreator_project_nature_not_matched);
            throw new CoreException((IStatus)status);
        }
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType");
        if (debugerLaunchType == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        ILaunchConfigurationWorkingCopy workingCopy = null;
        IFolder container = hostProject.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = hostProject;
        }
        if ((configurationResource = container.findMember(configurationFileName = String.valueOf(configurationName = ApexDebuggerLaunchConfigurationCreator.createLaunchConfigurationFileName(hostProject, component)) + ".launch")) != null && configurationResource.isAccessible()) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationExistsStatus((IPath)configurationResource.getLocation()));
        }
        workingCopy = debugerLaunchType.newInstance((IContainer)container, configurationName);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public static String createLaunchConfigurationFileName(IProject hostProject, String component) throws CoreException {
        if (hostProject == null || !hostProject.exists()) {
            throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.core", "Undefined project"));
        }
        if (component == null) {
            throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.core", "Undefined componet"));
        }
        return String.format("%s_%s", hostProject.getName(), component);
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, Map<String, Object> attributes) throws CoreException {
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(hostProject);
        if (description == null) {
            return;
        }
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        String deviceCoreId = DEVICE_CORE_BY_ARCHY_APUPROGRAM;
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        S32DebuggerParams params = new S32DebuggerParams();
        if (deviceCoreDescriptor == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        String deviceId = deviceCoreDescriptor.getDeviceId();
        params.setDevice(deviceId);
        String coreName = s32DebuggerCoreType2BootCoreName.get(deviceCoreDescriptor.getCoreId());
        if (coreName == null) {
            coreName = deviceCoreDescriptor.getName();
        }
        params.setCore(coreName);
        String initializationScriptPath = DeviceCoreDebuggerDescriptors.getInitScript((String)deviceCoreDescriptor.getId(), (String)"s32debugger");
        params.setInitializationScript(initializationScriptPath);
        params.setClientExecutable(CoreDebuggerDescriptors.getClientPath((String)deviceCoreDescriptor.getCoreId(), (String)"s32debugger"));
        params.setClientCommands((String)S32DebuggerCoreActivator.getDeviceClientCommands().get(deviceCoreDescriptor.getId()));
        params.applyParams(workingCopy);
        String buildArtifact = "";
        String buildConfiguration = "";
        buildArtifact = "APU/" + component.toUpperCase() + ".elf";
        buildConfiguration = this.findBuildConfigurationByName(description, APU_ARTIFACT);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", true);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", true);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", component.toUpperCase());
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", hostProject.getName());
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", false);
        workingCopy.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfiguration);
        String type = workingCopy.getType().getSourceLocatorId();
        IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
        AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
        director.initializeDefaults((ILaunchConfiguration)workingCopy);
        MappingSourceContainer srcContainer = new MappingSourceContainer(S32V234_SDK);
        for (Map.Entry<String, String> entryPath : mapPathMapping.entrySet()) {
            MapEntrySourceContainer entry = new MapEntrySourceContainer(entryPath.getKey(), (IPath)new Path(this.getDebuggerMappingPath(entryPath.getValue())));
            srcContainer.addMapEntry(entry);
        }
        ISourceContainer[] currentSoucreContainer = director.getSourceContainers();
        ArrayList<Object> lstElements = new ArrayList<Object>();
        lstElements.addAll(Arrays.asList(currentSoucreContainer));
        lstElements.add(srcContainer);
        director.setSourceContainers(lstElements.toArray(new ISourceContainer[lstElements.size()]));
        workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
        workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
        workingCopy.setMappedResources(new IResource[]{hostProject});
    }

    private String findBuildConfigurationByName(ICProjectDescription description, String configName) {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = description.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configuration = iCConfigurationDescriptionArray[n2];
            if (configuration.getName().equals(configName)) {
                return configuration.getId();
            }
            ++n2;
        }
        return "";
    }

    private String getDebuggerMappingPath(String value) {
        String substitutedValue = "";
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            substitutedValue = stringVariableManager.performStringSubstitution(value);
        }
        catch (CoreException e) {
            S32DebuggerCoreActivator.log((IStatus)e.getStatus());
        }
        return substitutedValue;
    }
}

