/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.validation;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.mdt.ide.c.defines.MdtCDefineRegistry;
import com.nxp.s32ds.mdt.ide.c.defines.MdtCDefineRegistryManager;
import com.nxp.s32ds.mdt.ide.c.evaluation.MdtCDefineEvaluator;
import com.nxp.s32ds.mdt.ide.internal.validation.MdtValidationActivator;
import com.nxp.s32ds.mdt.ide.validation.MdtValidator;
import com.nxp.s32ds.mdt.ide.validation.MdtValidatorMessageProducer;
import com.nxp.s32ds.mdt.ide.validation.MdtValidatorMessages;
import com.nxp.s32ds.mdt.ide.validation.MdtValidatorNameProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.osgi.util.NLS;

public class MdtValidatorBase<T extends EObject>
implements MdtValidator<T> {
    private final Class<T> rootClass;
    private final MdtCDefineRegistryManager<T> registryManager;
    private final String diagnosticSource;
    private final MdtValidatorNameProvider provider;

    public MdtValidatorBase(Class<T> rootClass, MdtCDefineRegistryManager<T> registryManager, String diagnosticSource, MdtValidatorNameProvider provider) {
        this.rootClass = rootClass;
        this.registryManager = registryManager;
        this.diagnosticSource = diagnosticSource;
        this.provider = provider;
    }

    @Override
    public String getClassName(EObject eObject, EClass eClass) {
        String name = null;
        if (this.provider != null) {
            name = this.provider.getClassName(eObject, eClass);
        }
        if (name == null) {
            name = eClass.getName();
        }
        return this.wrapToApostrophes(name);
    }

    @Override
    public String getAttributeName(EObject eObject, EAttribute eAttribute) {
        String name = null;
        if (this.provider != null) {
            name = this.provider.getAttributeName(eObject, eAttribute);
        }
        if (name == null) {
            name = eAttribute.getName();
        }
        return this.wrapToApostrophes(name);
    }

    @Override
    public IStatus validateFieldIsNotEmpty(int severity, EObject eObject, EAttribute eAttribute) {
        EClass eClass = eObject.eClass();
        EList eAllAttributes = eClass.getEAllAttributes();
        if (!eAllAttributes.contains((Object)eAttribute)) {
            throw new IllegalArgumentException("Class " + eClass.getName() + " does not have attrbute " + eAttribute.getName());
        }
        Object object = eObject.eGet((EStructuralFeature)eAttribute);
        if (!(object instanceof String) || ((String)object).trim().isEmpty()) {
            return MdtValidationActivator.getInstance().createStatus(severity, NLS.bind((String)MdtValidatorMessages._0_value_should_be_defined, (Object)this.getAttributeName(eObject, eAttribute)));
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validateFieldIsNotEmpty(EObject eObject, EAttribute eAttribute) {
        return this.validateFieldIsNotEmpty(4, eObject, eAttribute);
    }

    @Override
    public IStatus validateFieldValue(EObject eObject, EAttribute eAttribute) {
        return this.validateFieldValue(eObject, eAttribute, false, 0, Integer.MAX_VALUE);
    }

    @Override
    public IStatus validateFieldValue(EObject eObject, EAttribute eAttribute, int lowerBound) {
        return this.validateFieldValue(eObject, eAttribute, false, lowerBound, Integer.MAX_VALUE);
    }

    @Override
    public IStatus validateFieldValue(EObject eObject, EAttribute eAttribute, int lowerBound, int upperBound) {
        return this.validateFieldValue(eObject, eAttribute, false, lowerBound, upperBound);
    }

    @Override
    public IStatus validateFieldValueEvaluation(EObject eObject, EAttribute eAttribute) {
        return this.validateFieldValue(eObject, eAttribute, true, 0, Integer.MAX_VALUE);
    }

    private IStatus validateFieldValue(EObject eObject, EAttribute eAttribute, boolean failOnCommonValidation, int lowerBound, int upperBound) {
        EObject root = EObjects.eContainer((EObject)eObject, this.rootClass);
        if (root == null) {
            throw new IllegalStateException("Cannot fetch container with type " + this.rootClass.getName() + " from object " + eObject);
        }
        IStatus status = this.validateFieldIsNotEmpty(eObject, eAttribute);
        if (!status.isOK()) {
            return status;
        }
        Object object = eObject.eGet((EStructuralFeature)eAttribute);
        String value = ((String)object).trim();
        IStatus checkCommonEvaluation = this.checkEvaluation(root);
        if (!checkCommonEvaluation.isOK()) {
            if (failOnCommonValidation) {
                return checkCommonEvaluation;
            }
            return Status.OK_STATUS;
        }
        status = upperBound == Integer.MAX_VALUE ? this.validateExpression(root, val -> val >= lowerBound, value, 4, NLS.bind((String)MdtValidatorMessages._value_should_be_greater_than_or_equal_to_0, (Object)lowerBound)) : this.validateExpression(root, val -> val >= lowerBound && val <= upperBound, value, 4, NLS.bind((String)MdtValidatorMessages._value_should_be_in_the_range_from_0_to_1, (Object)lowerBound, (Object)upperBound));
        if (status.isOK()) {
            return Status.OK_STATUS;
        }
        return MdtValidationActivator.getInstance().createError(NLS.bind((String)MdtValidatorMessages._0_dash_1, (Object)this.getAttributeName(eObject, eAttribute), (Object)status.getMessage()));
    }

    @Override
    public IStatus validateExpression(T root, Function<Integer, Boolean> function, String script, int severity, String message) {
        IStatus checkEvaluation = this.checkEvaluation(root);
        if (!checkEvaluation.isOK()) {
            return checkEvaluation;
        }
        String constantsScript = this.buildConstantsScript(root);
        String fullScript = String.valueOf(constantsScript) + "\n" + script;
        try {
            Integer eval = MdtCDefineEvaluator.INSTANCE.evalInteger(root, fullScript);
            if (!function.apply(eval).booleanValue()) {
                return MdtValidationActivator.getInstance().createStatus(severity, message);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus checkEvaluation(T root) {
        if (!MdtCDefineEvaluator.INSTANCE.isActivated()) {
            return MdtValidationActivator.getInstance().createError(MdtValidatorMessages._script_engine_is_unavailable);
        }
        MdtCDefineRegistry defineRegistry = this.registryManager.getDefineRegistry(root);
        return MdtCDefineEvaluator.INSTANCE.checkScript(root, defineRegistry.getDefines(root));
    }

    @Override
    public boolean createError(DiagnosticChain diagnostics, String text, EObject object, Map<Object, Object> context) {
        if (diagnostics != null) {
            diagnostics.add(this.createDiagnostic(4, NLS.bind((String)MdtValidatorMessages._label_message, (Object)MdtValidatorBase.getObjectLabel(object, context), (Object)text), object));
        }
        return false;
    }

    @Override
    public boolean createWarning(DiagnosticChain diagnostics, String text, EObject object, Map<Object, Object> context) {
        if (diagnostics != null) {
            diagnostics.add(this.createDiagnostic(2, NLS.bind((String)MdtValidatorMessages._label_message, (Object)MdtValidatorBase.getObjectLabel(object, context), (Object)text), object));
        }
        return false;
    }

    @Override
    public boolean createDiagnostic(DiagnosticChain diagnostics, IStatus status, EObject object, Map<Object, Object> context) {
        if (status.isOK()) {
            return true;
        }
        if (diagnostics == null) {
            return false;
        }
        ArrayList<IStatus> children = MdtValidatorBase.extractChildren(status);
        for (IStatus iStatus : children) {
            String message = NLS.bind((String)MdtValidatorMessages._label_message, (Object)MdtValidatorBase.getObjectLabel(object, context), (Object)MdtValidatorBase.lowerCaseFirstCharacter(iStatus.getMessage()));
            switch (iStatus.getSeverity()) {
                case 4: {
                    diagnostics.add(this.createErrorInternal(message, object));
                    break;
                }
                case 2: {
                    diagnostics.add(this.createWarningInternal(message, object));
                    break;
                }
            }
        }
        return false;
    }

    public static String lowerCaseFirstCharacter(String statusMessage) {
        if (statusMessage != null && statusMessage.length() > 1) {
            statusMessage = String.valueOf(Character.toLowerCase(statusMessage.charAt(0))) + statusMessage.substring(1);
        }
        return statusMessage;
    }

    @Override
    public <K, O extends EObject> boolean createDiagnosticErrorForDuplicates(DiagnosticChain diagnostics, Map<K, List<O>> duplicates, MdtValidatorMessageProducer<K, O> messageProducer, Map<Object, Object> context) {
        return this.createDiagnosticForDuplicates(diagnostics, duplicates, messageProducer, 4, context);
    }

    @Override
    public <K, O extends EObject> boolean createDiagnosticForDuplicates(DiagnosticChain diagnostics, Map<K, List<O>> keyToObjectsMap, MdtValidatorMessageProducer<K, O> messageProducer, int severity, Map<Object, Object> context) {
        Set duplicates = keyToObjectsMap.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toSet());
        if (duplicates.isEmpty()) {
            return true;
        }
        if (diagnostics == null) {
            return false;
        }
        for (Map.Entry entry : duplicates) {
            for (EObject object : (List)entry.getValue()) {
                diagnostics.add(this.createDiagnostic(severity, NLS.bind((String)MdtValidatorMessages._label_message, (Object)MdtValidatorBase.getObjectLabel(object, context), (Object)messageProducer.getMessage(entry.getKey(), object)), object));
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    @Override
    public String wrapToApostrophes(String string) {
        return NLS.bind((String)MdtValidatorMessages._apostrophe_0_apostrophe, (Object)string);
    }

    private String buildConstantsScript(T root) {
        MdtCDefineRegistry defineRegistry = this.registryManager.getDefineRegistry(root);
        return MdtCDefineEvaluator.INSTANCE.buildConstantsScript(defineRegistry.getDefines(root));
    }

    private Diagnostic createErrorInternal(String text, EObject object) {
        return this.createDiagnostic(4, text, object);
    }

    private Diagnostic createWarningInternal(String text, EObject object) {
        return this.createDiagnostic(2, text, object);
    }

    private Diagnostic createDiagnostic(int severity, String text, EObject object) {
        return new BasicDiagnostic(severity, this.diagnosticSource, 0, text, new Object[]{object});
    }

    private static ArrayList<IStatus> extractChildren(IStatus status) {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        MdtValidatorBase.extractChildren(result, status);
        return result;
    }

    private static void extractChildren(ArrayList<IStatus> list, IStatus status) {
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus iStatus = iStatusArray[n2];
                MdtValidatorBase.extractChildren(list, iStatus);
                ++n2;
            }
        } else {
            list.add(status);
        }
    }

    private static String getObjectLabel(EObject eObject, Map<Object, Object> context) {
        return EObjectValidator.getObjectLabel((EObject)eObject, context);
    }

    @Override
    public IStatus validateFieldValueAsIntIsNotZero(EObject eObject, EAttribute eAttribute) {
        try {
            if (this.getFieldValueAsInt(eObject, eAttribute) == 0) {
                return MdtValidationActivator.getInstance().createError(NLS.bind((String)MdtValidatorMessages._0_dash_1, (Object)this.getAttributeName(eObject, eAttribute), (Object)MdtValidatorMessages._value_should_not_be_equals_to_zero));
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    @Override
    public IStatus validateFieldValueAsInt(EObject eObject, EAttribute eAttribute) {
        return this.validateFieldValueAsInt(eObject, eAttribute, 0, Integer.MAX_VALUE);
    }

    @Override
    public IStatus validateFieldValueAsInt(EObject eObject, EAttribute eAttribute, int lowerBound) {
        return this.validateFieldValueAsInt(eObject, eAttribute, lowerBound, Integer.MAX_VALUE);
    }

    private int getFieldValueAsInt(EObject eObject, EAttribute eAttribute) throws CoreException {
        IStatus status = this.validateFieldIsNotEmpty(eObject, eAttribute);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        Object object = eObject.eGet((EStructuralFeature)eAttribute);
        String value = ((String)object).trim();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException(MdtValidationActivator.getInstance().createError(NLS.bind((String)MdtValidatorMessages._0_dash_1, (Object)this.getAttributeName(eObject, eAttribute), (Object)MdtValidatorMessages._value_should_be_an_integer_number)));
        }
    }

    @Override
    public IStatus validateFieldValueAsInt(EObject eObject, EAttribute eAttribute, int lowerBound, int upperBound) {
        try {
            String error = null;
            int intValue = this.getFieldValueAsInt(eObject, eAttribute);
            if (upperBound == Integer.MAX_VALUE) {
                if (intValue < lowerBound) {
                    error = NLS.bind((String)MdtValidatorMessages._value_should_be_greater_than_or_equal_to_0, (Object)lowerBound);
                }
            } else if (intValue < lowerBound || intValue > upperBound) {
                error = NLS.bind((String)MdtValidatorMessages._value_should_be_in_the_range_from_0_to_1, (Object)lowerBound, (Object)upperBound);
            }
            if (error == null) {
                return Status.OK_STATUS;
            }
            return MdtValidationActivator.getInstance().createError(NLS.bind((String)MdtValidatorMessages._0_dash_1, (Object)this.getAttributeName(eObject, eAttribute), (Object)error));
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }
}

