/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.vlab.internal.core;

import com.nxp.s32ds.debug.ide.core.DebuggerLaunchSequence;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.vlab.core.VLABSimulatorCoreActivator;
import com.nxp.s32ds.debug.ide.vlab.internal.core.VLABSimulatorBackend;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorAttributesValidator;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorParams;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorStartupParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;

public class VLABSimulatorLaunchSequence
extends DebuggerLaunchSequence {
    private static final String STEP_DATA_MODEL_INITIALIZATION_COMPLETE = "stepDataModelInitializationComplete";
    private static final String STEP_NEW_PROCESS = "stepNewProcess";
    private static final String STEP_INITIALIZE_SIMULATOR_FINAL_LAUNCH_SEQUENCE = "stepInitializeSimulatorFinalLaunchSequence";
    private static final String STEP_EXECUTE_VLAB_SERVER_COMMAND = "stepExecuteVLABServerCommand";
    private static final String STEP_INITIALIZE_SIMULATOR = "stepInitializeSimulator";
    private static final String STEP_DEBUGGER_CLEANUP = "stepDebuggerCleanup";
    private static final String STEP_EXECUTE_USER_RUN_COMMANDS = "stepExecuteUserRunCommands";
    private static final String STEP_RESUME = "stepResume";
    private static final String STEP_SET_BREAKPOINT = "stepSetBreakpoint";
    private static final String STEP_SET_PC = "stepSetPc";
    private static final String STEP_START_TRACKING_BREAKPOINTS = "stepStartTrackingBreakpoints";
    private static final String STEP_INITIALIZE_MEMORY = "stepInitializeMemory";
    private static final String STEP_ASSIGN_P_ID_TO_CONTAINER = "stepAssignPIdToContainer";
    private static final String STEP_LOAD_IMAGE = "stepLoadImage";
    private static final String STEP_LOAD_SYMBOLS = "stepLoadSymbols";
    private static final String STEP_CONNECT_TO_SIMULATOR = "stepConnectToSimulator";
    private static final String STEP_EXECUTE_INIT_COMMANDS = "executeInitCommands";
    private static final String STEP_RUN_SIMULATION = "stepRunSimulation";
    private static final String CONTINUE_CMD = "-exec-continue";
    private static final String TBREAK_S = "tbreak %s";
    private static final String SET_PC_S = "set $pc=0x%s";
    private static final String LOAD_S_S = "load \"%s\" %s";
    private static final String SYMBOL_FILE_S = "symbol-file \"%s\"";
    private static final String ADD_SYMBOL_FILE_S_S = "add-symbol-file \"%s\" %s";
    private static final String HEX_PREFIX = "0x";
    private static final String REMOTE_CONNECTION_CMD = "-target-select remote %s:%s";
    protected static final String GROUP_VLAB_SIMULATOR = "GROUP_VLABSimulator";
    private IGDBControl commandControl;
    private IMIProcesses procService;
    private IMIContainerDMContext containerContext;
    private VLABSimulatorBackend vlabSimulatorBackend;
    private VLABSimulatorAttributesValidator validator;
    private VLABSimulatorParams debuggerParams;
    private VLABSimulatorStartupParams startupParams;
    private boolean runServer;

    public VLABSimulatorLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)rm.getProgressMonitor(), (int)100);
        ILaunchConfiguration lc = this.launch.getLaunchConfiguration();
        this.debuggerParams = VLABSimulatorParams.getParams((ILaunchConfiguration)lc);
        this.startupParams = VLABSimulatorStartupParams.getParams((ILaunchConfiguration)lc);
        this.validator = new VLABSimulatorAttributesValidator();
        this.runServer = this.debuggerParams.isDoLaunchServer();
        monitor.worked(100);
        IStatus status = this.validator.validateParameters(this.debuggerParams, this.startupParams);
        rm.done(status);
    }

    private void queueCommand(String command, RequestMonitor rm) {
        if (!command.isEmpty()) {
            this.commandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.commandControl.getContext(), command), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.removeAll(Arrays.asList(STEP_NEW_PROCESS));
            orderList.add(orderList.indexOf(STEP_DATA_MODEL_INITIALIZATION_COMPLETE), GROUP_VLAB_SIMULATOR);
            return orderList.toArray(new String[orderList.size()]);
        }
        if (GROUP_VLAB_SIMULATOR.equals(group)) {
            return new String[]{STEP_INITIALIZE_SIMULATOR_FINAL_LAUNCH_SEQUENCE, STEP_INITIALIZE_SIMULATOR, STEP_EXECUTE_VLAB_SERVER_COMMAND, STEP_LOAD_SYMBOLS, STEP_CONNECT_TO_SIMULATOR, STEP_EXECUTE_INIT_COMMANDS, STEP_LOAD_IMAGE, STEP_ASSIGN_P_ID_TO_CONTAINER, STEP_INITIALIZE_MEMORY, STEP_START_TRACKING_BREAKPOINTS, STEP_SET_PC, STEP_SET_BREAKPOINT, STEP_RESUME, STEP_RUN_SIMULATION, STEP_EXECUTE_USER_RUN_COMMANDS, STEP_DEBUGGER_CLEANUP};
        }
        return super.getExecutionOrder(group);
    }

    @ReflectionSequence.Execute
    public void stepInitializeSimulatorFinalLaunchSequence(RequestMonitor rm) {
        this.tracker = new DsfServicesTracker(VLABSimulatorCoreActivator.getContext(), this.getSession().getId());
        if (this.tracker == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", ErrorStatuses.getGDBServerStartFailedStatus());
            return;
        }
        this.vlabSimulatorBackend = (VLABSimulatorBackend)((Object)this.tracker.getService(VLABSimulatorBackend.class));
        if (this.vlabSimulatorBackend == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", ErrorStatuses.getGDBNoBackendStatus());
            return;
        }
        this.commandControl = (IGDBControl)this.tracker.getService(IGDBControl.class);
        if (this.commandControl == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", ErrorStatuses.getGDBNoControlStatus());
            return;
        }
        this.procService = (IMIProcesses)this.tracker.getService(IMIProcesses.class);
        if (this.procService == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", ErrorStatuses.getGDBNoStatusProcessor());
            return;
        }
        this.containerContext = this.procService.createContainerContextFromGroupId(this.commandControl.getContext(), "i1");
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeSimulator(RequestMonitor rm) {
        if (this.runServer) {
            this.vlabSimulatorBackend.setProcessParameters(this.debuggerParams.getToolboxScriptName(), this.debuggerParams.getCore(), this.debuggerParams.getPortNumber());
            if (!this.vlabSimulatorBackend.launchGdbServer(this.debuggerParams.getSimulatorExecutable())) {
                this.shutdownOnError("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", null);
                return;
            }
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void executeInitCommands(RequestMonitor rm) {
        String initCommands = this.startupParams.getInitializationCommands();
        if (!initCommands.isEmpty()) {
            this.queueCommand(initCommands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepExecuteVLABServerCommand(RequestMonitor rm) {
        if (this.runServer && !this.vlabSimulatorBackend.runServerCommand(Integer.parseInt(this.debuggerParams.getDelay()))) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", null);
            return;
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepRunSimulation(RequestMonitor rm) {
        if (this.runServer && !this.vlabSimulatorBackend.runSimulation()) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", null);
            return;
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepLoadSymbols(RequestMonitor rm) {
        if (this.startupParams.isDoLoadSymbols()) {
            String fileWithSymbolsPath;
            if (this.startupParams.isUseProjectBinaryForSymbols()) {
                IPath path = this.vlabSimulatorBackend.getProgramPath();
                fileWithSymbolsPath = path.toOSString();
            } else {
                fileWithSymbolsPath = this.startupParams.getSymbolsFileName();
                fileWithSymbolsPath = DebuggerUtils.substitute((String)fileWithSymbolsPath);
            }
            fileWithSymbolsPath = fileWithSymbolsPath.replace("\\", "\\\\");
            String symbolsOffset = this.startupParams.getSymbolsOffset();
            if (symbolsOffset != null && !symbolsOffset.isEmpty()) {
                symbolsOffset = HEX_PREFIX + symbolsOffset;
                this.queueCommand(String.format(ADD_SYMBOL_FILE_S_S, fileWithSymbolsPath, symbolsOffset), rm);
            } else {
                this.queueCommand(String.format(SYMBOL_FILE_S, fileWithSymbolsPath), rm);
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepConnectToSimulator(RequestMonitor rm) {
        this.queueCommand(String.format(REMOTE_CONNECTION_CMD, this.debuggerParams.getHostNameOrIPAddress(), this.debuggerParams.getPortNumber()), rm);
    }

    @ReflectionSequence.Execute
    public void stepLoadImage(RequestMonitor rm) {
        if (this.startupParams.isDoLoadImage()) {
            String imageFilePath;
            if (this.startupParams.isUseProjectBinaryForImage()) {
                imageFilePath = this.vlabSimulatorBackend.getProgramPath().toOSString();
            } else {
                imageFilePath = this.startupParams.getImageFileName();
                imageFilePath = DebuggerUtils.substitute((String)imageFilePath);
            }
            String imageOffset = this.startupParams.getImageOffset();
            if (imageOffset != null && !imageOffset.isEmpty()) {
                imageOffset = HEX_PREFIX + imageOffset;
            }
            this.queueCommand(String.format(LOAD_S_S, imageFilePath.replace("\\", "\\\\"), imageOffset), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepAssignPIdToContainer(RequestMonitor rm) {
        this.containerContext = this.procService.createContainerContextFromGroupId(this.commandControl.getContext(), this.containerContext.getGroupId());
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeMemory(RequestMonitor rm) {
        IGDBMemory memory = (IGDBMemory)this.tracker.getService(IGDBMemory.class);
        IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)this.containerContext, IMemory.IMemoryDMContext.class);
        if (memory == null || memContext == null) {
            rm.done();
            return;
        }
        memory.initializeMemoryData(memContext, rm);
    }

    @ReflectionSequence.Execute
    public void stepStartTrackingBreakpoints(RequestMonitor rm) {
        MIBreakpointsManager bpmService = (MIBreakpointsManager)this.tracker.getService(MIBreakpointsManager.class);
        bpmService.startTrackingBpForProcess((IRunControl.IContainerDMContext)this.containerContext, rm);
    }

    @ReflectionSequence.Execute
    public void stepSetPc(RequestMonitor rm) {
        if (this.startupParams.isDoSetPcRegister()) {
            this.queueCommand(String.format(SET_PC_S, this.startupParams.getPcRegisterValue()), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetBreakpoint(RequestMonitor rm) {
        if (this.startupParams.isDoSetStopAt()) {
            this.queueCommand(String.format(TBREAK_S, this.startupParams.getStopAt()), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepResume(RequestMonitor rm) {
        if (this.startupParams.isDoResume()) {
            this.queueCommand(CONTINUE_CMD, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepExecuteUserRunCommands(RequestMonitor rm) {
        String runCommands = this.startupParams.getRunCommands();
        if (!runCommands.isEmpty()) {
            this.queueCommand(runCommands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepDebuggerCleanup(RequestMonitor rm) {
        this.cleanUp();
        rm.done();
    }
}

