/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.vlab.internal.core;

import com.freescale.s32ds.cross.core.ProjectContextSaver;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorParams;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class VLABSimulatorLaunchConfigurationSupport
implements LaunchConfigurationCreator {
    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        IResource launchResource;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.nxp.s32ds.debug.ide.vlab.core.vLABSimulatorLaunchConfigurationType");
        if (debugerLaunchType == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        ILaunchConfigurationWorkingCopy workingCopy = null;
        IFolder container = hostProject.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = hostProject;
        }
        if ((launchResource = container.findMember(String.valueOf(component) + ".launch")) != null && launchResource.isAccessible()) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationExistsStatus((IPath)launchResource.getLocation()));
        }
        workingCopy = debugerLaunchType.newInstance((IContainer)container, component);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, Map<String, Object> attributes) throws CoreException {
        DeviceCoreDescriptor deviceCoreDescriptor;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        ProjectContextSaver pc = new ProjectContextSaver(hostProject);
        String deviceCoreId = pc.load("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        if (deviceCoreId == null || deviceCoreId.isEmpty()) {
            deviceCoreId = LaunchConfigurationUtil.extractHardwareCoreId(attributes);
        }
        if ((deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId)) == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        VLABSimulatorParams params = new VLABSimulatorParams();
        params.setDevice(deviceCoreDescriptor.getDeviceId());
        params.setCore(deviceCoreDescriptor.getName());
        String initializationScriptPath = DeviceCoreDebuggerDescriptors.getInitScript((String)deviceCoreDescriptor.getId(), (String)"vlabSimulator");
        params.setToolboxScriptName(initializationScriptPath);
        String clientPath = CoreDebuggerDescriptors.getClientPath((String)deviceCoreDescriptor.getCoreId(), (String)"vlabSimulator");
        params.setClientExecutable(clientPath);
        params.setPortNumber(DeviceCoreDebuggerDescriptors.getServerPort((String)deviceCoreDescriptor.getId(), (String)"vlabSimulator"));
        params.applyParams(workingCopy);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", String.valueOf(component) + ".elf");
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", hostProject.getName());
        workingCopy.setMappedResources(new IResource[]{hostProject});
    }
}

