/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.vlab.internal.core;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.vlab.core.VLABErrorMessages;
import com.nxp.s32ds.debug.ide.vlab.core.VLABServerProcess;
import com.nxp.s32ds.debug.ide.vlab.core.VLABSimulatorCoreActivator;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend_7_12;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;

public class VLABSimulatorBackend
extends GDBBackend_7_12 {
    private String pathToSimulatorExecutable;
    private String scriptName;
    private String coreName;
    private String port;
    private static final String LOAD_PARAMS_CMD_PATTERN = "load(u\"%s\", args=[\"--start-core=%s\",\"--debugger-config=%s.%s:%s\"])\n";
    private static final String RUN_SIMULATION_CMD = "run()\n";
    private static final String IMPORT_SYSTEM_PYTHON_CMD = "import sys\n";
    private static final String FLUSH_STD_OUT_CMD = "sys.stdout.flush()\n";
    private static final String FLUSH_STD_ERR_CMD = "sys.stderr.flush()\n";
    private static final String EXIT_VLAB_CMD = "exit()\n";
    private static final String VLAB_S32K286_DEVICE_ID = "S32K286";
    private static final String VLAB_PROCESS_NAME = "VLAB Simulator";
    private static final Pattern PATTERN_VLAB_LICENCE_UNAVALILABLE = Pattern.compile(".*license is not available.*");
    private static final Pattern PATTERN_GDB_SERVER_FAILED = Pattern.compile(".*Unable to start GDB Server.*");
    private static final Pattern PATTERN_VLAB_ERROR = Pattern.compile(".*Error:.*");
    private static final Pattern PATTERN_VLAB_LICENCE_ERROR = Pattern.compile(".*license error.*");
    private static final Pattern PATTERN_GDB_SERVER_STARTED = Pattern.compile(".*GDB server for.*listening on port.*");
    private static final Map<String, String> coreName2CoreParameter = new HashMap<String, String>();
    private VLABServerProcess server;
    private S32DSGdbLaunch s32dsGdbLaunch = null;
    private BufferedWriter bWriter;
    private OutputStream stdIn;
    private InputStream stdOut;
    private InputStream stdErr;
    private RcpStatusHandler consoleCloserHandler;

    static {
        coreName2CoreParameter.put("M7", "CORE2");
        coreName2CoreParameter.put("M33_0", "CORE0");
    }

    public VLABSimulatorBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        Object launch = session.getModelAdapter(ILaunch.class);
        if (launch instanceof S32DSGdbLaunch) {
            this.s32dsGdbLaunch = (S32DSGdbLaunch)launch;
        }
        this.bWriter = null;
    }

    public void initialize(RequestMonitor rm) {
        super.initialize(rm);
        this.register(new String[]{VLABSimulatorBackend.class.getName()}, new Hashtable());
    }

    public void setProcessParameters(String scriptName, String coreName, String port) {
        this.scriptName = scriptName;
        this.coreName = coreName;
        this.port = port;
    }

    public boolean launchGdbServer(String pathToSimulator) {
        boolean serverStarted = false;
        this.pathToSimulatorExecutable = pathToSimulator;
        String resolvedPathToSimulatorExecutable = DebuggerUtils.substitute((String)this.pathToSimulatorExecutable);
        File simulatorDirectory = new File(resolvedPathToSimulatorExecutable).getParentFile();
        if (simulatorDirectory == null) {
            this.postStatus("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", VLABErrorMessages.VLABStatus_wrong_path_to_simulator);
        } else {
            this.bWriter = null;
            this.server = VLABServerProcess.getInstance(new String[]{resolvedPathToSimulatorExecutable}, this.s32dsGdbLaunch, simulatorDirectory);
            if (this.server != null) {
                serverStarted = true;
                this.stdIn = this.server.getOutputStream();
                this.bWriter = new BufferedWriter(new OutputStreamWriter(this.stdIn));
                this.stdOut = this.server.getInputStreamEx();
                this.stdErr = this.server.getErrorStreamEx();
                this.consoleCloserHandler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.ui.handlers.consolesKillerStatusHandler");
            } else {
                this.postStatus("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", VLABErrorMessages.VLABStatus_can_not_create_server);
            }
        }
        return serverStarted;
    }

    public boolean runServerCommand(int initDelay) {
        boolean commandPassed = false;
        if (this.server != null) {
            this.server.setStartupWaitingTimeout(initDelay);
            String output = null;
            try {
                this.bWriter.write(IMPORT_SYSTEM_PYTHON_CMD);
                this.bWriter.flush();
                String coreParameter = coreName2CoreParameter.get(this.coreName);
                this.bWriter.write(String.format(LOAD_PARAMS_CMD_PATTERN, DebuggerUtils.substitute((String)this.scriptName), coreParameter, VLAB_S32K286_DEVICE_ID, coreParameter, this.port));
                this.bWriter.flush();
                this.flushProcessStreams();
                output = this.handleProcessOutput(this.stdOut);
                if (output != null) {
                    if (output.isEmpty()) {
                        commandPassed = true;
                    } else {
                        this.postStatus("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", output);
                    }
                }
            }
            catch (IOException iOException) {}
            if (!commandPassed) {
                if (output == null) {
                    output = this.handleProcessOutput(this.stdErr);
                    if (output != null) {
                        this.postStatus("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", output);
                    } else {
                        this.postStatus("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", VLABErrorMessages.VLABStatus_can_not_create_server);
                    }
                }
            } else {
                try {
                    this.stdErr.close();
                }
                catch (IOException iOException) {}
            }
            IProcess consoleProcess = DebugPlugin.newProcess((ILaunch)this.s32dsGdbLaunch, (Process)((Object)this.server), (String)this.getProcessName());
            consoleProcess.setAttribute(IProcess.ATTR_CMDLINE, this.getCommandLine());
            consoleProcess.setAttribute("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.gdbProcess");
        } else {
            commandPassed = true;
        }
        return commandPassed;
    }

    public boolean runSimulation() {
        boolean commandPassed = false;
        if (this.server != null) {
            try {
                this.bWriter.write(RUN_SIMULATION_CMD);
                this.bWriter.flush();
                this.flushProcessStreams();
                commandPassed = true;
            }
            catch (IOException iOException) {
                this.postStatus("com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorErrorStatusHandler", VLABErrorMessages.VLABStatus_error_cannot_run);
            }
        }
        return commandPassed;
    }

    public String getProcessName() {
        return VLAB_PROCESS_NAME;
    }

    public String getCommandLine() {
        return this.pathToSimulatorExecutable;
    }

    public File getWorkingDirectory() {
        return new File(this.pathToSimulatorExecutable).getParentFile();
    }

    public void interrupt() {
        if (this.server != null) {
            if (this.getSessionType() == SessionType.REMOTE) {
                this.server.interrupt();
            } else {
                this.server.interruptCTRLC();
            }
        }
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.stopVLABServer();
        if (DebuggerCoreActivator.debuggerStopped()) {
            try {
                this.consoleCloserHandler.handleStatus(null, (Object)this);
            }
            catch (CoreException ex) {
                DebuggerCoreActivator.log((IStatus)ex.getStatus());
            }
            this.consoleCloserHandler = null;
        }
        super.shutdown(requestMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleProcessOutput(InputStream processStream) {
        String serverOutput;
        block23: {
            serverOutput = null;
            if (processStream != null) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try {
                        InputStreamReader inputStreamReader = new InputStreamReader(processStream);
                        try {
                            try (BufferedReader bufReader = new BufferedReader(inputStreamReader);){
                                String line;
                                while (serverOutput == null && (line = bufReader.readLine()) != null) {
                                    if (this.matchPattern(line, PATTERN_VLAB_LICENCE_UNAVALILABLE)) {
                                        serverOutput = VLABErrorMessages.VLABStatus_error_no_licence;
                                        break;
                                    }
                                    if (this.matchPattern(line, PATTERN_VLAB_ERROR)) {
                                        serverOutput = this.matchPattern(line, PATTERN_VLAB_LICENCE_ERROR) ? VLABErrorMessages.VLABStatus_error_no_licence : VLABErrorMessages.VLABStatus_error_see_log;
                                        break;
                                    }
                                    if (this.matchPattern(line, PATTERN_GDB_SERVER_FAILED)) {
                                        serverOutput = NLS.bind((String)VLABErrorMessages.VLABStatus_error_port_is_busy, (Object)this.port);
                                    } else {
                                        if (!this.matchPattern(line, PATTERN_GDB_SERVER_STARTED)) continue;
                                        serverOutput = "";
                                    }
                                    break;
                                }
                            }
                            if (inputStreamReader == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStreamReader == null) throw throwable;
                            inputStreamReader.close();
                            throw throwable;
                        }
                        inputStreamReader.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    DebuggerCoreActivator.logError((String)ex.getMessage());
                }
            }
        }
        try {
            processStream.close();
            return serverOutput;
        }
        catch (IOException iOException) {}
        return serverOutput;
    }

    private boolean matchPattern(String value, Pattern pattern) {
        return pattern.matcher(value).find();
    }

    private void postStatus(String handlerId, String message) {
        try {
            RcpStatusHandlers.handleStatus((String)handlerId, (IStatus)new Status(4, "com.nxp.s32ds.debug.ide.vlab.core", message), (Object)this.s32dsGdbLaunch);
        }
        catch (CoreException coreException) {
            VLABSimulatorCoreActivator.logError("Cannot handle registered status!");
        }
    }

    private void stopVLABServer() {
        if (this.server != null) {
            if (this.server.isRunning() && this.bWriter != null) {
                try {
                    this.bWriter.write(EXIT_VLAB_CMD);
                    this.bWriter.flush();
                    this.flushProcessStreams();
                }
                catch (IOException ex) {
                    VLABSimulatorCoreActivator.log((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.vlab.core", ex.getMessage()));
                }
            }
            this.server.terminate();
            this.server = null;
        }
        if (this.bWriter != null) {
            try {
                this.bWriter.close();
            }
            catch (IOException ex) {
                VLABSimulatorCoreActivator.log((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.vlab.core", ex.getMessage()));
            }
            this.bWriter = null;
        }
    }

    private void flushProcessStreams() throws IOException {
        this.bWriter.write(FLUSH_STD_OUT_CMD);
        this.bWriter.flush();
        this.bWriter.write(FLUSH_STD_ERR_CMD);
        this.bWriter.flush();
    }
}

