/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.vlab.core;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.vlab.core.VLABSimulatorCoreActivator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.CoreException;

public class VLABServerProcess
extends Spawner {
    private BufferedInputStream bufferedInputStream = new BufferedInputStream(super.getInputStream());
    private BufferedInputStream bufferedErrorStream;
    private static S32DSGdbLaunch vlabLaunch;
    private boolean terminated;
    private int ticksCount = 60;

    public static VLABServerProcess getInstance(String[] cmdarray, S32DSGdbLaunch launch, File dir) {
        VLABServerProcess instance;
        try {
            String[] envp = launch.getLaunchEnvironment();
            instance = new VLABServerProcess(cmdarray, envp, dir);
            vlabLaunch = launch;
        }
        catch (IOException | CoreException ex) {
            instance = null;
            VLABSimulatorCoreActivator.logError(ex.getMessage());
        }
        return instance;
    }

    private VLABServerProcess(String[] cmdarray, String[] envp, File dir) throws IOException {
        super(cmdarray, envp, dir);
        this.bufferedInputStream.mark(-1);
        this.bufferedErrorStream = new BufferedInputStream(super.getErrorStream());
        this.bufferedErrorStream.mark(-1);
        this.terminated = false;
    }

    public void setStartupWaitingTimeout(int timeout) {
        this.ticksCount = timeout * 4;
    }

    public int exitValue() {
        if (!this.terminated) {
            throw new IllegalThreadStateException("Process is not terminated yet");
        }
        return super.exitValue();
    }

    public synchronized int terminate() {
        if (!DebuggerCoreActivator.debuggerStopped()) {
            vlabLaunch.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
        }
        this.terminated = true;
        return super.terminate();
    }

    public InputStream getInputStream() {
        try {
            this.bufferedInputStream.reset();
        }
        catch (IOException iOException) {}
        return this.bufferedInputStream;
    }

    public InputStream getErrorStream() {
        try {
            this.bufferedErrorStream.reset();
        }
        catch (IOException iOException) {}
        return this.bufferedErrorStream;
    }

    public InputStream getInputStreamEx() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return this.read(new byte[1]);
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ticksWaiting = 0;
                while (VLABServerProcess.this.bufferedInputStream.available() == 0) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (++ticksWaiting <= VLABServerProcess.this.ticksCount) continue;
                    return -1;
                }
                return VLABServerProcess.this.bufferedInputStream.read(b, off, len);
            }
        };
    }

    public InputStream getErrorStreamEx() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return this.read(new byte[1]);
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (VLABServerProcess.this.bufferedErrorStream.available() == 0) {
                    return -1;
                }
                return VLABServerProcess.this.bufferedErrorStream.read(b, off, len);
            }
        };
    }
}

