/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.internal.layout;

import com.nxp.s32ds.ext.sirius.layout.LayoutDirection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IspLayoutActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.nxp.s32ds.gte.isp.layout";
    public static final String ISP_LAYOUT_DIRECTION = "com.nxp.s32ds.gte.isp.layout.isp_layout_direction";
    public static final String ISP_OPTION_ALIGN_BORDERED_NODES = "com.nxp.s32ds.gte.isp.layout.isp_option_align_bordered_nodes";
    public static final String ISP_OPTION_ENABLE_STYLE_CONFIGURATION = "com.nxp.s32ds.gte.isp.layout.isp_option_enable_style_configuration";
    private static IspLayoutActivator plugin;
    private LayoutDirection layoutDirection;
    private Boolean alignBorderedNodes;
    private Boolean enableStyleConfiguration;
    private final IPropertyChangeListenerImplementation listener = new IPropertyChangeListenerImplementation();

    public Boolean getBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean(String.valueOf(object));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.listener);
    }

    public void stop(BundleContext context) throws Exception {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.listener);
        plugin = null;
        super.stop(context);
    }

    public static IspLayoutActivator getDefault() {
        return plugin;
    }

    public LayoutDirection getLayoutDirection() {
        if (this.layoutDirection == null) {
            this.layoutDirection = IspLayoutActivator.layoutDirectionFromString(this.getPreferenceStore().getString(ISP_LAYOUT_DIRECTION));
        }
        return this.layoutDirection;
    }

    public void setLayoutDirection(LayoutDirection layoutDirection) {
        this.layoutDirection = layoutDirection;
    }

    public Boolean isAlignBorderedNodes() {
        if (this.alignBorderedNodes == null) {
            this.alignBorderedNodes = this.getPreferenceStore().getBoolean(ISP_OPTION_ALIGN_BORDERED_NODES);
        }
        return this.alignBorderedNodes;
    }

    public void setAlignBorderedNodes(Boolean isDefSettings) {
        this.alignBorderedNodes = isDefSettings;
    }

    public Boolean isEnableStyleConfiguration() {
        if (this.enableStyleConfiguration == null) {
            this.enableStyleConfiguration = this.getPreferenceStore().getBoolean(ISP_OPTION_ENABLE_STYLE_CONFIGURATION);
        }
        return this.enableStyleConfiguration;
    }

    public void setEnableStyleConfiguration(Boolean enableStyleConfiguration) {
        this.enableStyleConfiguration = enableStyleConfiguration;
    }

    private static LayoutDirection layoutDirectionFromString(String value) {
        try {
            return LayoutDirection.valueOf((String)value);
        }
        catch (Exception exception) {
            return LayoutDirection.TOP_DOWN;
        }
    }

    private final class IPropertyChangeListenerImplementation
    implements IPropertyChangeListener {
        private IPropertyChangeListenerImplementation() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (IspLayoutActivator.ISP_LAYOUT_DIRECTION.equals(property)) {
                IspLayoutActivator.this.setLayoutDirection(IspLayoutActivator.layoutDirectionFromString((String)event.getNewValue()));
            } else if (IspLayoutActivator.ISP_OPTION_ALIGN_BORDERED_NODES.equals(property)) {
                IspLayoutActivator.this.setAlignBorderedNodes(IspLayoutActivator.this.getBoolean(event.getNewValue()));
            } else if (IspLayoutActivator.ISP_OPTION_ENABLE_STYLE_CONFIGURATION.equals(property)) {
                IspLayoutActivator.this.setEnableStyleConfiguration(IspLayoutActivator.this.getBoolean(event.getNewValue()));
            }
        }
    }
}

