/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.core;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.rcp.collateral.server.core.CollateralContentHandler;
import com.nxp.s32ds.rcp.collateral.server.core.CollateralServerSettings;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class CollateralServerStarterJob
extends Job {
    private static Server jettyServer;
    private static ServerConnector connector;

    public CollateralServerStarterJob() {
        super("Starting Jetty Server");
    }

    protected IStatus run(IProgressMonitor monitor) {
        jettyServer = new Server();
        connector = new ServerConnector(jettyServer);
        connector.setHost("localhost");
        jettyServer.addConnector((Connector)connector);
        Handler resourceContextHndl = this.createResourceContextHandler();
        Handler htmlContextHndl = this.createHtmlContextHandler();
        Handler s32dsContextHndl = this.createS32DSContextHandler();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        handlers.setHandlers(new Handler[]{resourceContextHndl, s32dsContextHndl, htmlContextHndl});
        jettyServer.setHandler((Handler)handlers);
        return this.startServer();
    }

    private IStatus startServer() {
        IStatus returnStatus;
        connector.setPort(CollateralServerSettings.getPort());
        try {
            jettyServer.start();
            returnStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", e.getMessage(), (Throwable)e);
            Log.log((IStatus)status);
            returnStatus = status;
        }
        return returnStatus;
    }

    private IStatus stopServer() {
        IStatus returnStatus;
        try {
            jettyServer.stop();
            returnStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", e.getMessage(), (Throwable)e);
            Log.log((IStatus)status);
            returnStatus = status;
        }
        return returnStatus;
    }

    public IStatus restartServer() {
        IStatus returnStatus = this.stopServer();
        if (returnStatus.isOK()) {
            returnStatus = this.startServer();
        }
        return returnStatus;
    }

    private Handler createHtmlContextHandler() {
        CollateralContentHandler htmlHandler = new CollateralContentHandler();
        ContextHandler htmlContextHandler = new ContextHandler();
        htmlContextHandler.setContextPath("/");
        htmlContextHandler.setHandler((Handler)htmlHandler);
        return htmlContextHandler;
    }

    private Handler createResourceContextHandler() {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        ContextHandler resourceContextHandler = new ContextHandler();
        resourceContextHandler.setContextPath("/res");
        String resFolder = CollateralServerSettings.getContentPath();
        resourceContextHandler.setResourceBase(resFolder);
        resourceContextHandler.setHandler((Handler)resourceHandler);
        return resourceContextHandler;
    }

    private Handler createS32DSContextHandler() {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        ContextHandler resourceContextHandler = new ContextHandler();
        resourceContextHandler.setContextPath("/S32DS");
        String s32dsFolder = "";
        try {
            Path s32dsPath = Paths.get(Platform.getInstallLocation().getURL().toURI());
            s32dsFolder = String.valueOf(s32dsPath.toAbsolutePath().toString()) + File.separator + ".." + File.separator + "S32DS";
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        resourceContextHandler.setResourceBase(s32dsFolder);
        resourceContextHandler.setHandler((Handler)resourceHandler);
        return resourceContextHandler;
    }
}

