/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.core;

import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import com.nxp.s32ds.rcp.collateral.CollateralListener;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralService;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class CollateralServerActivator
extends RcpBundle {
    public static final String PLUGIN_ID = "com.nxp.s32ds.rcp.collateral.server";
    private CollateralRegistry collateralRegistry;
    private static CollateralServerActivator activator;
    private ServiceTracker<CollateralService, CollateralService> collateralServiceTracker;
    private CollateralService service;
    private Set<CollateralListener> listeners;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        activator = this;
        String collateralServiceClassName = CollateralService.class.getName();
        this.collateralServiceTracker = new ServiceTracker(context, collateralServiceClassName, null);
        this.collateralServiceTracker.open();
        this.service = (CollateralService)this.collateralServiceTracker.getService();
        this.collateralRegistry = this.service.getCollateralRegistry();
        this.listeners = new HashSet<CollateralListener>();
    }

    public void stop(BundleContext context) {
        this.service = null;
        this.collateralServiceTracker.close();
        this.listeners.stream().forEach(arg_0 -> ((CollateralRegistry)this.collateralRegistry).removeCollateralListener(arg_0));
        this.collateralServiceTracker = null;
        this.collateralRegistry = null;
        activator = null;
        this.listeners.clear();
        this.listeners = null;
    }

    public static CollateralServerActivator getDefault() {
        return activator;
    }

    public static void setupCollateralRegistry() {
    }

    public CollateralRegistry getCollateralRegistry() {
        return this.collateralRegistry;
    }

    protected String getBundleId() {
        return PLUGIN_ID;
    }

    public void storeColatteralListener(CollateralListener listener) {
        this.listeners.add(listener);
    }
}

