/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.component.registry.core;

import com.nxp.s32ds.cle.runtime.component.internal.registry.core.ComponentRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.component.internal.registry.core.ComponentRegistryCoreMessages;
import com.nxp.s32ds.cle.runtime.component.registry.ArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ArchetypeRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.ArtifactDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ArtifactRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.BlockDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.BlockRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentArtifactDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentBlockDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ComponentDescriptors {
    public static ComponentRegistry getComponentRegistry() {
        ComponentRegistry componentRegistry = ComponentRegistryCoreActivator.getDefault().getComponentRegistry();
        return componentRegistry;
    }

    public static List<ComponentDescriptor> getComponentDescriptors() {
        ComponentRegistry componentRegistry = ComponentRegistryCoreActivator.getDefault().getComponentRegistry();
        return componentRegistry.getComponentDescriptors();
    }

    public static ComponentDescriptor getComponentDescriptor(String componentId) {
        ComponentRegistry componentRegistry = ComponentRegistryCoreActivator.getDefault().getComponentRegistry();
        return componentRegistry.getComponentDescriptor(componentId);
    }

    public static List<ArchetypeDescriptor> getArchetypeDescriptors(String componentId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        ComponentRegistry componentRegistry = activator.getComponentRegistry();
        ArchetypeRegistry archetypeRegistry = activator.getArchetypeRegistry();
        List componentArchetypeDescriptors = componentRegistry.getComponentArchetypeDescriptorsByComponentId(componentId);
        LinkedHashSet<String> archetypeIds = new LinkedHashSet<String>();
        for (ComponentArchetypeDescriptor componentArchetypeDescriptor : componentArchetypeDescriptors) {
            String archetypeId = componentArchetypeDescriptor.getArchetypeId();
            archetypeIds.add(archetypeId);
        }
        ArrayList<ArchetypeDescriptor> result = new ArrayList<ArchetypeDescriptor>();
        for (String archetypeId : archetypeIds) {
            ArchetypeDescriptor archetypeDescriptor = archetypeRegistry.getArchetypeDescriptor(archetypeId);
            if (archetypeDescriptor == null) continue;
            result.add(archetypeDescriptor);
        }
        return result;
    }

    public static List<BlockDescriptor> getBlockDescriptors(String componentId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        ComponentRegistry componentRegistry = activator.getComponentRegistry();
        BlockRegistry blockRegistry = activator.getBlockRegistry();
        List componentBlockDescriptors = componentRegistry.getComponentBlockDescriptorsByComponentId(componentId);
        LinkedHashSet<String> blockIds = new LinkedHashSet<String>();
        for (ComponentBlockDescriptor componentArchetypeDescriptor : componentBlockDescriptors) {
            String blockId = componentArchetypeDescriptor.getBlockId();
            blockIds.add(blockId);
        }
        ArrayList<BlockDescriptor> result = new ArrayList<BlockDescriptor>();
        for (String blockId : blockIds) {
            BlockDescriptor blockDescriptor = blockRegistry.getBlockDescriptor(blockId);
            if (blockDescriptor == null) continue;
            result.add(blockDescriptor);
        }
        return result;
    }

    public static List<ArtifactDescriptor> getArtifactDescriptors(String componentId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        ComponentRegistry componentRegistry = activator.getComponentRegistry();
        ArtifactRegistry artifactRegistry = activator.getArtifactRegistry();
        List componentArtifactDescriptors = componentRegistry.getComponentArtifactDescriptorsByComponentId(componentId);
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        for (ComponentArtifactDescriptor componentArchetypeDescriptor : componentArtifactDescriptors) {
            String artifactId = componentArchetypeDescriptor.getArtifactId();
            artifactIds.add(artifactId);
        }
        ArrayList<ArtifactDescriptor> result = new ArrayList<ArtifactDescriptor>();
        for (String artifactId : artifactIds) {
            ArtifactDescriptor blockDescriptor = artifactRegistry.getArtifactDescriptor(artifactId);
            if (blockDescriptor == null) continue;
            result.add(blockDescriptor);
        }
        return result;
    }

    public static String getComponentLabel(ComponentDescriptor componentDescriptor) {
        if (componentDescriptor == null) {
            return null;
        }
        List<ArchetypeDescriptor> archetypeDescriptors = ComponentDescriptors.getArchetypeDescriptors(componentDescriptor.getId());
        if (archetypeDescriptors.size() == 1) {
            ArchetypeDescriptor archetypeDescriptor = archetypeDescriptors.get(0);
            String label = NLS.bind((String)ComponentRegistryCoreMessages.ComponentDescriptors_archetype_component_label, (Object)archetypeDescriptor.getName(), (Object)componentDescriptor.getName());
            return label;
        }
        return componentDescriptor.getName();
    }
}

