/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.component.registry.core;

import com.nxp.s32ds.cle.runtime.component.internal.registry.core.ComponentRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.component.internal.registry.core.ComponentRegistryCoreMessages;
import com.nxp.s32ds.cle.runtime.component.registry.ArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ArchetypeRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.BlockArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.BlockDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.BlockRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentBlockDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class BlockDescriptors {
    public static BlockRegistry getBlockRegistry() {
        BlockRegistry blockRegistry = ComponentRegistryCoreActivator.getDefault().getBlockRegistry();
        return blockRegistry;
    }

    public static List<BlockDescriptor> getBlockDescriptors() {
        BlockRegistry blockRegistry = ComponentRegistryCoreActivator.getDefault().getBlockRegistry();
        return blockRegistry.getBlockDescriptors();
    }

    public static BlockDescriptor getBlockDescriptor(String archetypeId) {
        BlockRegistry blockRegistry = ComponentRegistryCoreActivator.getDefault().getBlockRegistry();
        return blockRegistry.getBlockDescriptor(archetypeId);
    }

    public static List<ArchetypeDescriptor> getArchetypeDescriptors(String blockId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        BlockRegistry blockRegistry = activator.getBlockRegistry();
        ArchetypeRegistry archetypeRegistry = activator.getArchetypeRegistry();
        List blockArchetypeDescriptors = blockRegistry.getBlockArchetypeDescriptorsByBlockId(blockId);
        LinkedHashSet<String> archetypeIds = new LinkedHashSet<String>();
        for (BlockArchetypeDescriptor blockArchetypeDescriptor : blockArchetypeDescriptors) {
            String archetypeId = blockArchetypeDescriptor.getArchetypeId();
            archetypeIds.add(archetypeId);
        }
        ArrayList<ArchetypeDescriptor> result = new ArrayList<ArchetypeDescriptor>();
        for (String archetypeId : archetypeIds) {
            ArchetypeDescriptor archetypeDescriptor = archetypeRegistry.getArchetypeDescriptor(archetypeId);
            if (archetypeDescriptor == null) continue;
            result.add(archetypeDescriptor);
        }
        return result;
    }

    public static List<ComponentDescriptor> getComponentDescriptors(String blockId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        ComponentRegistry componentRegistry = activator.getComponentRegistry();
        List componentBlockDescriptors = componentRegistry.getComponentBlockDescriptorsByBlockId(blockId);
        LinkedHashSet<String> componentIds = new LinkedHashSet<String>();
        for (ComponentBlockDescriptor componentBlockDescriptor : componentBlockDescriptors) {
            String componentId = componentBlockDescriptor.getComponentId();
            componentIds.add(componentId);
        }
        ArrayList<ComponentDescriptor> result = new ArrayList<ComponentDescriptor>();
        for (String componentId : componentIds) {
            ComponentDescriptor componentDescriptor = componentRegistry.getComponentDescriptor(componentId);
            if (componentDescriptor == null) continue;
            result.add(componentDescriptor);
        }
        return result;
    }

    public static String getBlockLabel(BlockDescriptor blockDescriptor) {
        if (blockDescriptor == null) {
            return null;
        }
        List<ComponentDescriptor> componentDescriptors = BlockDescriptors.getComponentDescriptors(blockDescriptor.getId());
        if (componentDescriptors.size() == 1) {
            ComponentDescriptor componentDescriptor = componentDescriptors.get(0);
            String label = NLS.bind((String)ComponentRegistryCoreMessages.BlockDescriptors_component_block_label, (Object)componentDescriptor.getName(), (Object)blockDescriptor.getName());
            return label;
        }
        return blockDescriptor.getName();
    }
}

