/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.component.registry.core;

import com.nxp.s32ds.cle.runtime.component.internal.registry.core.ComponentRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.component.internal.registry.core.ComponentRegistryCoreMessages;
import com.nxp.s32ds.cle.runtime.component.registry.ArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ArchetypeRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.ArtifactArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ArtifactDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ArtifactRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentArtifactDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ArtifactDescriptors {
    public static ArtifactRegistry getArtifactRegistry() {
        ArtifactRegistry artifactRegistry = ComponentRegistryCoreActivator.getDefault().getArtifactRegistry();
        return artifactRegistry;
    }

    public static List<ArtifactDescriptor> getArtifactDescriptors() {
        ArtifactRegistry artifactRegistry = ComponentRegistryCoreActivator.getDefault().getArtifactRegistry();
        return artifactRegistry.getArtifactDescriptors();
    }

    public static ArtifactDescriptor getArtifactDescriptor(String archetypeId) {
        ArtifactRegistry artifactRegistry = ComponentRegistryCoreActivator.getDefault().getArtifactRegistry();
        return artifactRegistry.getArtifactDescriptor(archetypeId);
    }

    public static List<ArchetypeDescriptor> getArchetypeDescriptors(String artifactId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        ArtifactRegistry artifactRegistry = activator.getArtifactRegistry();
        ArchetypeRegistry archetypeRegistry = activator.getArchetypeRegistry();
        List artifactArchetypeDescriptors = artifactRegistry.getArtifactArchetypeDescriptorsByArtifactId(artifactId);
        LinkedHashSet<String> archetypeIds = new LinkedHashSet<String>();
        for (ArtifactArchetypeDescriptor artifactArchetypeDescriptor : artifactArchetypeDescriptors) {
            String archetypeId = artifactArchetypeDescriptor.getArchetypeId();
            archetypeIds.add(archetypeId);
        }
        ArrayList<ArchetypeDescriptor> result = new ArrayList<ArchetypeDescriptor>();
        for (String archetypeId : archetypeIds) {
            ArchetypeDescriptor archetypeDescriptor = archetypeRegistry.getArchetypeDescriptor(archetypeId);
            if (archetypeDescriptor == null) continue;
            result.add(archetypeDescriptor);
        }
        return result;
    }

    public static List<ComponentDescriptor> getComponentDescriptors(String artifactId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        ComponentRegistry componentRegistry = activator.getComponentRegistry();
        List componentArtifactDescriptors = componentRegistry.getComponentArtifactDescriptorsByArtifactId(artifactId);
        LinkedHashSet<String> componentIds = new LinkedHashSet<String>();
        for (ComponentArtifactDescriptor componentArtifactDescriptor : componentArtifactDescriptors) {
            String componentId = componentArtifactDescriptor.getComponentId();
            componentIds.add(componentId);
        }
        ArrayList<ComponentDescriptor> result = new ArrayList<ComponentDescriptor>();
        for (String componentId : componentIds) {
            ComponentDescriptor componentDescriptor = componentRegistry.getComponentDescriptor(componentId);
            if (componentDescriptor == null) continue;
            result.add(componentDescriptor);
        }
        return result;
    }

    public static String getArtifactLabel(ArtifactDescriptor artifactDescriptor) {
        if (artifactDescriptor == null) {
            return null;
        }
        List<ComponentDescriptor> componentDescriptors = ArtifactDescriptors.getComponentDescriptors(artifactDescriptor.getId());
        if (componentDescriptors.size() == 1) {
            ComponentDescriptor componentDescriptor = componentDescriptors.get(0);
            String label = NLS.bind((String)ComponentRegistryCoreMessages.ComponentDescriptors_archetype_component_label, (Object)componentDescriptor.getName(), (Object)artifactDescriptor.getName());
            return label;
        }
        return artifactDescriptor.getName();
    }
}

