/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.component.registry.core;

import com.nxp.s32ds.cle.runtime.component.internal.registry.core.ComponentRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.component.registry.ArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ArchetypeRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.BlockArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.BlockDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.BlockRegistry;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.ComponentRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ArchetypeDescriptors {
    public static ArchetypeRegistry getArchetypeRegistry() {
        ArchetypeRegistry archetypeRegistry = ComponentRegistryCoreActivator.getDefault().getArchetypeRegistry();
        return archetypeRegistry;
    }

    public static List<ArchetypeDescriptor> getArchetypeDescriptors() {
        ArchetypeRegistry archetypeRegistry = ComponentRegistryCoreActivator.getDefault().getArchetypeRegistry();
        return archetypeRegistry.getArchetypeDescriptors();
    }

    public static ArchetypeDescriptor getArchetypeDescriptor(String archetypeId) {
        ArchetypeRegistry archetypeRegistry = ComponentRegistryCoreActivator.getDefault().getArchetypeRegistry();
        return archetypeRegistry.getArchetypeDescriptor(archetypeId);
    }

    public static List<BlockDescriptor> getBlockDescriptors(String archetypeId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        BlockRegistry blockRegistry = activator.getBlockRegistry();
        List blockArchetypeDescriptors = blockRegistry.getBlockArchetypeDescriptorsByArchetypeId(archetypeId);
        LinkedHashSet<String> blockIds = new LinkedHashSet<String>();
        for (BlockArchetypeDescriptor blockArchetypeDescriptor : blockArchetypeDescriptors) {
            String blockId = blockArchetypeDescriptor.getBlockId();
            blockIds.add(blockId);
        }
        ArrayList<BlockDescriptor> result = new ArrayList<BlockDescriptor>();
        for (String blockId : blockIds) {
            BlockDescriptor blockDescriptor = blockRegistry.getBlockDescriptor(blockId);
            if (blockDescriptor == null) continue;
            result.add(blockDescriptor);
        }
        return result;
    }

    public static List<ComponentDescriptor> getComponentDescriptors(String archetypeId) {
        ComponentRegistryCoreActivator activator = ComponentRegistryCoreActivator.getDefault();
        ComponentRegistry componentRegistry = activator.getComponentRegistry();
        List componentArchetypeDescriptors = componentRegistry.getComponentArchetypeDescriptorsByArchetypeId(archetypeId);
        LinkedHashSet<String> componentIds = new LinkedHashSet<String>();
        for (ComponentArchetypeDescriptor componentArchetypeDescriptor : componentArchetypeDescriptors) {
            String componentId = componentArchetypeDescriptor.getComponentId();
            componentIds.add(componentId);
        }
        ArrayList<ComponentDescriptor> result = new ArrayList<ComponentDescriptor>();
        for (String componentId : componentIds) {
            ComponentDescriptor componentDescriptor = componentRegistry.getComponentDescriptor(componentId);
            if (componentDescriptor == null) continue;
            result.add(componentDescriptor);
        }
        return result;
    }

    public static String getArchetypeLabel(ArchetypeDescriptor archetypeDescriptor) {
        if (archetypeDescriptor == null) {
            return null;
        }
        return archetypeDescriptor.getName();
    }
}

