/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.vlab.internal.ui;

import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorStartupTabMessages;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorAttributesValidator;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorStartupParams;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class VLABSimulatorStartupTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Startup";
    private static final String TAB_ID = "com.nxp.s32ds.debug.ide.vlab.ui.internal.startuptab";
    private static final String WORKSPACELOC_VAR = "workspace_loc";
    private Group initializationCommands;
    private Text initializationCommandsText;
    private Group loadImageAndSymbols;
    private Button loadImage;
    private Button useProjectBinaryAsImage;
    private Label projectBinaryAsImage;
    private Button useFileAsImage;
    private Text imageFilePath;
    private Button browseWorkspaceForImage;
    private Button browseFileSystemForImage;
    private Text imageOffset;
    private Button loadSymbols;
    private Button useProjectBinaryAsSymbols;
    private Label projectBinaryAsSymbols;
    private Button useFileAsSymbols;
    private Text symbolsFilePath;
    private Button browseWorkspaceForSymbols;
    private Button browseFileSystemForSymbols;
    private Text symbolsOffset;
    private Group runtimeOptions;
    private Button setPc;
    private Text setPcAt;
    private Button setBreakpoint;
    private Text setBreakpointAt;
    private Button resume;
    private Group runCommands;
    private Text runCommandsText;

    public void createControl(Composite parent) {
        ScrolledComposite scrolledComposite = SWTUtils.createScrolledComposite((Composite)parent);
        this.setControl((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createInitializationCommandsGroup(composite);
        this.createLoadImageAndSymbolsGroup(composite);
        this.createRuntimeOptions(composite);
        this.createRunCommands(composite);
    }

    private void handleBrowseWorkspaceButton(String title, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage("");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toOSString();
            String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(WORKSPACELOC_VAR, arg);
            text.setText(fileLoc);
        }
    }

    private void handleBrowseFileSystemButton(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void useFileForImageChanged() {
        boolean isFileUsed = this.useFileAsImage.getSelection();
        this.imageFilePath.setEnabled(isFileUsed);
        this.browseWorkspaceForImage.setEnabled(isFileUsed);
        this.browseFileSystemForImage.setEnabled(isFileUsed);
    }

    private void useFileForSymbolsChanged() {
        boolean isFileUsed = this.useFileAsSymbols.getSelection();
        this.symbolsFilePath.setEnabled(isFileUsed);
        this.browseWorkspaceForSymbols.setEnabled(isFileUsed);
        this.browseFileSystemForSymbols.setEnabled(isFileUsed);
    }

    public boolean isValid(ILaunchConfiguration lc) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        VLABSimulatorAttributesValidator validator = new VLABSimulatorAttributesValidator();
        VLABSimulatorStartupParams startupParams = VLABSimulatorStartupParams.getParams((ILaunchConfiguration)lc);
        ArrayList errorsAndWarnings = validator.validateStartupParameters(startupParams);
        ArrayList errors = (ArrayList)errorsAndWarnings.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (errors.size() != 0) {
            this.setErrorMessage(((IStatus)errors.get(0)).getMessage());
            return false;
        }
        if (errorsAndWarnings.size() != 0) {
            this.setWarningMessage(((IStatus)errorsAndWarnings.get(0)).getMessage());
            return true;
        }
        return true;
    }

    private void createInitializationCommandsGroup(Composite parent) {
        this.initializationCommands = SWTUtils.createGroup((Composite)parent, (int)1, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_initialization_commands_group);
        this.initializationCommandsText = SWTUtils.createWideTextWithHeightHint((Composite)this.initializationCommands, (int)2626, (boolean)true, (int)1, (int)60);
        this.initializationCommandsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorStartupTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createLoadImageAndSymbolsGroup(Composite parent) {
        this.loadImageAndSymbols = SWTUtils.createGroup((Composite)parent, (int)4, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_load_symbols_and_image_group);
        this.loadImage = SWTUtils.createButtonWithHorizontalSpan((Composite)this.loadImageAndSymbols, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_load_image_button, (int)32, (int)4);
        Composite composite = SWTUtils.createGridCellComposite((Composite)this.loadImageAndSymbols, (int)4, (int)4);
        this.useProjectBinaryAsImage = SWTUtils.createButton((Composite)composite, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_use_project_binary_button, (int)16);
        this.projectBinaryAsImage = SWTUtils.createLabelWithHorizontalSpan((Composite)composite, (String)"", (int)3);
        this.useFileAsImage = SWTUtils.createButton((Composite)composite, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_use_file_button, (int)16);
        this.imageFilePath = SWTUtils.createWideText((Composite)composite, (int)2052, (boolean)true, (int)1);
        this.imageFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorStartupTab.this.scheduleUpdateJob();
            }
        });
        this.browseWorkspaceForImage = SWTUtils.createButton((Composite)composite, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_browse_workspace_button, (int)0);
        this.browseWorkspaceForImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.handleBrowseWorkspaceButton("", VLABSimulatorStartupTab.this.imageFilePath);
            }
        });
        this.browseFileSystemForImage = SWTUtils.createButton((Composite)composite, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_browse_file_system_button, (int)0);
        this.browseFileSystemForImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.handleBrowseFileSystemButton("", VLABSimulatorStartupTab.this.imageFilePath);
            }
        });
        this.useFileAsImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.useFileForImageChanged();
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.useProjectBinaryAsImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.useFileForImageChanged();
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        SWTUtils.createLabel((Composite)this.loadImageAndSymbols, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_image_offset_hex_label);
        this.imageOffset = SWTUtils.createTextWithWidthHint((Composite)this.loadImageAndSymbols, (int)2052, (int)100, (int)3);
        this.imageOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorStartupTab.this.scheduleUpdateJob();
            }
        });
        this.imageOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = VLABSimulatorStartupTab.this.verifyHex(e);
            }
        });
        this.loadImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.doLoadImageChanged();
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.loadSymbols = SWTUtils.createButtonWithHorizontalSpan((Composite)this.loadImageAndSymbols, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_load_symbols_button, (int)32, (int)4);
        Composite composite2 = SWTUtils.createGridCellComposite((Composite)this.loadImageAndSymbols, (int)4, (int)4);
        this.useProjectBinaryAsSymbols = SWTUtils.createButton((Composite)composite2, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_use_project_binary_button, (int)16);
        this.projectBinaryAsSymbols = SWTUtils.createLabelWithHorizontalSpan((Composite)composite2, (String)"", (int)3);
        this.useFileAsSymbols = SWTUtils.createButton((Composite)composite2, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_use_file_button, (int)16);
        this.symbolsFilePath = SWTUtils.createWideText((Composite)composite2, (int)2052, (boolean)true, (int)1);
        this.symbolsFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorStartupTab.this.scheduleUpdateJob();
            }
        });
        this.browseWorkspaceForSymbols = SWTUtils.createButton((Composite)composite2, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_browse_workspace_button, (int)0);
        this.browseWorkspaceForSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.handleBrowseWorkspaceButton("", VLABSimulatorStartupTab.this.symbolsFilePath);
            }
        });
        this.browseFileSystemForSymbols = SWTUtils.createButton((Composite)composite2, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_browse_file_system_button, (int)0);
        this.browseFileSystemForSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.handleBrowseFileSystemButton("", VLABSimulatorStartupTab.this.symbolsFilePath);
            }
        });
        this.useFileAsSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.useFileForSymbolsChanged();
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.useProjectBinaryAsSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.useFileForSymbolsChanged();
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        SWTUtils.createLabel((Composite)this.loadImageAndSymbols, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_symbols_offset_hex_label);
        this.symbolsOffset = SWTUtils.createTextWithWidthHint((Composite)this.loadImageAndSymbols, (int)2052, (int)100, (int)3);
        this.symbolsOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorStartupTab.this.scheduleUpdateJob();
            }
        });
        this.symbolsOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = VLABSimulatorStartupTab.this.verifyHex(e);
            }
        });
        this.loadSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.doLoadSymbolsChanged();
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void doLoadSymbolsChanged() {
        boolean doLoadSymbols = this.loadSymbols.getSelection();
        this.useProjectBinaryAsSymbols.setEnabled(doLoadSymbols);
        this.projectBinaryAsSymbols.setEnabled(doLoadSymbols);
        this.useFileAsSymbols.setEnabled(doLoadSymbols);
        this.symbolsFilePath.setEnabled(doLoadSymbols);
        this.browseWorkspaceForSymbols.setEnabled(doLoadSymbols);
        this.browseFileSystemForSymbols.setEnabled(doLoadSymbols);
        this.symbolsOffset.setEnabled(doLoadSymbols);
    }

    private void doLoadImageChanged() {
        boolean doLoadImage = this.loadImage.getSelection();
        this.useProjectBinaryAsImage.setEnabled(doLoadImage);
        this.projectBinaryAsImage.setEnabled(doLoadImage);
        this.useFileAsImage.setEnabled(doLoadImage);
        this.imageFilePath.setEnabled(doLoadImage);
        this.browseWorkspaceForImage.setEnabled(doLoadImage);
        this.browseFileSystemForImage.setEnabled(doLoadImage);
        this.imageOffset.setEnabled(doLoadImage);
    }

    private void createRuntimeOptions(Composite parent) {
        this.runtimeOptions = SWTUtils.createGroup((Composite)parent, (int)2, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_runtime_options_group);
        this.setPc = SWTUtils.createButton((Composite)this.runtimeOptions, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_set_pc_button, (int)32);
        this.setPc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.setPcAt.setEnabled(VLABSimulatorStartupTab.this.setPc.getSelection());
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setPcAt = SWTUtils.createTextWithWidthHint((Composite)this.runtimeOptions, (int)2052, (int)100, (int)1);
        this.setPcAt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorStartupTab.this.scheduleUpdateJob();
            }
        });
        this.setPcAt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = VLABSimulatorStartupTab.this.verifyHex(e);
            }
        });
        this.setBreakpoint = SWTUtils.createButton((Composite)this.runtimeOptions, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_set_breakpoint_button, (int)32);
        this.setBreakpoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.setBreakpointAt.setEnabled(VLABSimulatorStartupTab.this.setBreakpoint.getSelection());
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setBreakpointAt = SWTUtils.createTextWithWidthHint((Composite)this.runtimeOptions, (int)2052, (int)100, (int)1);
        this.setBreakpointAt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorStartupTab.this.scheduleUpdateJob();
            }
        });
        this.resume = SWTUtils.createButton((Composite)this.runtimeOptions, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_resume_button, (int)32);
        this.resume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createRunCommands(Composite parent) {
        this.runCommands = SWTUtils.createGroup((Composite)parent, (int)1, (String)VLABSimulatorStartupTabMessages.VLABSimulatorStartupTab_run_commands_group);
        this.runCommandsText = SWTUtils.createWideTextWithHeightHint((Composite)this.runCommands, (int)2626, (boolean)true, (int)1, (int)60);
        this.runCommandsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorStartupTab.this.scheduleUpdateJob();
            }
        });
    }

    private boolean verifyHex(VerifyEvent e) {
        return Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
    }

    public String getId() {
        return TAB_ID;
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getStartupTabImage();
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        VLABSimulatorStartupParams startupParams = VLABSimulatorStartupParams.getParams((ILaunchConfiguration)lc);
        this.initializationCommandsText.setText(startupParams.getInitializationCommands());
        this.loadImage.setSelection(startupParams.isDoLoadImage());
        this.useProjectBinaryAsImage.setSelection(startupParams.isUseProjectBinaryForImage());
        this.useFileAsImage.setSelection(startupParams.isUseFileForImage());
        this.imageFilePath.setText(startupParams.getImageFileName());
        this.imageOffset.setText(startupParams.getImageOffset());
        this.loadSymbols.setSelection(startupParams.isDoLoadSymbols());
        this.useProjectBinaryAsSymbols.setSelection(startupParams.isUseProjectBinaryForSymbols());
        this.useFileAsSymbols.setSelection(startupParams.isUseFileForSymbols());
        this.symbolsFilePath.setText(startupParams.getSymbolsFileName());
        this.symbolsOffset.setText(startupParams.getSymbolsOffset());
        this.setPc.setSelection(startupParams.isDoSetPcRegister());
        this.setPcAt.setText(startupParams.getPcRegisterValue());
        this.setBreakpoint.setSelection(startupParams.isDoSetStopAt());
        this.setBreakpointAt.setText(startupParams.getStopAt());
        this.resume.setSelection(startupParams.isDoResume());
        this.runCommandsText.setText(startupParams.getRunCommands());
        ArrayList readErrors = new ArrayList();
        String programName = (String)AttributeReadingUtils.readAttribute(readErrors, (String)"org.eclipse.cdt.launch.PROGRAM_NAME", (Object)"", (ILaunchConfiguration)lc);
        if (programName != null) {
            int lastSlash = programName.indexOf(92);
            if (lastSlash >= 0) {
                programName = programName.substring(lastSlash + 1);
            }
            if ((lastSlash = programName.indexOf(47)) >= 0) {
                programName = programName.substring(lastSlash + 1);
            }
            this.projectBinaryAsImage.setText(programName);
            this.projectBinaryAsSymbols.setText(programName);
        }
        this.updateStartupTab();
        readErrors.addAll(startupParams.getReadErrors());
        if (!readErrors.isEmpty()) {
            AttributeReadingUtils.handleAttributeReadingFailure((IStatus)ErrorStatuses.getAttributesReadingFailedStatus(readErrors));
        }
    }

    private void updateStartupTab() {
        this.doLoadImageChanged();
        this.useFileForImageChanged();
        this.doLoadSymbolsChanged();
        this.useFileForSymbolsChanged();
        this.setBreakpointAt.setEnabled(this.setBreakpoint.getSelection());
        this.setPcAt.setEnabled(this.setPc.getSelection());
    }

    public void performApply(ILaunchConfigurationWorkingCopy lc) {
        VLABSimulatorStartupParams startupParams = new VLABSimulatorStartupParams();
        startupParams.setInitializationCommands(this.initializationCommandsText.getText());
        startupParams.setDoLoadImage(this.loadImage.getSelection());
        startupParams.setUseProjectBinaryForImage(this.useProjectBinaryAsImage.getSelection());
        startupParams.setUseFileForImage(this.useFileAsImage.getSelection());
        startupParams.setImageFileName(this.imageFilePath.getText().trim());
        startupParams.setImageOffset(this.imageOffset.getText().trim());
        startupParams.setDoLoadSymbols(this.loadSymbols.getSelection());
        startupParams.setUseProjectBinaryForSymbols(this.useProjectBinaryAsSymbols.getSelection());
        startupParams.setUseFileForSymbols(this.useFileAsSymbols.getSelection());
        startupParams.setSymbolsFileName(this.symbolsFilePath.getText().trim());
        startupParams.setDoSetPcRegister(this.setPc.getSelection());
        startupParams.setPcRegisterValue(this.setPcAt.getText().trim());
        startupParams.setDoSetStopAt(this.setBreakpoint.getSelection());
        startupParams.setStopAt(this.setBreakpointAt.getText().trim());
        startupParams.setDoResume(this.resume.getSelection());
        startupParams.setRunCommands(this.runCommandsText.getText());
        startupParams.applyParams(lc);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy lc) {
        VLABSimulatorStartupParams.applyDefaults((ILaunchConfigurationWorkingCopy)lc);
    }
}

