/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.vlab.internal.ui;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import com.nxp.s32ds.debug.ide.vlab.internal.ui.VLABSimulatorDebuggerTabMessages;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorAttributesValidator;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorParams;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class VLABSimulatorDebuggerTab
extends AbstractLaunchConfigurationTab {
    private static final int HOSTNAME_WIDTH_HINT = 442;
    private static final String TAB_NAME = "Debugger";
    private static final String VLAB_SIMULATOR_ID = "vlabSimulator";
    private Group hardware;
    private Label device;
    private Label core;
    private Text toolboxScriptName;
    private Group gdbClient;
    private Text clientExecutable;
    private Group gdbServer;
    private Button launchServer;
    private Text simulatorExecutable;
    private Text hostNameOrIp;
    private Text portNumber;
    private Text delayForInitialization;
    private Button forceThreadListUpdateOnSuspend;

    public void createControl(Composite parent) {
        ScrolledComposite scrolledComposite = SWTUtils.createScrolledComposite((Composite)parent);
        this.setControl((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createHardwareGroup(composite);
        this.createGdbClientGroup(composite);
        this.createVLABSimulatorGroup(composite);
        this.forceThreadListUpdateOnSuspend = SWTUtils.createButton((Composite)composite, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_force_thread_list_update_on_suspend, (int)32);
        this.forceThreadListUpdateOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createHardwareGroup(Composite parent) {
        this.hardware = SWTUtils.createGroup((Composite)parent, (int)7, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_hardware_group);
        int hardwareInfoLabelsWidth = 150;
        SWTUtils.createLabel((Composite)this.hardware, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_device_label);
        this.device = SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)"Select device", (int)hardwareInfoLabelsWidth);
        SWTUtils.createLabel((Composite)this.hardware, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_core_label);
        this.core = SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)"Select core", (int)hardwareInfoLabelsWidth);
        Button selectDeviceAndCore = SWTUtils.createButton((Composite)this.hardware, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_select_device_and_core_button, (int)0);
        Composite local = SWTUtils.createGridCellComposite((Composite)this.hardware, (int)7, (int)4);
        SWTUtils.createLabel((Composite)local, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_toolbox_script_name_label);
        this.toolboxScriptName = SWTUtils.createWideText((Composite)local, (int)2052, (boolean)true, (int)1);
        this.toolboxScriptName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorDebuggerTab.this.scheduleUpdateJob();
            }
        });
        selectDeviceAndCore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstResult;
                ILabelProvider decoratingProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(VLABSimulatorDebuggerTab.this.getShell(), decoratingProvider);
                dialog.setTitle(VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_select_target_device_and_core_dialog);
                dialog.setMessage(VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_select_target_device_and_core_dialog_hint);
                dialog.setMultipleSelection(false);
                Object[] deviceDebuggers = DebuggerUtils.retrieveDeviceCoreDebuggerDescriptors((String)VLABSimulatorDebuggerTab.VLAB_SIMULATOR_ID);
                dialog.setElements(deviceDebuggers);
                dialog.setIgnoreCase(true);
                if (dialog.open() == 0 && (firstResult = dialog.getFirstResult()) instanceof DeviceCoreDescriptor) {
                    DeviceCoreDescriptor deviceCoreDescriptor = (DeviceCoreDescriptor)firstResult;
                    VLABSimulatorDebuggerTab.this.device.setText(deviceCoreDescriptor.getDeviceId());
                    VLABSimulatorDebuggerTab.this.core.setText(deviceCoreDescriptor.getName());
                    VLABSimulatorDebuggerTab.this.clientExecutable.setText(DebuggerUtils.retrieveGdbClientVariable((String)DebuggerUtils.retrieveCoreType((DeviceCoreDescriptor)deviceCoreDescriptor), (String)VLABSimulatorDebuggerTab.VLAB_SIMULATOR_ID));
                    VLABSimulatorDebuggerTab.this.toolboxScriptName.setText(DebuggerUtils.retrieveInitializationScriptPath((DeviceCoreDescriptor)deviceCoreDescriptor, (String)VLABSimulatorDebuggerTab.VLAB_SIMULATOR_ID));
                }
                VLABSimulatorDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browse = SWTUtils.createButtonWithHorizontalSpan((Composite)local, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_browse_button, (int)0, (int)1);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorDebuggerTab.this.browseButtonSelected(VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_browse_script_title, VLABSimulatorDebuggerTab.this.toolboxScriptName);
            }
        });
        Button variables = SWTUtils.createButtonWithHorizontalSpan((Composite)local, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_variables_button, (int)0, (int)1);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorDebuggerTab.this.variablesButtonSelected(VLABSimulatorDebuggerTab.this.toolboxScriptName);
            }
        });
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        VLABSimulatorAttributesValidator validator = new VLABSimulatorAttributesValidator();
        VLABSimulatorParams debuggerParams = VLABSimulatorParams.getParams((ILaunchConfiguration)config);
        ArrayList errorsAndWarnings = validator.validateDebuggerParameters(debuggerParams);
        ArrayList errors = (ArrayList)errorsAndWarnings.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (errors.size() != 0) {
            this.setErrorMessage(((IStatus)errors.get(0)).getMessage());
            return false;
        }
        if (errorsAndWarnings.size() != 0) {
            this.setWarningMessage(((IStatus)errorsAndWarnings.get(0)).getMessage());
            return true;
        }
        return true;
    }

    private boolean verifyNumber(VerifyEvent e) {
        return Character.isDigit(e.character) || Character.isISOControl(e.character);
    }

    private void createVLABSimulatorGroup(Composite parent) {
        this.gdbServer = SWTUtils.createGroup((Composite)parent, (int)4, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_vlab_simulator_group);
        this.launchServer = SWTUtils.createButtonWithHorizontalSpan((Composite)this.gdbServer, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_launch_server_button, (int)32, (int)4);
        this.launchServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        SWTUtils.createLabel((Composite)this.gdbServer, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_simulator_executable_label);
        this.simulatorExecutable = SWTUtils.createWideText((Composite)this.gdbServer, (int)2052, (boolean)true, (int)1);
        this.simulatorExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorDebuggerTab.this.scheduleUpdateJob();
            }
        });
        Button browse = SWTUtils.createButton((Composite)this.gdbServer, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorDebuggerTab.this.browseButtonSelected(VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_choose_simulator_dialog, VLABSimulatorDebuggerTab.this.simulatorExecutable);
            }
        });
        Button variables = SWTUtils.createButton((Composite)this.gdbServer, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_variables_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorDebuggerTab.this.variablesButtonSelected(VLABSimulatorDebuggerTab.this.simulatorExecutable);
            }
        });
        SWTUtils.createLabel((Composite)this.gdbServer, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_hostname_or_ip_label);
        this.hostNameOrIp = SWTUtils.createTextWithWidthHint((Composite)this.gdbServer, (int)2048, (int)442, (int)3);
        this.hostNameOrIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorDebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.gdbServer, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_port_label);
        this.portNumber = SWTUtils.createTextWithWidthHint((Composite)this.gdbServer, (int)2052, (int)40, (int)3);
        this.portNumber.setTextLimit(5);
        this.portNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.portNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                event.doit = VLABSimulatorDebuggerTab.this.verifyNumber(event);
            }
        });
        Composite local = SWTUtils.createGridCellCompositeWithVerticalMargin((Composite)this.gdbServer, (int)4, (int)3, (int)1);
        SWTUtils.createLabel((Composite)local, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_delay_for_initialization_label);
        this.delayForInitialization = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)local, (int)2052, (int)12, (int)40);
        this.delayForInitialization.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.delayForInitialization.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                event.doit = VLABSimulatorDebuggerTab.this.verifyNumber(event);
            }
        });
        SWTUtils.createLabel((Composite)local, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_delay_for_initialization_unit_of_measure);
    }

    private void createGdbClientGroup(Composite parent) {
        this.gdbClient = SWTUtils.createGroup((Composite)parent, (int)4, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_gdb_client_group);
        SWTUtils.createLabel((Composite)this.gdbClient, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_client_executable_label);
        this.clientExecutable = SWTUtils.createWideTextWithHorizontalIndent((Composite)this.gdbClient, (int)2052, (boolean)true, (int)1, (int)6);
        this.clientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VLABSimulatorDebuggerTab.this.scheduleUpdateJob();
            }
        });
        Button browse = SWTUtils.createButton((Composite)this.gdbClient, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorDebuggerTab.this.browseButtonSelected(VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_choose_client_dialog, VLABSimulatorDebuggerTab.this.clientExecutable);
            }
        });
        Button variables = SWTUtils.createButton((Composite)this.gdbClient, (String)VLABSimulatorDebuggerTabMessages.VLABSimulatorDebuggerTab_variables_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VLABSimulatorDebuggerTab.this.variablesButtonSelected(VLABSimulatorDebuggerTab.this.clientExecutable);
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.setText(dialog.getVariableExpression());
        }
    }

    public String getName() {
        return TAB_NAME;
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        VLABSimulatorParams debuggerParams = VLABSimulatorParams.getParams((ILaunchConfiguration)lc);
        this.device.setText(debuggerParams.getDevice());
        this.core.setText(debuggerParams.getCore());
        this.clientExecutable.setText(debuggerParams.getClientExecutable());
        this.simulatorExecutable.setText(debuggerParams.getSimulatorExecutable());
        this.toolboxScriptName.setText(debuggerParams.getToolboxScriptName());
        this.hostNameOrIp.setText(debuggerParams.getHostNameOrIPAddress());
        this.portNumber.setText(debuggerParams.getPortNumber());
        this.forceThreadListUpdateOnSuspend.setSelection(debuggerParams.isDoForceThreadlistUpdateOnSuspend());
        this.launchServer.setSelection(debuggerParams.isDoLaunchServer());
        this.delayForInitialization.setText(debuggerParams.getDelay());
        ArrayList readErrors = debuggerParams.getReadErrors();
        if (!readErrors.isEmpty()) {
            AttributeReadingUtils.handleAttributeReadingFailure((IStatus)ErrorStatuses.getAttributesReadingFailedStatus((List)readErrors));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy lc) {
        VLABSimulatorParams debuggerParams = new VLABSimulatorParams();
        debuggerParams.setClientExecutable(this.clientExecutable.getText().trim());
        debuggerParams.setCore(this.core.getText());
        debuggerParams.setDevice(this.device.getText());
        debuggerParams.setDoForceThreadlistUpdateOnSuspend(this.forceThreadListUpdateOnSuspend.getSelection());
        debuggerParams.setHostNameOrIPAddress(this.hostNameOrIp.getText().trim());
        debuggerParams.setPortNumber(this.portNumber.getText().trim());
        debuggerParams.setSimulatorExecutable(this.simulatorExecutable.getText().trim());
        debuggerParams.setToolboxScriptName(this.toolboxScriptName.getText().trim());
        debuggerParams.setDoLaunchServer(this.launchServer.getSelection());
        debuggerParams.setDelay(this.delayForInitialization.getText().trim());
        debuggerParams.applyParams(lc);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy lc) {
        VLABSimulatorParams.applyDefaults((ILaunchConfigurationWorkingCopy)lc);
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }
}

